<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/PixmapVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/PixmapVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;*PRAGMA LL*&gt;
</PRE> A <CODE>PixmapVBT.T</CODE> is a VBT that displays a pixmap. Its preferred
   and minimum sizes are the size of the pixmap, and its maximum size
   in each axis is very large. 

<P><PRE>INTERFACE <interface><A HREF="PixmapVBT.m3">PixmapVBT</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>;

TYPE
  <A HREF="PixmapVBT.m3#T">T</A> &lt;: Public;
  Public =
    VBT.Leaf OBJECT
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      init (pm: Pixmap.T;
            op: PaintOp.T := PaintOp.BgFg;
            bg: PaintOp.T := PaintOp.Bg): T
    END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>PixmapVBT</CODE> displaying
   pixmap <CODE>pm</CODE> using the paint op <CODE>op</CODE>, and returns <CODE>v</CODE>.  The pixmap
   is always centered within the domain of <CODE>v</CODE>, and if the domain is
   larger than the pixmap, the background is painted using the tint
   <CODE>bg</CODE>.
<P>
   When the pixmap has depth 1, <CODE>op</CODE> should be a pair of tints.
   Otherwise, a good choice for <CODE>op</CODE> is <CODE>PaintOp.Copy</CODE>. 

<P><PRE>PROCEDURE <A HREF="PixmapVBT.m3#Put">Put</A> (v: T; pm: Pixmap.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the pixmap displayed by <CODE>v</CODE> to <CODE>pm</CODE>, and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="PixmapVBT.m3#SetColors">SetColors</A> (v : T;
                     op: PaintOp.T;
                     bg: PaintOp.T   := PaintOp.Bg);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the <CODE>op</CODE> and <CODE>bg</CODE> of <CODE>v</CODE>, and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

END PixmapVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
