<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/PixmapVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/PixmapVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module>PixmapVBT</module> EXPORTS <A HREF="PixmapVBT.i3"><implements>PixmapVBT</A></implements>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        pm: Pixmap.T;
        op: PaintOp.T;
        bg: PaintOp.T;
      OVERRIDES
        init    := Init;
        shape   := Shape;
        repaint := Repaint;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v : T;
                pm: Pixmap.T;
                op: PaintOp.T  := PaintOp.BgFg;
                bg: PaintOp.T  := PaintOp.Bg    ): T =
  BEGIN
    v.pm := pm;
    v.op := op;
    v.bg := bg;
    RETURN v
  END Init;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A> (v: T; pm: Pixmap.T) =
  VAR oldRect := VBT.PixmapDomain(v, v.pm);
  BEGIN
    v.pm := pm;
    IF NOT Rect.Equal(oldRect, VBT.PixmapDomain(v, pm)) THEN
      VBT.NewShape(v);
    END;
    VBT.Mark(v);
  END Put;

PROCEDURE <A NAME="SetColors"><procedure>SetColors</procedure></A> (v: T; op: PaintOp.T; bg: PaintOp.T := PaintOp.Bg) =
  BEGIN
    v.op := op;
    v.bg := bg;
    VBT.Mark(v);
  END SetColors;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (v: T; READONLY rgn: Region.T) =
  VAR
    dom   : Rect.T;
    bounds: Rect.T;
    delta : Point.T;
    a     : Rect.Partition;
  BEGIN
    dom := VBT.Domain (v);
    bounds := VBT.PixmapDomain (v, v.pm);
    delta := Point.Sub (Rect.Middle (dom), Rect.Middle (bounds));
    Rect.Factor (
      Rect.Meet (dom, rgn.r), Rect.Move (bounds, delta), a, 0, 0);
    VBT.PaintPixmap (v, a [2], v.op, v.pm, delta);
    a [2] := Rect.Empty;
    VBT.PolyTexture (v, a, v.bg, Pixmap.Solid)
  END Repaint;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (v: T; ax: Axis.T; &lt;* UNUSED *&gt; n: CARDINAL): VBT.SizeRange =
  VAR sr: VBT.SizeRange;
  BEGIN
    sr.lo := Rect.Size(ax, VBT.PixmapDomain(v, v.pm));
    sr.pref := sr.lo;
    sr.hi := MAX(sr.pref + 1, VBT.DefaultShape.hi);
    RETURN sr;
  END Shape;

BEGIN
END PixmapVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
