<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ReactivityVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ReactivityVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> A <CODE>ReactivityVBT</CODE> is a filter that can make its child active,
   passive, dormant, and invisible.  The {\em active\/} state does
   nothing; mouse and keyboard events are relayed to child. The {\em
   passive\/} state doesn't allow mouse or keyboard events to go to
   the child. 
   The {\em dormant\/} state doesn't send mouse or keyboard events to
   the child; it also grays out the child.  The {\em vanish\/} state
   also doesn't send mouse or keyboard events to go to the child; in
   addition, it draws over the child in the background color, thereby
   making it invisible.
<P>
   When the state of a <CODE>ReactivityVBT</CODE> is set, the caller also
   specifies a cursor to be used. 
<P>
   If a VBT-descendant of a <CODE>ReactivityVBT</CODE> is painted, it will appear
   correctly.  For example, if the <CODE>ReactivityVBT</CODE> is in the vanished
   state, the descendant will not appear until the state changes; if
   the <CODE>ReactivityVBT</CODE> is in a dormant state, the descendant will be
   grayed out.
<P>
   A <CODE>ReactivityVBT</CODE> also passes on any miscellaneous events to take
   the keyboard focus to the descendant that last acquired the
   keyboard focus. 

<P><PRE>INTERFACE <interface><A HREF="ReactivityVBT.m3">ReactivityVBT</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>, <A HREF="../../ui/src/split/ETAgent.i3">ETAgent</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  State = {Active, Passive, Dormant, Vanish};
  <A HREF="ReactivityVBT.m3#T">T</A> &lt;: Public;
  Public =
    ETAgent.T OBJECT
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      init (ch: VBT.T; colors: PaintOp.ColorScheme := NIL): T;
      &lt;* LL = VBT.mu.v *&gt;
      paintDormant (r: Rect.T; colors: PaintOp.ColorScheme);
    END;
</PRE> The call <CODE>v.init(..)</CODE> initializes <CODE>v</CODE> as a <CODE>ReactivityVBT</CODE>
   with child <CODE>ch</CODE> and with an initial state of <CODE>Active</CODE>.  If
   <CODE>colors</CODE> is <CODE>NIL</CODE>, then <CODE>PaintOp.bgFg</CODE> is used instead.  The
   <CODE>colors</CODE> are used to draw the vanished and dormant states. 
<P>
   The implementation calls <CODE>v.paintDormant(r, colors)</CODE> to paint
   the part of <CODE>ch</CODE> bounded by rectangle <CODE>r</CODE> when <CODE>v</CODE>'s state
   is <CODE>Dormant</CODE>.  The ``current colors'' of <CODE>v</CODE> are passed as
   <CODE>colors</CODE>.  Initially, the current colors are those that were
   specified when the <CODE>ReactivityVBT</CODE> was initialized.  They can
   be changed using the <CODE>SetColors</CODE> procedure.  The default
   method paints a <CODE>Pixmap.Gray</CODE> texture using
   <CODE>colors.transparentBg</CODE>.  

<P><PRE>PROCEDURE <A HREF="ReactivityVBT.m3#Set">Set</A> (v: T; state: State; cursor: Cursor.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change <CODE>v</CODE>'s state and cursor, and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ReactivityVBT.m3#Get">Get</A> (v: T): State;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Retrieve <CODE>v</CODE>'s current state. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ReactivityVBT.m3#SetColors">SetColors</A> (v: T; colors: PaintOp.ColorScheme);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the colors that <CODE>v</CODE> uses for the <CODE>Dormant</CODE> and <CODE>Vanish</CODE>
   states.  If <CODE>v</CODE> is currently in the <CODE>Dormant</CODE> or <CODE>Vanish</CODE>
   state, mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

END ReactivityVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
