<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ReactivityVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ReactivityVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="ReactivityVBT.i3">ReactivityVBT</A></implements></module>;

IMPORT <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/MouseSplit.i3">MouseSplit</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>, <A HREF="../../ui/src/split/FilterClass.i3">FilterClass</A>,
         <A HREF="../../ui/src/vbt/Batch.i3">Batch</A>, <A HREF="../../ui/src/vbt/BatchUtil.i3">BatchUtil</A>, <A HREF="../../ui/src/vbt/BatchRep.i3">BatchRep</A>, <A HREF="../../ui/src/split/ETAgent.i3">ETAgent</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="../../geometry/src/Point.i3">Point</A>,
         <A HREF="../../ui/src/vbt/ScrnPixmap.i3">ScrnPixmap</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        newState: State;
        newCursor: Cursor.T;
        newOp   : PaintOp.ColorScheme;
        (* state, cursor, op are protected by both VBT.mu and ch, if any: *)
        state: State;
        cursor: Cursor.T;
        op   : PaintOp.ColorScheme;
        (* lastFocus is protected by v *)
        lastFocus: VBT.T := NIL
      OVERRIDES
      (* of ReactivityVBT methods: *)
        init         := Init;
        paintDormant := PaintDormant;
      (* of VBT methods: *)
        capture    := Capture;
        paintbatch := PaintBatch;
        reshape    := Reshape;
        redisplay  := Redisplay;
        repaint    := Repaint;
        locate     := Locate;
        key        := Key;
        misc       := Misc;
        acquire    := Acquire;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; ch: VBT.T; colors: PaintOp.ColorScheme := NIL): T =
  BEGIN
    EVAL ETAgent.T.init (v, ch);
    v.state := State.Active;
    v.newState := State.Active;
    v.cursor := Cursor.DontCare;
    v.newCursor := Cursor.DontCare;
    IF colors = NIL THEN colors := PaintOp.bgFg END;
    v.op := colors;
    v.newOp := colors;
    RETURN v
  END Init;

PROCEDURE <A NAME="PaintDormant"><procedure>PaintDormant</procedure></A> (v: T; r: Rect.T; colors: PaintOp.ColorScheme) =
  BEGIN
    VBT.PaintTexture (v, r, colors.transparentBg, Pixmap.Gray, Point.Origin)
  END PaintDormant;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A> (v: T; state: State; cursor: Cursor.T) =
  BEGIN
    v.newState := state;
    v.newCursor := cursor;
    IF v.state # state OR v.cursor # cursor THEN VBT.Mark (v) END
  END Set;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (v: T): State =
  BEGIN
    RETURN v.state
  END Get;

PROCEDURE <A NAME="SetColors"><procedure>SetColors</procedure></A> (v: T; colors: PaintOp.ColorScheme) =
  BEGIN
    v.newOp := colors;
    IF v.newOp # v.op AND v.state &gt;= State.Dormant THEN VBT.Mark (v) END
  END SetColors;

PROCEDURE <A NAME="Capture"><procedure>Capture</procedure></A> (               v : T;
                   &lt;* UNUSED *&gt; ch  : VBT.T;
                       READONLY rect: Rect.T;
                       VAR      br  : Region.T): ScrnPixmap.T =
  BEGIN
    IF v.state = State.Active THEN
      RETURN VBT.Capture(v, rect, br)
    ELSE
      br := Region.FromRect(rect);
      RETURN NIL
    END
  END Capture;

PROCEDURE <A NAME="UpdateStateAndFixCursor"><procedure>UpdateStateAndFixCursor</procedure></A> (    v            : T;
                                   VAR state, ostate: State;
                                   VAR op, oop      : PaintOp.ColorScheme) =
  VAR cursor := v.newCursor;
      ocursor := v.cursor;
  BEGIN
    state := v.newState;
    ostate := v.state;
    op := v.newOp;
    oop := v.op;
    IF v.ch # NIL THEN
      LOCK v.ch DO
        v.op := v.newOp;
        v.cursor := v.newCursor;
        v.state := v.newState
      END
    ELSE
      v.op := v.newOp;
      v.cursor := v.newCursor;
      v.state := v.newState
    END;
    IF state # ostate THEN
      IF state = State.Active OR ostate = State.Active THEN
        MouseSplit.InvalidateCache(v)
      END
    END;
    IF cursor # ocursor THEN
      VBT.SetCursor(v, cursor);
    END
  END UpdateStateAndFixCursor;

PROCEDURE <A NAME="Redisplay"><procedure>Redisplay</procedure></A> (v: T) =
  VAR
    cdP          : VBT.ReshapeRec;
    state, ostate: State;
    op, oop      : PaintOp.ColorScheme;
  BEGIN
    IF (v.ch = NIL) OR NOT Rect.Equal(VBT.Domain(v.ch), VBT.Domain(v)) THEN
      cdP.new := VBT.Domain(v);
      cdP.prev := cdP.new;
      cdP.saved := Rect.Empty;
      cdP.marked := TRUE;
      Reshape(v, cdP);
      RETURN
    END;
    UpdateStateAndFixCursor(v, state, ostate, op, oop);
    IF ((state &gt;= State.Dormant) OR (ostate &gt;= State.Dormant))
         AND ((state # ostate) OR (op # oop)) THEN
      IF (state = State.Dormant) AND (ostate # State.Vanish) THEN
        v.paintDormant (Rect.Full, op)
      ELSIF state = State.Vanish THEN
        VBT.PaintTexture(v, Rect.Full, op.bg, Pixmap.Solid, Point.Origin)
      ELSE
        VBTClass.Repaint(v, Region.FromRect(VBT.Domain(v)))
      END
    END
  END Redisplay;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (v: T; READONLY cd: VBT.ReshapeRec) =
  VAR
    cdP          : VBT.ReshapeRec;
    state, ostate: State;
    op, oop      : PaintOp.ColorScheme;
  BEGIN
    cdP := cd;
    UpdateStateAndFixCursor (v, state, ostate, op, oop);
    IF state &gt;= State.Dormant THEN cdP.saved := Rect.Empty END;
    ETAgent.T.reshape (v, cdP);
    IF state = State.Vanish THEN
      VBT.PaintTexture (v, Rect.Full, op.bg, Pixmap.Solid, Point.Origin)
    END
  END Reshape;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (v: T; READONLY bad: Region.T) =
  BEGIN
    IF v.state = State.Vanish THEN
      VBT.PaintTexture (v, bad.r, v.op.bg, Pixmap.Solid, Point.Origin)
    ELSE
      ETAgent.T.repaint (v, bad)
    END
  END Repaint;

PROCEDURE <A NAME="Locate"><procedure>Locate</procedure></A> (v: T; READONLY pt: Point.T; VAR (* out*) r: Rect.T):
  VBT.T =
  BEGIN
    IF v.state # State.Active THEN
      r := Rect.Full;
      RETURN NIL
    ELSE
      RETURN ETAgent.T.locate (v, pt, r)
    END
  END Locate;

PROCEDURE <A NAME="PaintBatch"><procedure>PaintBatch</procedure></A> (v: T; ch: VBT.T; ba: Batch.T) =
  VAR rect: Rect.T;
  BEGIN
    IF v.state &lt; State.Dormant THEN
      VBTClass.PaintBatch(v, ba)
    ELSIF v.state = State.Vanish THEN
      Batch.Free(ba)
    ELSE
      BatchUtil.Tighten(ba);
      IF Rect.IsEmpty(ba.scrollSource) THEN
        rect := ba.clip;
        VBTClass.PaintBatch(v, ba);
        v.paintDormant (rect, v.op)
      ELSE
        VBTClass.ForceRepaint(ch, Region.FromRect(ba.clip))
      END
    END
  END PaintBatch;

PROCEDURE <A NAME="Key"><procedure>Key</procedure></A> (v: T; READONLY cd: VBT.KeyRec) =
  BEGIN
    IF v.state = State.Active THEN ETAgent.T.key (v, cd) END
  END Key;

PROCEDURE <A NAME="Acquire"><procedure>Acquire</procedure></A>(v: T; ch: VBT.T; w: VBT.T;
  s: VBT.Selection; ts: VBT.TimeStamp)
  RAISES {VBT.Error} = &lt;* LL.sup = ch *&gt;
  BEGIN
    ETAgent.T.acquire(v, ch, w, s, ts);
    IF s = VBT.KBFocus THEN
      LOCK v DO v.lastFocus := w END
    END
  END Acquire;

PROCEDURE <A NAME="Misc"><procedure>Misc</procedure></A> (v: T; READONLY cd: VBT.MiscRec) =
  &lt;* LL.sup = VBT.mu *&gt;
  VAR lastFocus, parent: VBT.T;
  BEGIN
    IF cd.type = VBT.TakeSelection AND cd.selection = VBT.KBFocus THEN
      LOCK v DO lastFocus := v.lastFocus END;                 (* CHANGED *)
      IF lastFocus # NIL THEN
        (* Is it still our descendant? *)
        parent := VBT.Parent (lastFocus); (* REQUIRES LL.sup &lt; lastFocus *)
        WHILE parent # NIL AND parent # v DO
          parent := VBT.Parent (parent)   (* REQUIRES LL.sup &lt; parent *)
        END;
        IF parent = NIL THEN   (* No. *)
          LOCK v DO v.lastFocus := NIL END                    (* CHANGED *)
        ELSE                   (* Yes. *)
          VBTClass.Misc (lastFocus, cd); RETURN
        END
      END
    END;
    ETAgent.T.misc (v, cd)
  END Misc;

BEGIN
END ReactivityVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
