<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ScaleFilter.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ScaleFilter.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> A <CODE>ScaleFilter</CODE> is a multi-filter whose child's screentype is
   the same as the parent's except that the resolution is scaled. 

<P><PRE>INTERFACE <interface><A HREF="ScaleFilter.m3">ScaleFilter</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  &lt;* SUBTYPE T &lt;: MultiFilter.T *&gt;
  <A HREF="ScaleFilter.m3#T">T</A> &lt;: Public;
  <A HREF="ScaleFilter.m3#Private">Private</A> &lt;: VBT.T;
  Public = Private OBJECT
           METHODS
             &lt;* LL.sup &lt;= VBT.mu *&gt;
             init (ch: VBT.T): T
           END;
</PRE> The call <CODE>v.init(ch)</CODE> initializes <CODE>v</CODE> as a <CODE>ScaleFilter</CODE> with
   multi-child <CODE>ch</CODE> and with horizontal and vertical scale factors 
   both equal to 1.0. 

<P> There are two ways you can use a <CODE>ScaleFilter</CODE>: Procedure <CODE>Scale</CODE> allows
   you to explicitly set a horizontal and vertical scale factor.
   Procedure <CODE>AutoScale</CODE> looks at the preferred size of the child and 
   dynamically sets the scale factors such that the child's preferred 
   size always fills its domain. 
 
<P><PRE>PROCEDURE <A HREF="ScaleFilter.m3#Scale">Scale</A> (v: T; hscale, vscale: REAL);
&lt;* LL.sup = VBT.mu.v *&gt;
</PRE><BLOCKQUOTE><EM> Set <CODE>v</CODE>'s horizontal and vertical scale factors to be <CODE>hscale</CODE>
   and <CODE>vscale</CODE> respectively, and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>
</PRE> Thus, if the <CODE>v</CODE> has resolution of <CODE>px</CODE> and <CODE>py</CODE> horizontally
   and vertically, then the resolution of <CODE>v</CODE>'s multi-child will
   be <CODE>hscale*px</CODE> and <CODE>vscale*py</CODE>. 
<P>
   Note that the locking level of <CODE>Scale</CODE> does not
   require the full share of <CODE>VBT.mu</CODE>.  Therefore, it can be
   called from <CODE>v</CODE>'s <CODE>reshape</CODE> or <CODE>rescreen</CODE> method, for
   example, since those methods are called with only <CODE>v</CODE>'s share
   of <CODE>VBT.mu</CODE> locked. This fact is useful for the implementation
   of procedure <CODE>AutoScale</CODE>: 

<P><PRE>PROCEDURE <A HREF="ScaleFilter.m3#AutoScale">AutoScale</A> (v: T; keepAspectRatio := FALSE);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set <CODE>v</CODE>'s scale factor such that the preferred size of <CODE>v</CODE>'s
   child <CODE>ch</CODE> is scaled to fit into <CODE>VBT.Domain(ch)</CODE>.  If
   <CODE>keepAspectRatio</CODE> is <CODE>TRUE</CODE>, then <CODE>ch</CODE> is scaled by the same
   amount <CODE>f</CODE> both horizontally and vertically.  The amount <CODE>f</CODE> is
   chosen so that the preferred size of <CODE>ch</CODE> just fits in the
   larger direction of <CODE>v</CODE> and fits fine in the other
   direction. In any event, <CODE>v</CODE> is marked for redisplay. </EM></BLOCKQUOTE><PRE>
</PRE> The call to <CODE>AutoScale</CODE> has the effect of causing <CODE>Scale</CODE> to be
   called each time that <CODE>v</CODE> is reshaped. Thus, it is important that
   <CODE>Scale</CODE> have a locking level of <CODE>VBT.mu.v</CODE> rather than simply
   <CODE>VBT.mu</CODE>. 

<P><PRE>PROCEDURE <A HREF="ScaleFilter.m3#Get">Get</A>(v: T; VAR (* OUT *) hscale, vscale: REAL);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>v</CODE>'s current horizontal and vertical scale factors. </EM></BLOCKQUOTE><PRE>
</PRE> If <CODE>Scale</CODE> was called more recently than <CODE>AutoScale</CODE>, then
   <CODE>Get</CODE> returns the values passed to <CODE>Scale</CODE>.  On the other hand, if
   <CODE>AutoScale</CODE> was called more recently, then <CODE>Get</CODE> will return
   values that reflect scaling for <CODE>v</CODE>'s current domain. 

<P><PRE>END ScaleFilter.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
