<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ScaleFilter.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ScaleFilter.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE> by Steve Glassman and Greg Nelson           

<P><PRE>MODULE <module><implements><A HREF="ScaleFilter.i3">ScaleFilter</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/split/FilterClass.i3">FilterClass</A>, <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../ui/src/split/JoinScreen.i3">JoinScreen</A>,
       <A HREF="MultiFilter.i3">MultiFilter</A>, <A HREF="MultiClass.i3">MultiClass</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Palette.i3">Palette</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>,
       <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/vbt/ScrnCursor.i3">ScrnCursor</A>, <A HREF="../../ui/src/vbt/ScrnFont.i3">ScrnFont</A>, <A HREF="../../ui/src/vbt/ScrnPaintOp.i3">ScrnPaintOp</A>, <A HREF="../../ui/src/vbt/ScrnPixmap.i3">ScrnPixmap</A>,
       <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>,
       <A HREF="../../ui/src/vbt/VBTRep.i3">VBTRep</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

REVEAL
  <A NAME="Private">Private</A> = Filter.T BRANDED OBJECT END;
  <A NAME="T">T</A> = Public BRANDED OBJECT
        stNew                 : VBT.ScreenType := NIL;
        hscale, vscale                         := 1.0;
        auto                                   := FALSE;
        keepAspectRatio       : BOOLEAN;
        oldHorSize, oldVerSize                 := 0.0;
      OVERRIDES
        init     := Init;
        rescreen := Rescreen;
        reshape  := Reshape;
      END;

TYPE
  MC = MultiClass.Filter OBJECT
       OVERRIDES
         succ    := Succ;
         pred    := Succ;
         replace := Replace;
       END;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; ch: VBT.T; new: VBT.T) =
  BEGIN
    WITH holder = Filter.Child(m.vbt) DO
      &lt;* ASSERT ch = Filter.Child(holder) *&gt;
      EVAL Filter.Replace(holder, new);
    END
  END Replace;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (m: MC; ch: VBT.T): VBT.T =
  BEGIN
    WITH holder = Filter.Child(m.vbt) DO
      IF ch = NIL THEN
        RETURN Filter.Child(holder)
      ELSE
        &lt;* ASSERT ch = Filter.Child(holder) *&gt;
        RETURN NIL
      END
    END
  END Succ;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (t: T; ch: VBT.T): T =
  VAR holder := NEW(Filter.T).init(ch);
  BEGIN
    EVAL Filter.T.init(t, holder);
    MultiClass.Be(t, NEW(MC));
    MultiClass.BeChild(t, ch);
    RETURN t;
  END Init;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (t: T; READONLY cd: VBT.ReshapeRec) =
  BEGIN
    IF t.auto THEN AutoReshape(t, cd) END;
    Filter.T.reshape(t, cd)
  END Reshape;

TYPE
  ScaledScreenType =
    VBT.ScreenType OBJECT
      unscaledRes   : ARRAY Axis.T OF REAL;
      hscale, vscale                         := 1.0;
      stParent      : VBT.ScreenType;
    METHODS
      scale       (hscale, vscale: REAL) := ScaleScreenType;
      (* changes the res, scales all ScaledFonts in Palette *)
    OVERRIDES
      opApply                            := ScaleOpApply;
      cursorApply                        := ScaleCursorApply;
      pixmapApply                        := ScalePixmapApply;
      fontApply                          := ScaleFontApply;
    END;

PROCEDURE <A NAME="ScaleOpApply"><procedure>ScaleOpApply</procedure></A> (             st: ScaledScreenType;
                        &lt;* UNUSED *&gt; cl: Palette.OpClosure;
                                     op: PaintOp.T          ):
  ScrnPaintOp.T =
  BEGIN
    RETURN Palette.ResolveOp(st.stParent, op);
  END ScaleOpApply;

PROCEDURE <A NAME="ScaleCursorApply"><procedure>ScaleCursorApply</procedure></A> (             st: ScaledScreenType;
                            &lt;* UNUSED *&gt; cl: Palette.CursorClosure;
                                         cs: Cursor.T               ):
  ScrnCursor.T =
  BEGIN
    RETURN Palette.ResolveCursor(st.stParent, cs);
  END ScaleCursorApply;

PROCEDURE <A NAME="ScalePixmapApply"><procedure>ScalePixmapApply</procedure></A> (             st: ScaledScreenType;
                            &lt;* UNUSED *&gt; cl: Palette.PixmapClosure;
                                         pm: Pixmap.T               ):
  ScrnPixmap.T =
  BEGIN
    RETURN Palette.ResolvePixmap(st.stParent, pm);
  END ScalePixmapApply;

PROCEDURE <A NAME="ScaleFontApply"><procedure>ScaleFontApply</procedure></A> (st  : ScaledScreenType;
                          cl  : Palette.FontClosure;
                          font: Font.T                 ): ScrnFont.T =
  BEGIN
    IF cl =  NIL THEN
      (* builtin *)
      RETURN Palette.ResolveFont(st.stParent, font);
    ELSE
      RETURN VBT.ScreenType.fontApply(st, cl, font);
    END;
  END ScaleFontApply;

PROCEDURE <A NAME="ScaleScreenType"><procedure>ScaleScreenType</procedure></A> (st: ScaledScreenType; hscale, vscale: REAL) =
  BEGIN
    st.res[Axis.T.Hor] := st.unscaledRes[Axis.T.Hor] * hscale;
    st.hscale := hscale;
    st.res[Axis.T.Ver] := st.unscaledRes[Axis.T.Ver] * vscale;
    st.vscale := vscale;
    FOR i := 0 TO LAST(st.fonts^) DO
      TYPECASE st.fonts[i] OF
      | NULL =&gt;
      | ScaledFont (sf) =&gt; sf.scaleTo(MIN(st.hscale, st.vscale));
      ELSE
      END;
    END;
  END ScaleScreenType;

TYPE
  FontOracle =
    ScrnFont.Oracle OBJECT
      st: ScaledScreenType;
    METHODS
      lookupScaled (name: TEXT; size: REAL; initialScale: REAL := 1.0):
                    ScrnFont.T := LookupScaled;
    OVERRIDES
      match   := Match;
      list    := List;
      lookup  := Lookup;
      builtIn := BuiltIn;
    END;

PROCEDURE <A NAME="LookupScaled"><procedure>LookupScaled</procedure></A> (orc         : FontOracle;
                        name        : TEXT;
                        size        : REAL;
                        initialScale: REAL        ): ScrnFont.T =
  VAR sf := NEW(ScaledFont);
  BEGIN
    sf.orc := orc;
    sf.name := DeSize(name);
    sf.size := size;
    sf.scale := initialScale;
    TRY
      sf.matches := orc.list(sf.name, 1000);
    EXCEPT TrestleComm.Failure =&gt; sf.matches := NIL END;
    RETURN BestMatch(orc, sf);
  END LookupScaled;

TYPE
  ScaledFont = ScrnFont.T OBJECT
                 orc    : FontOracle;
                 name   : TEXT;
                 size   : REAL;
                 scale  : REAL;
                 matches: REF ARRAY OF TEXT := NIL;
                 current: ScrnFont.T;
               METHODS
                 scaleTo (scale: REAL) := ScaleFont;
               END;

PROCEDURE <A NAME="ScaleFont"><procedure>ScaleFont</procedure></A> (sf: ScaledFont; scale: REAL) =
  BEGIN
    sf.scale := scale;
    EVAL BestMatch(sf.orc, sf);
  END ScaleFont;

CONST Inf = 999999999.9;

PROCEDURE <A NAME="BestMatch"><procedure>BestMatch</procedure></A> (orc: FontOracle; sf: ScaledFont): ScrnFont.T =
  VAR
    matches       := sf.matches;
    closest: TEXT;
    dist   : REAL := Inf;
    size          := sf.size;
    scale         := sf.scale;
  BEGIN
    IF matches = NIL THEN
      sf.current := NIL;
    ELSE
      dist := Inf;
      FOR i := 0 TO LAST(matches^) DO
        WITH d = ABS(PointSize(matches[i]) - scale * size) DO
          IF d &lt; dist THEN closest := matches[i]; dist := d; END;
        END;
      END;
      TRY
        sf.current := orc.st.stParent.font.lookup(closest);
      EXCEPT
        ScrnFont.Failure, TrestleComm.Failure =&gt; sf.current := NIL
      END;
    END;
    IF sf.current = NIL THEN
      sf.current := orc.st.stParent.fonts[Font.BuiltIn.fnt]
    END;
    sf.id := sf.current.id;
    sf.metrics := sf.current.metrics;
    RETURN sf;
  END BestMatch;
</PRE> Assumes name is an X style font name, pointsize is the integer OR
   REAL!!!  after 8 <CODE>-</CODE>s 
<PRE>PROCEDURE <A NAME="PointSize"><procedure>PointSize</procedure></A> (name: TEXT): REAL =
  VAR
    rd                 := TextRd.New(name);
    int      : INTEGER := 0;
    ch       : CHAR;
    res, frac: REAL;
  BEGIN
    TRY
      FOR i := 1 TO 8 DO REPEAT UNTIL Rd.GetChar(rd) = '-'; END;
      ch := Rd.GetChar(rd);
    EXCEPT
      Rd.EndOfFile, Rd.Failure, Thread.Alerted =&gt; RETURN Inf
    END;

    TRY
      WHILE ORD(ch) &gt;= ORD('0') AND ORD(ch) &lt;= ORD('9') DO
        int := 10 * int + ORD(ch) - ORD('0');
        ch := Rd.GetChar(rd);
      END;
    EXCEPT
      Rd.EndOfFile, Rd.Failure, Thread.Alerted =&gt;
    END;

    (* slightly inaccurate conversion to floating pt *)
    IF ch = '.' THEN
      res := FLOAT(int);
      TRY
        ch := Rd.GetChar(rd);
        frac := 0.1;
        WHILE ORD(ch) &gt;= ORD('0') AND ORD(ch) &lt;= ORD('9') DO
          res := res + FLOAT(ORD(ch) - ORD('0')) * frac;
          frac := frac / 10.0;
          ch := Rd.GetChar(rd);
        END;
      EXCEPT
        Rd.EndOfFile, Rd.Failure, Thread.Alerted =&gt;
      END;
    ELSE
      (* integer measurements are in 1/10 points *)
      res := FLOAT(int) / 10.0;
    END;
    IF res = 0.0 THEN RETURN Inf ELSE RETURN res END;
  END PointSize;

PROCEDURE <A NAME="DeSize"><procedure>DeSize</procedure></A> (name: TEXT): TEXT =
  VAR
    rd       := TextRd.New(name);
    wr       := TextWr.New();
    ch: CHAR;
  &lt;* FATAL Wr.Failure, Thread.Alerted *&gt;
  BEGIN
    TRY
      (* copy up to pixelsize *)
      FOR i := 1 TO 7 DO
        ch := Rd.GetChar(rd);
        WHILE ch # '-' DO Wr.PutChar(wr, ch); ch := Rd.GetChar(rd); END;
        Wr.PutChar(wr, ch);
      END;
    EXCEPT
      Rd.EndOfFile, Rd.Failure, Thread.Alerted =&gt; RETURN name;
    END;

    TRY
      (* skip pixelsize, pointsize, hres, vres *)
      FOR i := 1 TO 4 DO
        ch := Rd.GetChar(rd);
        WHILE ch # '-' DO ch := Rd.GetChar(rd); END;
      END;
    EXCEPT
      Rd.EndOfFile, Rd.Failure, Thread.Alerted =&gt; RETURN name
    END;
    Wr.PutText(wr, &quot;*-*-*-*-&quot;);

    TRY
      (* copy spacing *)
      ch := Rd.GetChar(rd);
      WHILE ch # '-' DO Wr.PutChar(wr, ch); ch := Rd.GetChar(rd); END;
      Wr.PutChar(wr, ch);
    EXCEPT
      Rd.EndOfFile, Rd.Failure, Thread.Alerted =&gt; RETURN name;
    END;

    TRY
      (* skip average width *)
      ch := Rd.GetChar(rd);
      WHILE ch # '-' DO ch := Rd.GetChar(rd); END;
    EXCEPT
      Rd.EndOfFile, Rd.Failure, Thread.Alerted =&gt; RETURN name
    END;
    Wr.PutText(wr, &quot;*-&quot;);

    TRY
      (* copy registry *)
      ch := Rd.GetChar(rd);
      WHILE ch # '-' DO Wr.PutChar(wr, ch); ch := Rd.GetChar(rd); END;
      Wr.PutChar(wr, ch);
    EXCEPT
      Rd.EndOfFile, Rd.Failure, Thread.Alerted =&gt; RETURN name;
    END;

    LOOP
      TRY
        (* copy charset *)
        ch := Rd.GetChar(rd);
        Wr.PutChar(wr, ch);
      EXCEPT
      | Rd.EndOfFile =&gt; EXIT;
      | Rd.Failure, Thread.Alerted =&gt; RETURN name;
      END;
    END;
    RETURN TextWr.ToText(wr);
  END DeSize;

PROCEDURE <A NAME="BuiltIn"><procedure>BuiltIn</procedure></A>(orc: FontOracle; f: Font.Predefined): ScrnFont.T =
  BEGIN
    RETURN orc.st.stParent.bits.font.builtIn(f);
  END BuiltIn;

PROCEDURE <A NAME="List"><procedure>List</procedure></A> (orc: FontOracle; pat: TEXT; maxResults: INTEGER):
  REF ARRAY OF TEXT RAISES { TrestleComm.Failure} =
  BEGIN
    (* !!!!TEMPORARY (until msm fixes JoinFont oracle !!!!! *)
    IF ISTYPE (orc.st.stParent, JoinScreen.T) THEN RETURN NIL END;
    (* !!!!TEMPORARY (until msm fixes JoinFont oracle !!!!! *)
    RETURN orc.st.stParent.bits.font.list(pat, maxResults)
  END List;

PROCEDURE <A NAME="Lookup"><procedure>Lookup</procedure></A> (orc: FontOracle; name: TEXT): ScrnFont.T
  RAISES {ScrnFont.Failure, TrestleComm.Failure} =
  VAR size := PointSize(name);
  BEGIN
    (* !!!!TEMPORARY (until msm fixes JoinFont oracle !!!!! *)
    IF ISTYPE(orc.st.stParent, JoinScreen.T) THEN
      RETURN Palette.ResolveFont(orc.st.stParent, Font.BuiltIn)
    END;
    (* !!!!TEMPORARY (until msm fixes JoinFont oracle !!!!! *)
    IF size = Inf THEN
      RETURN orc.st.stParent.bits.font.lookup(name)
    ELSE
      RETURN
        orc.lookupScaled(name, size, MIN(orc.st.hscale, orc.st.vscale))
    END;
  END Lookup;

PROCEDURE <A NAME="Match"><procedure>Match</procedure></A> (             orc      : FontOracle;
                              family   : TEXT;
                 &lt;* UNUSED *&gt; pointSize: INTEGER      := 120;
                 slant     : ScrnFont.Slant := ScrnFont.Slant.Roman;
                 maxResults: CARDINAL       := 1;
                 weightName: TEXT           := ScrnFont.AnyMatch;
                 version   : TEXT           := &quot;&quot;;
                 foundry   : TEXT           := ScrnFont.AnyMatch;
                 width     : TEXT           := ScrnFont.AnyMatch;
                 &lt;* UNUSED *&gt; pixelsize: INTEGER := ScrnFont.AnyValue;
                 &lt;* UNUSED *&gt; hres, vres: INTEGER := ScrnFont.ScreenTypeResolution;
                 spacing: ScrnFont.Spacing := ScrnFont.Spacing.Any;
                 &lt;* UNUSED *&gt; averageWidth: INTEGER := ScrnFont.AnyValue;
                 charsetRegistry: TEXT := &quot;ISO8859&quot;;
                 charsetEncoding: TEXT := &quot;1&quot;        ): REF ARRAY OF TEXT
  RAISES {TrestleComm.Failure} =
  BEGIN
    (* !!!!TEMPORARY (until msm fixes JoinFont oracle !!!!! *)
    IF ISTYPE(orc.st.stParent, JoinScreen.T) THEN RETURN NIL END;
    (* !!!!TEMPORARY (until msm fixes JoinFont oracle !!!!! *)
    RETURN orc.st.stParent.bits.font.match(
             family, ScrnFont.AnyValue, slant, maxResults, weightName,
             version, foundry, width, ScrnFont.AnyValue,
             ScrnFont.ScreenTypeResolution, ScrnFont.ScreenTypeResolution,
             spacing, ScrnFont.AnyValue, charsetRegistry, charsetEncoding);
  END Match;

PROCEDURE <A NAME="InitST"><procedure>InitST</procedure></A> (stNew: ScaledScreenType;  st, stBits: VBT.ScreenType;
                  hscale, vscale   : REAL            ) =
  BEGIN
    stNew.stParent := st;
    stNew.depth := st.depth;
    stNew.color := st.color;
    stNew.res := st.res;
    stNew.bg := st.bg;
    stNew.fg := st.fg;
    stNew.bits := stBits;
    stNew.op := st.op;
    stNew.cursor := st.cursor;
    stNew.font := NEW(FontOracle, st := stNew);
    stNew.pixmap := st.pixmap;
    stNew.cmap := st.cmap;
    stNew.unscaledRes := st.res;
    Palette.Init(stNew);
    stNew.scale(hscale, vscale);
  END InitST;

PROCEDURE <A NAME="NewST"><procedure>NewST</procedure></A> (st: VBT.ScreenType; hscale, vscale: REAL):
  VBT.ScreenType =
  VAR stBits, stNew: VBT.ScreenType;
  BEGIN
    stBits := NEW(ScaledScreenType);
    InitST(stBits, st.bits, stBits, hscale, vscale);
    stNew := NEW(ScaledScreenType);
    InitST(stNew, st, stBits, hscale, vscale);
    RETURN stNew;
  END NewST;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A> (t: T; READONLY cd: VBT.RescreenRec) =
  BEGIN
    t.oldHorSize := 0.0;
    t.oldVerSize := 0.0;
    Scale1(t, cd.st);
  END Rescreen;

PROCEDURE <A NAME="Scale1"><procedure>Scale1</procedure></A> (t: T; st: VBT.ScreenType) =
  BEGIN
    IF st = NIL OR (t.hscale &gt; 0.9 AND t.hscale &lt; 1.1 AND t.vscale &gt; 0.9
         AND t.vscale &lt; 1.1) THEN
      t.stNew := st
    ELSE
      t.stNew := NewST(st, t.hscale, t.vscale)
    END;
    IF t.ch # NIL THEN VBTClass.Rescreen(t.ch, t.stNew); END;
  END Scale1;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (t: T; VAR hscale, vscale: REAL) =
  BEGIN
    hscale := t.hscale;
    vscale := t.vscale;
  END Get;

PROCEDURE <A NAME="Scale"><procedure>Scale</procedure></A> (t: T; hscale, vscale: REAL) =
  BEGIN
    t.auto := FALSE;
    IF hscale # t.hscale OR vscale # t.vscale THEN
      ChangeScale(t, hscale, vscale);
    END;
  END Scale;

PROCEDURE <A NAME="ChangeScale"><procedure>ChangeScale</procedure></A> (t: T; hscale, vscale: REAL) =
  BEGIN
    t.hscale := hscale;
    t.vscale := vscale;
    TYPECASE t.stNew OF
    | NULL =&gt; IF t.st # NIL THEN Scale1(t, t.st) END;
    | ScaledScreenType (sst) =&gt; sst.scale(hscale, vscale);
    ELSE
      Scale1(t, t.st);
    END;
    VBT.NewShape(t);
    VBT.Mark(t);
  END ChangeScale;

PROCEDURE <A NAME="AutoScale"><procedure>AutoScale</procedure></A> (t: T; keepAspectRatio := FALSE) =
  BEGIN
    t.auto := TRUE;
    t.keepAspectRatio := keepAspectRatio;
    VBT.Mark(t);
  END AutoScale;

PROCEDURE <A NAME="AutoReshape"><procedure>AutoReshape</procedure></A> (t: T; READONLY cd: VBT.ReshapeRec) =
  VAR
    ch            := MultiFilter.Child(t);
    dom           := cd.new;
    sx, sy : REAL;
    horSize       := FLOAT(Rect.HorSize(dom));
    verSize       := FLOAT(Rect.VerSize(dom));
  BEGIN
    IF ch # NIL AND NOT Rect.IsEmpty(dom) THEN
      IF t.oldHorSize = 0.0 AND t.oldVerSize = 0.0 THEN
        VAR sz := VBTClass.GetShapes(ch, TRUE);
        BEGIN
          IF sz[Axis.T.Hor].pref = 0 OR sz[Axis.T.Ver].pref = 0 THEN
            sx := 1.0;
            sy := 1.0;
          ELSE
            sx := horSize / FLOAT(sz[Axis.T.Hor].pref);
            sy := verSize / FLOAT(sz[Axis.T.Ver].pref);
          END;
        END;
      ELSE
        sx := horSize / t.oldHorSize;
        sy := verSize / t.oldVerSize;
      END;
      IF t.keepAspectRatio THEN sx := MIN(sx, sy); sy := sx; END;
      IF sx &lt; 0.95 OR sx &gt; 1.05 OR sy &lt; 0.95 OR sy &gt; 1.05 THEN
        t.oldHorSize := horSize;
        t.oldVerSize := verSize;
        ChangeScale(t, t.hscale * sx, t.vscale * sy);
      END;
    END;
  END AutoReshape;

BEGIN
END ScaleFilter.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
