<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ScrollerVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ScrollerVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> A <CODE>ScrollerVBT</CODE> is a scrollbar with an orientation along an {\em
   axis}.  For the sake of brevity in this interface, we'll only talk
   about vertical scrollers.  For horizontal scrollers, replace
   phrases like {\it top and bottom edges} by {\it left and right
   edges}, and so on.
<P>
   Like a <CODE>NumericVBT</CODE>, a <CODE>ScrollerVBT</CODE> provides a {\em
   bounded-value\/} abstraction.  That is, a <CODE>ScrollerVBT</CODE> has a {\it
   value\/} associated with it, and that value is guaranteed to stay
   within some bounds.  Various user gestures change the value and
   invoke a <CODE>callback</CODE> method on the <CODE>ScrollerVBT</CODE>.  The callback
   method can inquire the value of the scrollbar, and can change the
   value and bounds.
<P>
   Visually, a scrollbar contains a {\em stripe} that spans some
   fraction of the height of the scrollbar and is slightly
   narrower than the scrollbar.  The stripe represents the value
   of the scrollbar.  Various user-gestures cause the stripe to
   move.
<P>
   More specifically, the state of a <CODE>ScrollerVBT</CODE> consists of
   five integer quantities: <CODE>min</CODE>, <CODE>max</CODE>, <CODE>thumb</CODE>, <CODE>step</CODE>, and
   <CODE>value</CODE>.  The <CODE>value</CODE> is guaranteed to stay in the range <CODE>[min
   ..  max-thumb]</CODE>.  Visually, the <CODE>value</CODE> is represented by the
   position (top edge) of a stripe in the scroller, and <CODE>thumb</CODE>
   by the length of the stripe.  The amount that <CODE>value</CODE> should
   change when continuous scrolling is given by <CODE>step</CODE>, the {\em
   stepping} amount.
<P>
   Although each <CODE>VBT</CODE> class that uses a <CODE>ScrollerVBT</CODE> is free to
   associate any meaning with the length of the stripe, the
   following convention is suggested for using scrollbars to view
   an object:
<P>
   \begin{quote}
<P>
   The ratio of the height of the stripe to the height of the
   scrollbar should be the same as the ratio of the amount of the
   object visible vertically to its entire height.  The position
   of top of the stripe reflects the position of top of the view
   of the object within the entire object.
<P>
   \end{quote}
<P>
   Here is some terminology and the user-interface provided by a
   <CODE>ScrollerVBT</CODE>:
<P>
   \begin{itemize} \item To {\em scroll}\index{scrolling} means
   to left-click or right-click in the scrollbar.
<P>
   \item You need to release the button relatively quickly, or else
   you'll start {\em continuous scrolling}.  You stop continuous
   scrolling by releasing the button, by chord-cancelling\index{chord}
   or by moving the mouse.
<P>
   \item When you move the mouse, you are then using {\em proportional
   scrolling}.  This means that the more that you move the mouse
   vertically, the more the stripe will be moved in the direction of
   the mouse movement.  You stop proportional scrolling by upclicking
   or chord-cancelling.
<P>
   \item The left and right buttons are inverses: the left button
   moves the stripe downward and the right button moves the stripe
   upward.
<P>
   \item You {\em thumb}\index{thumb} with a middle-click.  The top of
   the stripe moves to the position of the cursor.  Thus, middle-click
   above the top of the stripe moves the stripe up, and middle-click
   below the top moves the stripe down.
<P>
   \item Middle-drag causes {\em continuous thumbing}.  As you drag to
   a new position, the top of the stripe moves to match the current
   cursor position.  You stop continuous thumbing by middle-upclicking
   or chord-canceling.
<P>
   \end{itemize}
<P>
   If you want a different user interface, you need to subclass
   various methods (e.g., a <CODE>thumb</CODE>, <CODE>scroll</CODE>, <CODE>autoscroll</CODE>) of the
   scrollbar.  These methods are defined in the <CODE>ScrollerVBTClass</CODE>
   interface. 

<P><PRE>INTERFACE <interface><A HREF="ScrollerVBT.m3">ScrollerVBT</A></interface>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="ScrollerVBT.m3#T">T</A> &lt;: Public;
  <A HREF="ScrollerVBT.m3#Private">Private</A> &lt;: VBT.T;
  Public = Private OBJECT
           METHODS
             &lt;* LL.sup = VBT.mu *&gt;
             init (axis  : Axis.T;
                   min   : INTEGER;
                   max   : INTEGER;
                   colors: PaintOp.ColorQuad;
                   step  : CARDINAL            := 1;
                   thumb : CARDINAL            := 0  ): T;
             &lt;* LL = VBT.mu *&gt;
             callback (READONLY cd: VBT.MouseRec);
           END;
</PRE> The call to <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a
   <CODE>ScrollerVBT</CODE> in the <CODE>axis</CODE> orientation.  It is
   displayed using <CODE>colors</CODE>.
<P>
   The implementation calls <CODE>v.callback(cd)</CODE> after <CODE>v</CODE>'s value
   has been changed by the user; it is not called when the value
   is changed as the result of calls to <CODE>Put</CODE> or <CODE>PutBounds</CODE>.
   The default <CODE>callback</CODE> method is a no-op. 

<P><PRE>PROCEDURE <A HREF="ScrollerVBT.m3#Put">Put</A> (v: T; n: INTEGER);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the value of <CODE>v</CODE>, projected to <CODE>[min .. max-thumb]</CODE>, and
   mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ScrollerVBT.m3#PutBounds">PutBounds</A> (v    : T;
                     min  : INTEGER;
                     max  : INTEGER;
                     thumb: CARDINAL  := 0);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Set the bounds, project <CODE>v</CODE>'s value into <CODE>[min .. max-thumb]</CODE>, and
   mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ScrollerVBT.m3#PutStep">PutStep</A> (v: T; step: CARDINAL);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the amount that <CODE>v</CODE>'s value should change while
   continuous scrolling to <CODE>step</CODE>.  If <CODE>step = 0</CODE>, scrolling will
   be disabled. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ScrollerVBT.m3#Get">Get</A>      (v: T): INTEGER;  &lt;* LL.sup = VBT.mu *&gt;
PROCEDURE <A HREF="ScrollerVBT.m3#GetMin">GetMin</A>   (v: T): INTEGER;  &lt;* LL.sup = VBT.mu *&gt;
PROCEDURE <A HREF="ScrollerVBT.m3#GetMax">GetMax</A>   (v: T): INTEGER;  &lt;* LL.sup = VBT.mu *&gt;
PROCEDURE <A HREF="ScrollerVBT.m3#GetThumb">GetThumb</A> (v: T): CARDINAL; &lt;* LL.sup = VBT.mu *&gt;
PROCEDURE <A HREF="ScrollerVBT.m3#GetStep">GetStep</A>  (v: T): CARDINAL; &lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return the current <CODE>value</CODE>, <CODE>min</CODE>, <CODE>max</CODE>, <CODE>thumb</CODE>, and
   <CODE>step</CODE>. </EM></BLOCKQUOTE><PRE>

END ScrollerVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
