<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ScrollerVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ScrollerVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;

MODULE <module><implements><A HREF="ScrollerVBT.i3">ScrollerVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="ScrollerVBTClass.i3">ScrollerVBTClass</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="Private">Private</A> = ScrollerVBTClass.T BRANDED OBJECT END;
  <A NAME="T">T</A> = Public BRANDED OBJECT
        min, max, value: INTEGER;
        step, stripe   : CARDINAL;
      OVERRIDES
        init       := Init;
        callback   := Callback;
        scroll     := Scroll;
        autoScroll := Auto;
        thumb      := Thumb;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v     : T;
                axis  : Axis.T;
                min   : INTEGER;
                max   : INTEGER;
                colors: PaintOp.ColorQuad;
                step  : CARDINAL            := 1;
                thumb : CARDINAL            := 0  ): T =
  BEGIN
    EVAL ScrollerVBTClass.T.init(v, axis, colors);
    max := MAX(min, max);
    v.min := min;
    v.max := max;
    v.value := (min + max) DIV 2;
    v.step := step;
    v.stripe := MIN(thumb, max - min);
    UpdateScroller(v);
    RETURN v
  END Init;

PROCEDURE <A NAME="Callback"><procedure>Callback</procedure></A> (&lt;* UNUSED *&gt;          v : T;
                    &lt;* UNUSED *&gt; READONLY cd: VBT.MouseRec) =
  BEGIN
  END Callback;

PROCEDURE <A NAME="Scroll"><procedure>Scroll</procedure></A> (         v         : T;
                  READONLY cd        : VBT.MouseRec;
                           part      : INTEGER;
                           height    : INTEGER;
                           towardsEOF: BOOLEAN       ) =
  &lt;* LL = VBT.mu *&gt;
  VAR
    total: INTEGER := MAX(part, MAX(1, height - 1));
    delta: INTEGER := MAX(1, (part * v.stripe + (v.stripe DIV 2))
                               DIV total);
  BEGIN
    IF NOT towardsEOF THEN delta := -delta END;
    IF Project(v, v.value + delta) THEN
      UpdateScroller(v);
      v.callback(cd);
    END;
  END Scroll;

PROCEDURE <A NAME="Auto"><procedure>Auto</procedure></A> (         v : T;
                READONLY cd: VBT.MouseRec;
                &lt;* UNUSED *&gt; linesToScroll: CARDINAL;
                             towardsEOF   : BOOLEAN   ) =
  &lt;* LL = VBT.mu *&gt;
  VAR delta: INTEGER := v.step;
  BEGIN
    IF NOT towardsEOF THEN delta := -delta END;
    IF Project(v, v.value + delta) THEN
      UpdateScroller(v);
      v.callback(cd);
    END;
  END Auto;

PROCEDURE <A NAME="Thumb"><procedure>Thumb</procedure></A> (         v     : T;
                 READONLY cd    : VBT.MouseRec;
                          part  : INTEGER;
                          height: INTEGER       ) =
  &lt;* LL = VBT.mu *&gt;
  VAR total := MAX(part, MAX(1, height - 1));
  BEGIN
    IF Project(v, v.min + part * (v.max - v.min) DIV total) THEN
      UpdateScroller(v);
      v.callback(cd);
    END
  END Thumb;

PROCEDURE <A NAME="UpdateScroller"><procedure>UpdateScroller</procedure></A> (v: T) =
  &lt;* LL = VBT.mu *&gt;
  VAR
    start  := v.value - v.min;
    length := v.max - v.min;
    end    := start + v.stripe;
  BEGIN
    ScrollerVBTClass.Update(v, start, end, length);
  END UpdateScroller;

PROCEDURE <A NAME="Project"><procedure>Project</procedure></A> (v: T; newValue: INTEGER): BOOLEAN =
  VAR oldValue := v.value;
  BEGIN
    v.value := MIN (MAX (newValue, v.min), v.max - v.stripe);
    RETURN oldValue # v.value
  END Project;

PROCEDURE <A NAME="Put"><procedure>Put</procedure></A> (v: T; n: INTEGER) =
  BEGIN
    IF Project(v, n) THEN UpdateScroller(v) END;
  END Put;

PROCEDURE <A NAME="PutBounds"><procedure>PutBounds</procedure></A> (v    : T;
                     min  : INTEGER;
                     max  : INTEGER;
                     thumb: CARDINAL  := 0) =
  BEGIN
    v.min := min;
    v.max := MAX(min, max);
    v.stripe := MIN(thumb, max - min);
    UpdateScroller(v)
  END PutBounds;

PROCEDURE <A NAME="PutStep"><procedure>PutStep</procedure></A> (v: T; step: CARDINAL) =
  BEGIN
    v.step := step
  END PutStep;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (v: T): INTEGER =
  BEGIN
    RETURN v.value
  END Get;

PROCEDURE <A NAME="GetMin"><procedure>GetMin</procedure></A> (v: T): INTEGER =
  BEGIN
    RETURN v.min
  END GetMin;

PROCEDURE <A NAME="GetMax"><procedure>GetMax</procedure></A> (v: T): INTEGER =
  BEGIN
    RETURN v.max
  END GetMax;

PROCEDURE <A NAME="GetThumb"><procedure>GetThumb</procedure></A> (v: T): CARDINAL =
  BEGIN
    RETURN v.stripe
  END GetThumb;

PROCEDURE <A NAME="GetStep"><procedure>GetStep</procedure></A> (v: T): CARDINAL =
  BEGIN
    RETURN v.step
  END GetStep;

BEGIN
END ScrollerVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
