<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ScrollerVBTClass.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ScrollerVBTClass.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> The <CODE>ScrollerVBTClass</CODE> interface allows you to customize the
   user interface of a scrollbar. 

<P><PRE>INTERFACE <interface><A HREF="ScrollerVBTClass.m3">ScrollerVBTClass</A></interface>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="ScrollerVBT.i3">ScrollerVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  ScrollerVBT.Private &lt;: T;

TYPE
  <A HREF="ScrollerVBTClass.m3#T">T</A> &lt;: Public;
  Public =
    VBT.Leaf OBJECT
    METHODS
      &lt;* LL.sup = VBT.mu *&gt;
      init (axis := Axis.T.Ver; colors: PaintOp.ColorQuad := NIL): T;
      &lt;* LL = VBT.mu *&gt;
      scroll (READONLY cd        : VBT.MouseRec;
                       part      : INTEGER;
                       height    : INTEGER;
                       towardsEOF: BOOLEAN       );
      autoScroll (READONLY cd           : VBT.MouseRec;
                           linesToScroll: CARDINAL;
                           towardsEOF   : BOOLEAN       );
      thumb (READONLY cd: VBT.MouseRec; part: INTEGER; height: INTEGER);

    END;
</PRE> The call to <CODE>v.init(axis, colors)</CODE> initializes <CODE>v</CODE> as a
   <CODE>ScrollerVBT</CODE> in the <CODE>axis</CODE> orientation, and returns <CODE>v</CODE>.
   It is displayed using <CODE>colors</CODE>.  If <CODE>colors</CODE> is <CODE>NIL</CODE>,
   <CODE>PaintOp.bgFg</CODE> will be used.
<P>
   The default methods for <CODE>scroll</CODE>, <CODE>autoScroll</CODE>, and <CODE>thumb</CODE>
   are no-ops: the stripe within the scroller doesn't change.
<P>
   When the user scrolls, the implementation calls
<PRE>
      v.scroll(cd, part, height, towardsEOF)
   </PRE>
on the up-click.  <CODE>cd</CODE> is the mouse event; <CODE>height</CODE> is the number
   of pixels in the domain of <CODE>v</CODE> in the <CODE>v.axis</CODE> orientation.  <CODE>part</CODE>
   is number of pixels away from the top/left edge that the upclick
   happened.  <CODE>towardEOF</CODE> is <CODE>TRUE</CODE> when invoked from a left-upclick,
   <CODE>FALSE</CODE> when invoked from a right-upclick.  (Of these, only <CODE>cd</CODE>
   is really needed; the others can be computed from <CODE>v</CODE> and <CODE>cd</CODE>.)
<P>
   While the user is in continuous or proportional scrolling,
   the implementation calls <CODE>v.autoScroll(...)</CODE> repeatedly.  The
   <CODE>linesToScroll</CODE> is somewhat of a misnomer (but kept for
   historical purposes).  For continuous scrolling, the value
   is always 1. For proportional scrolling, the value is the
   number of pixels the mouse has moved.  Think of
   <CODE>linesToScroll</CODE> as simply the ``amount that should be
   scrolled.'' The <CODE>cd</CODE> field in proportional scrolling is fine,
   except it's really a position event, not a mouse event, that
   caused the action (this is a good use for an <CODE>AnyEvent</CODE>, but
   for historical reasons\dots).  For continuous scrolling, <CODE>cd</CODE>
   is set to be the mouse record for the down-click that initiate
   the scrolling, but with <CODE>cd.time = 0</CODE>.
<P>
   Finally, <CODE>v.thumb(cd, part, height)</CODE> is called when the user
   thumbs or continuous thumbs.  <CODE>height</CODE> is the number of pixels
   in the domain of <CODE>v</CODE> in the <CODE>v.axis</CODE> orientation.  <CODE>part</CODE> is
   the distance in pixels between the mouse and the top/left
   edge.  The <CODE>cd</CODE> always has a valid time, cursor position, and
   modifier fields.  (OK, it isn't the real event, since
   continuous thumbing is a position event whereas thumbing is
   a mouse event.  Again, a good potential client of <CODE>AnyEvent</CODE>.)
<P>
   By and large, these methods will change the position and size
   of the stripe.  This is done using the following procedure: 

<P>
<P><PRE>PROCEDURE <A HREF="ScrollerVBTClass.m3#Update">Update</A> (v: T; start, end, length: CARDINAL);
&lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Set new values of the stripe and (if they've changed) mark <CODE>v</CODE> for
   redisplay. </EM></BLOCKQUOTE><PRE>
</PRE> The coordinate system for <CODE>start</CODE>, <CODE>end</CODE>, and <CODE>length</CODE> is as
   follows (we'll consider just a horizontal scrollbar): The left
   edge of the domain of <CODE>v</CODE> is at coordinate 0, and the right
   edge consider to be at <CODE>length</CODE>.  The stripe extends from
   <CODE>max(start,0)</CODE> to <CODE>max(min(end,length),start)</CODE>.  The
   implementation will draw a stripe to represent these
   quantities, scaled to the actual length of the scrollbar.
<P>
   The visual appearance of a <CODE>ScrollerVBT</CODE> is governed by the
   following data structures and procedures: 

<P><PRE>TYPE
  Attributes = RECORD
                 axis               : Axis.T;
                 margin             : REAL;
                 scrollPaintOps     : ARRAY Axis.T OF PaintOp.T;
                 scrollPixmaps      : ARRAY Axis.T OF Pixmap.T;
                 minStripeLen       : REAL;
                 stripeWidth        : REAL;
                 stripePaintOps     : ARRAY Axis.T OF PaintOp.T;
                 stripePixmaps      : ARRAY Axis.T OF Pixmap.T;
                 stripeBorder       : REAL;
                 stripeBorderPaintOp: PaintOp.T;
                 stripeBorderPixmap : Pixmap.T;
               END;

PROCEDURE <A HREF="ScrollerVBTClass.m3#GetAttributes">GetAttributes</A> (v: T): Attributes;
</PRE><BLOCKQUOTE><EM> Return the attribute currently in effect for <CODE>v</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ScrollerVBTClass.m3#SetAttributes">SetAttributes</A> (v: T; READONLY a: Attributes);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the attributes on <CODE>v</CODE> to be <CODE>a</CODE>.  Mark <CODE>v</CODE> for
   redisplay and notify <CODE>v</CODE>'s parent that its shape might have
   changed. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ScrollerVBTClass.m3#Colorize">Colorize</A> (v: T; colors: PaintOp.ColorQuad);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Sets the paint op of all the scroller's textures and borders
   to be <CODE>colors.bgFg</CODE>.  Mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

END ScrollerVBTClass.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
