<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/Shadow.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/Shadow.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> The <CODE>Shadow</CODE> interface contains the basic definitions for VBT
   classes that implement a Motif-like, 3-D look.  There are two
   basic primitives: a 3-D border, and a 3-D vertical or
   horizontal line.  The style, size, and colors of the shadow
   are specified by data structures defined in this interface.
<P>
   A 3-D border can give the visual illusion of ``raising'' an
   object above the background, ``lowering'' an object into the
   background, drawing a ``ridge'' above the background, or
   chiseling a ``groove'' into the background.  A 3-D line has
   the visual effect of being either a ``ridge'' above the
   background or a ``groove'' chiseled into the background (see
   Figure~\ref{fig:shadows}).
<P>
   These visual effects are actually quite simple to accomplish
   by drawing parts of the 3-D border or 3-D line using a dark
   variant of the background color, and by drawing other parts
   using a light variant of the background color.
<P>
   For example, to give the impression that an object is raised
   above its background, the north and west borders are drawn
   using a light color, whereas the south and east border are
   drawn in a dark color.  To draw a ``ridge,'' the north and
   west shadows start out in the light color, and, halfway,
   switch to the dark color.  Analogously, the south and east
   shadows start out dark and switch to a light color.
<P>
   The following chart summarizes the visual effects:
<P>
<P>
             \begin{center}
             \begin{tabular}{l|l|l}
<P>
             {\em Style}   &amp; {\em North/West} &amp; {\em South/East}\\
             \hline
                 Flat      &amp;   Background  &amp;  Background\\
                 Raised    &amp;   Light       &amp;  Dark\\
                 Lowered   &amp;   Dark        &amp;  Light\\
                 Ridged    &amp;   Light/Dark  &amp;  Dark/Light\\
                 Chiseled  &amp;   Dark/Light  &amp;  Light/Dark
<P>
             \end{tabular}
             \end{center}
<P>
   For maximum effectiveness, the child's background should be a
   color whose saturation level is about 50\%, and the light and
   dark shadows should be colors with the same hue and lightness,
   but with saturation levels of 25\% and 75\% respectively.
<P>
   On a monochrome display, the 3-D borders and lines appear flat and
   50\% of the size they'd be on non-monochrome displays. Also, those
   VBTkit widgets that use 3-D borders for feedback (say, a button
   that gives the effect of lowering its contents when depressed) are
   implemented in such a way as to give feedback in a non-3-D manner
   (e.g., the {\tt ShadowedFeedbackVBT} 
   interface in Section~\ref{ShadowedFeedbackVBTSection}). 
<P>
   You can force VBTkit widgets to use a non-3-D style of 
   feedback by specifying a shadow size that is negative. Such widgets
   will draw borders and lines with 50\% of the absoluate value of
   the shadow size. (You should also be sure to set the light and dark 
   shadow to be the same as the foreground color.) 

<P>
<P><PRE>INTERFACE <interface><A HREF="Shadow.m3">Shadow</A></interface>;

IMPORT <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  T = PaintOp.ColorScheme OBJECT
        size: REAL;
        light, dark, both, reversed: PaintOp.T;
      END;

TYPE
  Style = {Flat, Raised, Lowered, Ridged, Chiseled};

PROCEDURE <A HREF="Shadow.m3#New">New</A> (size : REAL      := 0.5;
               bg   : PaintOp.T := PaintOp.Bg;
               fg   : PaintOp.T := PaintOp.Fg;
               light: PaintOp.T := PaintOp.Fg;
               dark : PaintOp.T := PaintOp.Fg): T;
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Return a newly allocated <CODE>Shadow.T</CODE>.  The <CODE>size</CODE>, <CODE>light</CODE>, and
   <CODE>dark</CODE> fields of the new <CODE>Shadow.T</CODE> are copies of the
   parameters, respectively.  The <CODE>both</CODE> field is computed from
   <CODE>PaintOp.Pair(light, dark)</CODE>, and the <CODE>reversed</CODE> field is
   computed from <CODE>PaintOp.Pair(dark, light)</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>size</CODE> is specified in millimeters.  All of the paint ops
   must be tints, arranged so that on a monochrome screen <CODE>bg</CODE>
   draws in background, while <CODE>fg</CODE>, <CODE>light</CODE>, and <CODE>dark</CODE> draw in
   foreground. 

<P><PRE>PROCEDURE <A HREF="Shadow.m3#Supported">Supported</A> (shadow: T; v: VBT.T): BOOLEAN;
&lt;* LL.sup &lt; v *&gt;
</PRE><BLOCKQUOTE><EM> Return whether <CODE>shadow</CODE> should appear 3-D on <CODE>v</CODE>.  Two conditions
   must hold: <CODE>v</CODE> must be on screen whose depth is greater than 1,
   and <CODE>shadow.size</CODE> must be positive. </EM></BLOCKQUOTE><PRE>
</PRE>  Finally, we have the definition for a ``default'' shadow: 

<P><PRE>VAR (* CONST *) None: T;
</PRE> This variable is really a constant for
<P>
<PRE>
      New(0.0, PaintOp.Bg, PaintOp.Fg, PaintOp.Fg, PaintOp.Fg)
</PRE>
   Because <CODE>None</CODE> is not a constant, it cannot be the default
   value of a procedure argument.  Therefore, we adopt the
   following convention: when a parameter whose type is
   <CODE>Shadow.T</CODE> has a default value of <CODE>NIL</CODE>, the procedure will
   use <CODE>Shadow.None</CODE> instead. 

<P><PRE>END Shadow.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
