<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/Shadow.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/Shadow.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="Shadow.i3">Shadow</A></implements></module>;

IMPORT <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/ScreenType.i3">ScreenType</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (size : REAL      := 0.5;
               bg   : PaintOp.T := PaintOp.Bg;
               fg   : PaintOp.T := PaintOp.Fg;
               light: PaintOp.T := PaintOp.Fg;
               dark : PaintOp.T := PaintOp.Fg  ): T =
  VAR
    shadow := NEW(T);
    cs := PaintOp.MakeColorScheme(bg, fg);
  BEGIN
    shadow.bg := cs.bg;
    shadow.fg := cs.fg;
    shadow.bgFg := cs.bgFg;
    shadow.transparentFg := cs.transparentFg;
    shadow.swap := cs.swap;
    shadow.bgTransparent := cs.bgTransparent;
    shadow.bgSwap := cs.bgSwap;
    shadow.fgBg := cs.fgBg;
    shadow.fgTransparent := cs.fgTransparent;
    shadow.fgSwap := cs.fgSwap;
    shadow.transparentBg := cs.transparentBg;
    shadow.transparentSwap := cs.transparentSwap;
    shadow.swapBg := cs.swapBg;
    shadow.swapFg := cs.swapFg;
    shadow.swapTransparent := cs.swapTransparent;
    shadow.size := size;
    shadow.light := light;
    shadow.dark := dark;
    shadow.both := PaintOp.Pair(light, dark);
    shadow.reversed := PaintOp.Pair(dark, light);
    RETURN shadow;
  END New;

PROCEDURE <A NAME="Supported"><procedure>Supported</procedure></A> (shadow: T; v: VBT.T): BOOLEAN =
  VAR st: ScreenType.T;
  BEGIN
    st := VBT.ScreenTypeOf(v);
    RETURN (shadow.size &gt; 0.0) AND (st # NIL) AND (st.depth &gt; 1);
  END Supported;

BEGIN
  None := New (0.0);
END Shadow.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
