<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ShadowedBarVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ShadowedBarVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> A <CODE>ShadowedBarVBT.T</CODE> is a leaf-VBT that displays a horizontal or
   vertical 3-D line.
<P>
   The following chart summarizes the visual effects:
<P>
             \begin{center}
             \begin{tabular}{l|l|l}
<P>
                               &amp; {\em top (vertical)}    &amp; {\em bottom (vertical)}\\
                               &amp; {\em left (horizontal)} &amp; {\em right (horizontal)} \\
             {\em Style}       &amp;                         &amp; \\
             \hline
                 Flat      &amp;   Background  &amp;  Background\\
                 Raised    &amp;   Light       &amp;  Dark\\
                 Lowered   &amp;   Dark        &amp;  Light\\
                 Ridged    &amp;   Light       &amp;  Dark\\
                 Chiseled  &amp;   Dark        &amp;  Light
<P>
             \end{tabular}
             \end{center}


<P><PRE>INTERFACE <interface><A HREF="ShadowedBarVBT.m3">ShadowedBarVBT</A></interface>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="ShadowedBarVBT.m3#T">T</A> &lt;: Public;
  Public = VBT.Leaf OBJECT
           METHODS
             &lt;* LL.sup &lt;= VBT.mu *&gt;
             init (axis  : Axis.T;
                   shadow: Shadow.T := NIL;
                   style            := Shadow.Style.Flat): T;
           END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>ShadowedBarVBT</CODE> with
   the <CODE>axis</CODE> orientation and with the given <CODE>shadow</CODE> and <CODE>style</CODE>. The
   default <CODE>shadow</CODE> is <CODE>Shadow.None</CODE>.  If the <CODE>shadow.size</CODE> along the
   <CODE>axis</CODE> dimension results in an odd number of pixels, the extra
   pixel goes to the top half.
<P>
   When <CODE>Shadow.Supported(shadow, v)</CODE> is <CODE>TRUE</CODE>, the shape of <CODE>v</CODE>
   is <CODE>ABS(shadow.size)</CODE> in the primary axis, and unconstrained in the
   other dimension. Otherwise, the shape of <CODE>v</CODE> in the primary axis
   is <CODE>ABS(shadow.size/2)</CODE>. 

<P><PRE>PROCEDURE <A HREF="ShadowedBarVBT.m3#Set">Set</A> (v: T; shadow: Shadow.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the size and colors of <CODE>v</CODE>'s shadow and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ShadowedBarVBT.m3#SetStyle">SetStyle</A> (v: T; style: Shadow.Style);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the style of <CODE>v</CODE>'s shadow and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

END ShadowedBarVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
