<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ShadowedBarVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ShadowedBarVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ShadowedBarVBT.i3">ShadowedBarVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="ShadowPaint.i3">ShadowPaint</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        axis  : Axis.T;
        shadow: Shadow.T;
        style : Shadow.Style;
      OVERRIDES
        init    := Init;
        shape   := Shape;
        repaint := Repaint;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v     : T;
                axis  : Axis.T;
                shadow: Shadow.T     := NIL;
                style : Shadow.Style := Shadow.Style.Flat): T =
  BEGIN
    IF shadow = NIL THEN shadow := Shadow.None; END;
    v.axis := axis;
    v.shadow := shadow;
    v.style := style;
    RETURN v
  END Init;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A> (v: T; shadow: Shadow.T) =
  BEGIN
    IF v.shadow.size # shadow.size THEN VBT.NewShape (v);  END;
    v.shadow := shadow;
    VBT.Mark (v);
  END Set;

PROCEDURE <A NAME="SetStyle"><procedure>SetStyle</procedure></A> (v: T; style: Shadow.Style) =
  BEGIN
    v.style := style;
    VBT.Mark(v);
  END SetStyle;

PROCEDURE <A NAME="Shape"><procedure>Shape</procedure></A> (v: T; ax: Axis.T; n: CARDINAL): VBT.SizeRange =
  VAR sr: VBT.SizeRange;
  BEGIN
    IF v.axis = ax THEN
      sr.lo := ROUND(VBT.MMToPixels(v, ABS(v.shadow.size), ax));
      sr.pref := sr.lo;
      sr.hi := sr.lo + 1;
      RETURN sr;
    ELSE
      RETURN VBT.Leaf.shape(v, ax, n)
    END;
  END Shape;

PROCEDURE <A NAME="Repaint"><procedure>Repaint</procedure></A> (v: T; READONLY rgn: Region.T) =
  BEGIN
    ShadowPaint.Bar(v, rgn, v.shadow, v.style, v.axis, VBT.Domain (v));
  END Repaint;

BEGIN
END ShadowedBarVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
