<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ShadowedFeedbackVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ShadowedFeedbackVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> A <CODE>ShadowedFeedbackVBT</CODE> is a multi-filter feedback that displays a
   3-D border as visual feedback to another VBT. 

<P><PRE>INTERFACE <interface><A HREF="ShadowedFeedbackVBT.m3">ShadowedFeedbackVBT</A></interface>;

IMPORT <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  &lt;* SUBTYPE T &lt;: MultiFilter.T *&gt;
  <A HREF="ShadowedFeedbackVBT.m3#T">T</A> &lt;: Public;
  Public =
    FeedbackVBT.T OBJECT
    METHODS
      &lt;* LL &lt;= VBT.mu *&gt;
      init (ch            : VBT.T;
            shadow        : Shadow.T := NIL;
            onStyle                  := Shadow.Style.Lowered;
            onExcitedStyle           := Shadow.Style.Raised;
            offStyle                 := Shadow.Style.Raised;
            offExcitedStyle          := Shadow.Style.Lowered): T
    END;
</PRE> The call <CODE>v.init(ch, shadow, ...)</CODE> initializes <CODE>v</CODE> as a
   <CODE>ShadowedFeedbackVBT</CODE>.  The internal structure of <CODE>v</CODE> includes a
   <CODE>ShadowedVBT</CODE> for displaying the shadow <CODE>shadow</CODE> around <CODE>ch</CODE>.  The
   default <CODE>normal</CODE> and <CODE>excited</CODE> methods change the style of the
   shadow, taking into account the state of <CODE>v</CODE>.  For example, when
   <CODE>FeedbackVBT.GetState(v)</CODE> returns <CODE>FALSE</CODE>, the <CODE>excited</CODE> method
   uses the value of <CODE>offExcitedStyle</CODE>.
<P>
   On a monochrome screen (whenever <CODE>Shadow.IsSupport(v, shadow)</CODE> is
   false), <CODE>ch</CODE> is inverted by the default <CODE>normal</CODE> method when the
   state is ``on'' and by the <CODE>excited</CODE> method when the state is
   ``off.''
<P>
   The default parameters to the <CODE>init</CODE> method generate a feedback
   that is appropriate for buttons.  The following procedure generates
   a feedback that is appropriate for use by menu buttons: 

<P><PRE>PROCEDURE <A HREF="ShadowedFeedbackVBT.m3#NewMenu">NewMenu</A> (ch: VBT.T; shadow: Shadow.T := NIL): T;
&lt;* LL &lt;= VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return a <CODE>ShadowedFeedbackVBT</CODE> appropriate for menu buttons.  The
   <CODE>normal</CODE> method always uses <CODE>Shadow.Style.Flat</CODE>; the <CODE>excited</CODE>
   method always uses <CODE>Shadow.Style.Lowered</CODE>. </EM></BLOCKQUOTE><PRE>

END ShadowedFeedbackVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
