<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ShadowedFeedbackVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ShadowedFeedbackVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ShadowedFeedbackVBT.i3">ShadowedFeedbackVBT</A></implements></module>;

IMPORT <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/split/HighlightVBT.i3">HighlightVBT</A>, <A HREF="MultiClass.i3">MultiClass</A>,
       <A HREF="MultiFilter.i3">MultiFilter</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="ShadowedVBT.i3">ShadowedVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        shadow        : Shadow.T;
        highlighter   : HighlightVBT.T;
        normalStyles  : ARRAY BOOLEAN OF Shadow.Style;
        excitedStyles : ARRAY BOOLEAN OF Shadow.Style
      OVERRIDES
        init    := Init;
        normal  := Normal;
        excited := Excited;
        reshape := Reshape;
      END;

TYPE
  MC = MultiClass.Filter BRANDED OBJECT
       OVERRIDES
         succ    := Succ;
         pred    := Succ;
         replace := Replace;
       END;
</PRE> Bug: if Shadow.Supported(v, v.shadow) changes on the fly,
   such as during a rescreening, the looks will be wrong because
   there is nothing to tickle the HighlightVBT to change. 

<P><PRE>PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v      : T;
                ch     : VBT.T;
                shadow : Shadow.T := NIL;
                onStyle           := Shadow.Style.Lowered;
                onExcitedStyle  := Shadow.Style.Raised;
                offStyle        := Shadow.Style.Raised;
                offExcitedStyle := Shadow.Style.Lowered ): T =
  BEGIN
    IF shadow = NIL THEN shadow := Shadow.None END;
    EVAL FeedbackVBT.T.init(
           v, NEW (ShadowedVBT.T).init (ch, shadow, offStyle));
    v.shadow := shadow;
    v.normalStyles[TRUE] := onStyle;
    v.normalStyles[FALSE] := offStyle;
    v.excitedStyles[TRUE] := onExcitedStyle;
    v.excitedStyles[FALSE] := offExcitedStyle;
    MultiClass.Be(v, NEW(MC));
    IF ch # NIL THEN MultiClass.BeChild(v, ch) END;
    RETURN v
  END Init;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (v: T; READONLY cd: VBT.ReshapeRec) =
  VAR ch: VBT.T;
  BEGIN
    FeedbackVBT.T.reshape(v, cd);
    ch := MultiFilter.Child(v);
    IF ch # NIL AND v.highlighter # NIL THEN
      SetHighlighter(v, VBT.Domain(ch), 99999)
    END
  END Reshape;

PROCEDURE <A NAME="Normal"><procedure>Normal</procedure></A> (v: T) =
  VAR state := FeedbackVBT.GetState(v);
  BEGIN
    ShadowedVBT.SetStyle(Filter.Child(v), v.normalStyles[state]);
    Highlight(v, state)
  END Normal;

PROCEDURE <A NAME="Excited"><procedure>Excited</procedure></A> (v: T) =
  VAR state := FeedbackVBT.GetState(v);
  BEGIN
    ShadowedVBT.SetStyle(Filter.Child(v), v.excitedStyles[state]);
    Highlight(v, NOT state)
  END Excited;

PROCEDURE <A NAME="Highlight"><procedure>Highlight</procedure></A> (v: T; excite: BOOLEAN) =
  VAR ch := MultiFilter.Child(v);
  BEGIN
    IF excite THEN
      v.highlighter := HighlightVBT.Find(v);
      IF ch # NIL THEN
        SetHighlighter(v, VBT.Domain(ch), 99999)
      END
    ELSE
      SetHighlighter(v, Rect.Empty, 0);
      v.highlighter := NIL
    END
  END Highlight;

PROCEDURE <A NAME="SetHighlighter"><procedure>SetHighlighter</procedure></A> (v: T; READONLY r: Rect.T; sz: CARDINAL) =
  BEGIN
    IF NOT Shadow.Supported(v.shadow, v) THEN
      HighlightVBT.SetTexture(
        v.highlighter, Pixmap.Solid, Point.Origin, v.shadow.swap);
      HighlightVBT.SetRect(v.highlighter, r, sz)
    END
  END SetHighlighter;

PROCEDURE <A NAME="NewMenu"><procedure>NewMenu</procedure></A> (ch: VBT.T; shadow: Shadow.T := NIL): T =
  BEGIN
    RETURN
      NEW (T).init (ch, shadow, Shadow.Style.Flat, Shadow.Style.Lowered,
                    Shadow.Style.Flat, Shadow.Style.Lowered);
  END NewMenu;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; &lt;* UNUSED *&gt; ch: VBT.T; new: VBT.T) =
  VAR sh := Filter.Child(m.vbt);
  BEGIN
    EVAL Filter.Replace(sh, new)
  END Replace;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (m: MC; ch: VBT.T): VBT.T =
  VAR sh := Filter.Child(m.vbt);
  BEGIN
    IF ch = NIL THEN RETURN Filter.Child(sh) ELSE RETURN NIL END
  END Succ;

BEGIN
END ShadowedFeedbackVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
