<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ShadowedVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ShadowedVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> A <CODE>ShadowedVBT.T</CODE> is a filter whose parent's screen consists of the
   child's screen surrounded by a 3-D border.  The style, size, and
   colors of the shadow can be set dynamically.  The parent's shape is
   determined from the child's shape by adding the size of the shadow.
   

<P><PRE>INTERFACE <interface><A HREF="ShadowedVBT.m3">ShadowedVBT</A></interface>;

IMPORT <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  <A HREF="ShadowedVBT.m3#T">T</A> &lt;: Public;
  <A HREF="ShadowedVBT.m3#Private">Private</A> &lt;: Filter.T;
  Public = Private OBJECT
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      init (ch: VBT.T;
            shadow: Shadow.T := NIL;
            style: Shadow.Style := Shadow.Style.Flat): T;
    END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>ShadowedVBT</CODE> with
   child <CODE>ch</CODE> and the given <CODE>shadow</CODE> and <CODE>style</CODE>.  When
   <CODE>Shadow.Support(shadow, v)</CODE> is <CODE>TRUE</CODE>, each dimension of <CODE>v</CODE>
   exceeds the corresponding dimension of <CODE>ch</CODE> by <CODE>2 *
   ABS(shadow.size)</CODE>; otherwise, each dimension of <CODE>v</CODE> exceeds
   the corresponding dimension of <CODE>ch</CODE> by <CODE>2 *
   ABS(shadow.size/2)</CODE>.  If <CODE>shadow=NIL</CODE>, it defaults to
   <CODE>Shadow.None</CODE>. 

<P><PRE>PROCEDURE <A HREF="ShadowedVBT.m3#Set">Set</A> (v: T; shadow: Shadow.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the size and colors of <CODE>v</CODE>'s shadow and mark <CODE>v</CODE> for
   redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ShadowedVBT.m3#SetStyle">SetStyle</A> (v: T; style: Shadow.Style);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Change the style of <CODE>v</CODE>'s shadow, and mark <CODE>v</CODE> for redisplay. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ShadowedVBT.m3#Get">Get</A> (v: T): Shadow.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>v</CODE>'s shadow. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ShadowedVBT.m3#GetStyle">GetStyle</A> (v: T): Shadow.Style;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Return <CODE>v</CODE>'s shadow style.  </EM></BLOCKQUOTE><PRE>

END ShadowedVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
