<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ShadowedVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ShadowedVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ShadowedVBT.i3">ShadowedVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/BdrVBTClass.i3">BdrVBTClass</A>, <A HREF="../../ui/src/split/BorderedVBT.i3">BorderedVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="../../ui/src/vbt/MouseSplit.i3">MouseSplit</A>,
       <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../geometry/src/Region.i3">Region</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="ShadowPaint.i3">ShadowPaint</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>;

REVEAL
  <A NAME="Private">Private</A> = BorderedVBT.T BRANDED OBJECT END;
  <A NAME="T">T</A> = Public BRANDED OBJECT
        shadow: Shadow.T;
        style : Shadow.Style;
      OVERRIDES
        init      := Init;
        rescreen  := Rescreen;
        repaintBorder := RepaintBorder;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v     : T;
                ch    : VBT.T;
                shadow: Shadow.T     := NIL;
                style : Shadow.Style := Shadow.Style.Flat): T =
  BEGIN
    IF shadow = NIL THEN shadow := Shadow.None END;
    v.shadow := shadow;
    v.style := style;
    ComputeBSize(v);
    EVAL Filter.T.init(v, ch);
    RETURN v
  END Init;

PROCEDURE <A NAME="Set"><procedure>Set</procedure></A> (v: T; shadow: Shadow.T) =
  BEGIN
    IF v.shadow.size # shadow.size THEN VBT.NewShape(v) END;
    v.shadow := shadow;
    VBT.Mark(v)
  END Set;

PROCEDURE <A NAME="SetStyle"><procedure>SetStyle</procedure></A> (v: T; style: Shadow.Style) =
  BEGIN
    IF v.style # style THEN v.style := style; VBT.Mark(v) END
  END SetStyle;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (v: T): Shadow.T =
  BEGIN
    RETURN v.shadow
  END Get;

PROCEDURE <A NAME="GetStyle"><procedure>GetStyle</procedure></A> (v: T): Shadow.Style =
  BEGIN
    RETURN v.style
  END GetStyle;

PROCEDURE <A NAME="ComputeBSize"><procedure>ComputeBSize</procedure></A> (v: T) =
  VAR size: REAL;
  BEGIN
    size := ABS(v.shadow.size);
    IF NOT Shadow.Supported(v.shadow, v) THEN
      size := size / 2.0
    END;
    FOR ax := FIRST(Axis.T) TO LAST(Axis.T) DO
      v.bSize[ax] := ROUND(VBT.MMToPixels(v, size, ax));
    END;
  END ComputeBSize;

PROCEDURE <A NAME="ChDom"><procedure>ChDom</procedure></A> (v: T): Rect.T =
  (* Compute child domain from v's domain and border sizes *)
  BEGIN
    WITH dh = v.bSize [Axis.T.Hor], dv = v.bSize [Axis.T.Ver] DO
      RETURN Rect.Change (VBT.Domain (v), dh, -dh, dv, -dv)
    END
  END ChDom;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A> (v: T; READONLY cd: VBT.RescreenRec) =
  BEGIN
    ComputeBSize(v);
    VBT.NewShape(v);
    Filter.T.rescreen(v, cd)
  END Rescreen;

PROCEDURE <A NAME="RepaintBorder"><procedure>RepaintBorder</procedure></A> (v: T; READONLY clip: Rect.T) =
  (* repaint the part of v's border that lies within clip.  LL =
     VBT.mu. *)
  BEGIN
    ShadowPaint.Border(v, Region.FromRect(clip), v.shadow,
                       v.style, ChDom(v), VBT.Domain(v));
  END RepaintBorder;

BEGIN
END ShadowedVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
