<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/SourceVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/SourceVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> A <CODE>SourceVBT</CODE> is used to implement a ``drag-and-drop'' paradigm.
   The object being dragged is the {\em source} and an object into
   which the source may be dropped is the {\em target}.
<P>
   As a subclass of <CODE>ButtonVBT</CODE>, a <CODE>SourceVBT</CODE> has <CODE>pre</CODE>, <CODE>post</CODE>, and
   <CODE>cancel</CODE> methods.  In addition, it has <CODE>during</CODE>, <CODE>callback</CODE>, and
   <CODE>hit</CODE> methods.  The methods are called as follows: The <CODE>pre</CODE> method
   is invoked on the first click in the VBT; the <CODE>post</CODE> method is
   called on an uncanceled upclick; the <CODE>cancel</CODE> method is called
   whenever the mouse is chord-canceled; the <CODE>during</CODE> method is called
   whenever the mouse has moved (and remained on the same screen)
   since the last call to <CODE>during</CODE> or <CODE>pre</CODE>.  A new VBT cage
   containing the current cursor position will be set before calls to
   <CODE>pre</CODE> and <CODE>during</CODE>. The <CODE>callback</CODE> method is called after
   the <CODE>post</CODE> method, as long as the mouse was over an ``acceptable
   target'' when the upcplick happened.
<P>
   The heart of drag-and-drop is implemented by the default <CODE>during</CODE>
   method: Recall that the <CODE>during</CODE> method is invoked each time the
   mouse moves while the button is down and not chord-cancelled.  The
   default <CODE>during</CODE> method looks to see if the mouse is over a VBT
   marked as a {\em target}.  If so, then the <CODE>SourceVBT</CODE>'s <CODE>hit</CODE>
   method is invoked to see if the target is acceptable for the
   source.  If so, an <CODE>excited</CODE> method on the target is invoked to
   give feedback, and eventually, a target's <CODE>normal</CODE> method is
   called to remove the feedback.  If the target is not acceptable,
   nothing happens.  

<P>
<P><PRE>INTERFACE <interface><A HREF="SourceVBT.m3">SourceVBT</A></interface>;

IMPORT <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../ui/src/split/HighlightVBT.i3">HighlightVBT</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;
</PRE> \subsubsection{Sources} 

<P><PRE>TYPE
  &lt;* SUBTYPE T &lt;: MultiFilter.T *&gt;
  <A HREF="SourceVBT.m3#T">T</A> &lt;: Public;
  Public =
    ButtonVBT.T OBJECT
    METHODS
      &lt;* LL &lt;= VBT.mu *&gt;
      init (f: FeedbackVBT.T): T;
      &lt;* LL = VBT.mu *&gt;
      during   (READONLY cd: VBT.PositionRec);
      callback (READONLY cd: VBT.MouseRec);
      hit (target: VBT.T; READONLY cd: VBT.PositionRec):
           BOOLEAN;
    END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>SourceVBT</CODE>.  The
   default <CODE>pre</CODE> method changes the cursor to a starburst and calls
   <CODE>SwitchVBT.Pre</CODE>.  The default <CODE>during</CODE> method calls the <CODE>hit</CODE>
   method whenever it is on a location controlled by a VBT that is a
   target.  If the <CODE>hit</CODE> method returns <CODE>TRUE</CODE>, the target's <CODE>excited</CODE>
   method is called.  As the mouse moves from target to target, the
   previous trarget's <CODE>normal</CODE> method is called before another
   target's <CODE>excited</CODE> method is invoked.  The <CODE>post</CODE> and <CODE>cancel</CODE>
   methods invoke the current target's <CODE>normal</CODE> method, restore the
   original cursor, and call <CODE>SwitchVBT.Post</CODE> and <CODE>SwitchVBT.Cancel</CODE>
   respectively.  It's guaranteed that a target's <CODE>excited</CODE> and
   <CODE>normal</CODE> methods are called in non-nested pairs.
<P>
   The default <CODE>hit</CODE> method always returns <CODE>TRUE</CODE>.  The default
   <CODE>during</CODE> and <CODE>callback</CODE> methods are no-ops. 

<P><PRE>PROCEDURE <A HREF="SourceVBT.m3#GetTarget">GetTarget</A> (v: T): Target;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> If the mouse is not over a valid target, or if the most recent call
   to <CODE>v.hit(target, cd)</CODE> returned <CODE>FALSE</CODE>, then return <CODE>NIL</CODE>;
   otherwise return <CODE>target</CODE>. This procedure is intended to be called
   by a <CODE>callback</CODE> method to find out the current target. </EM></BLOCKQUOTE><PRE>
</PRE> \subsubsection{Targets} 

<P><PRE>TYPE Target = VBT.T;
</PRE><BLOCKQUOTE><EM> A target is a VBT on which <CODE>BeTarget</CODE> has been invoked. </EM></BLOCKQUOTE><PRE>

TYPE
  <A HREF="SourceVBT.m3#TargetClass">TargetClass</A> &lt;: TargetClassPublic;
  TargetClassPublic =
    ROOT OBJECT
      vbt: VBT.T;  (* READONLY; set by BeTarget *)
      source: T;   (* READONLY; for use by normal/excited *)
    METHODS
      &lt;* LL = VBT.mu *&gt;
      normal  ();
      excited ();
    END;
</PRE> A <CODE>TargetClass</CODE> determines the feedback when a target's <CODE>excited</CODE>
   method is called. The <CODE>source</CODE> field can be read by the <CODE>normal</CODE>
   and <CODE>excited</CODE> methods, but clients may find <CODE>GetSource</CODE> more
   convenient to use.
<P>
   The default <CODE>normal</CODE> and <CODE>excited</CODE> methods are no-ops. 
   
<P><PRE>PROCEDURE <A HREF="SourceVBT.m3#BeTarget">BeTarget</A> (w: VBT.T; class: TargetClass);
&lt;* LL.sup &lt; w *&gt;
</PRE><BLOCKQUOTE><EM> Make <CODE>w</CODE> into a target for a <CODE>SourceVBT</CODE>.  As a target, <CODE>w</CODE> may
   be passed to some <CODE>SourceVBT</CODE>'s <CODE>hit</CODE> method. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SourceVBT.m3#TargetClassOf">TargetClassOf</A> (w: Target): TargetClass;
&lt;* LL.sup &lt; w *&gt;
</PRE><BLOCKQUOTE><EM> Return the <CODE>class</CODE> argument for which there was a previous call
   to <CODE>BeTarget(w, class)</CODE>, or <CODE>NIL</CODE> if there was no such call. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SourceVBT.m3#GetSource">GetSource</A> (w: Target): T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Called by a target's <CODE>normal</CODE> or <CODE>excited</CODE> methods to find out
   the <CODE>SourceVBT</CODE> causing the method to be invoked. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SourceVBT.m3#GetHighlighter">GetHighlighter</A> (v: T): HighlightVBT.T;
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Returns the <CODE>HighlightVBT</CODE> above the nearest Trestle-installed
   ancestor of <CODE>v</CODE>. This is typically called by a <CODE>normal</CODE> or
   <CODE>excited</CODE> method. </EM></BLOCKQUOTE><PRE>
</PRE> Here are three <CODE>TargetClass</CODE> objects that may be useful. Each of
these use the <CODE>op</CODE> parameter for painting in the <CODE>HighlighVBT</CODE>. 

<P><PRE>PROCEDURE <A HREF="SourceVBT.m3#NewInserterTarget">NewInserterTarget</A> (op := PaintOp.TransparentSwap): TargetClass;
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Displays a grid over itself when excited.  Appropriate for an
   adjusting bar in a tiling window manager.  The parent of the target
   must be an <CODE>HVSplit</CODE>, and grid has a minimum size in the
   <CODE>HVSplit</CODE>'s axis. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SourceVBT.m3#NewSwapTarget">NewSwapTarget</A> (op := PaintOp.TransparentSwap): TargetClass;
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Displays a grid over itself when excited.  This target is
   appropriate for a non-adjusting bar in a tiling window manager. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SourceVBT.m3#NewTarget">NewTarget</A> (op := PaintOp.TransparentSwap): TargetClass;
&lt;* LL = arbitrary *&gt;
</PRE><BLOCKQUOTE><EM> Inverts itself when excited.  This target class is a
   general-purpose target. </EM></BLOCKQUOTE><PRE>

END SourceVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
