<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/SourceVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/SourceVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                         </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="SourceVBT.i3">SourceVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/BtnVBTClass.i3">BtnVBTClass</A>, <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>, <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>,
       <A HREF="../../ui/src/split/HighlightVBT.i3">HighlightVBT</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="MultiClass.i3">MultiClass</A>, <A HREF="MultiFilter.i3">MultiFilter</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>,
       <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="SwitchVBT.i3">SwitchVBT</A>,
       <A HREF="../../ui/src/vbt/TrestleClass.i3">TrestleClass</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="VBTKitResources.i3">VBTKitResources</A>, <A HREF="../../word/src/Word.i3">Word</A>;

FROM <A HREF="../../ui/src/vbt/VBT.i3">VBT</A> IMPORT ClickType;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        root  : VBT.T;
        target: Target;
      OVERRIDES
        init     := Init;
        pre      := Pre;
        post     := Post;
        during   := During;
        callback := Callback;
        hit      := AlwaysHit;
        cancel   := Cancel;
        mouse    := Mouse;
        position := Position;
      END;

TYPE
  MC = SwitchVBT.MC OBJECT END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; f: FeedbackVBT.T): T =
  BEGIN
    GetResources();
    EVAL ButtonVBT.T.init(v, f, NIL);
    MultiClass.Be(v, NEW(MC));
    WITH ch = MultiFilter.Child(f) DO
      IF ch # NIL THEN MultiClass.BeChild(v, ch) END;
    END;
    RETURN v
  END Init;

PROCEDURE <A NAME="Callback"><procedure>Callback</procedure></A> (&lt;* UNUSED *&gt;          v : T;
                    &lt;* UNUSED *&gt; READONLY cd: VBT.MouseRec) =
  BEGIN
  END Callback;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A>(v: T; READONLY cd: VBT.MouseRec) =
  BEGIN
    Filter.T.mouse(v, cd);
    IF cd.clickType = ClickType.FirstDown THEN
      v.ready := TRUE;
      v.pre();
      VBT.SetCage(v, VBT.CageFromPosition(cd.cp, TRUE));
    ELSIF v.ready THEN
      v.ready := FALSE;
      IF cd.clickType = ClickType.LastUp AND NOT cd.cp.offScreen THEN
        v.post();
        IF v.target # NIL THEN v.callback(cd) END;
      ELSE
        v.cancel();
      END;
    END;
  END Mouse;

PROCEDURE <A NAME="Position"><procedure>Position</procedure></A> (v: T; READONLY cd: VBT.PositionRec) =
  BEGIN
    Filter.T.position(v, cd);
    IF v.ready THEN
      VBT.SetCage(v, VBT.CageFromPosition(cd.cp, TRUE));
      IF NOT cd.cp.offScreen THEN
        v.during(cd);
      END;
    END;
  END Position;

PROCEDURE <A NAME="AlwaysHit"><procedure>AlwaysHit</procedure></A> (&lt;* UNUSED *&gt; v     : Public;
                     &lt;* UNUSED *&gt; target: VBT.T;
                     &lt;* UNUSED *&gt; READONLY cd: VBT.PositionRec):
  BOOLEAN =
  BEGIN
    RETURN TRUE
  END AlwaysHit;

&lt;* UNUSED *&gt;
PROCEDURE <A NAME="NeverHit"><procedure>NeverHit</procedure></A> (&lt;* UNUSED *&gt;          v     : Public;
                    &lt;* UNUSED *&gt;          target: VBT.T;
                    &lt;* UNUSED *&gt; READONLY cd    : VBT.PositionRec):
  BOOLEAN =
  BEGIN
    RETURN FALSE
  END NeverHit;

REVEAL
  <A NAME="TargetClass">TargetClass</A> = TargetClassPublic BRANDED OBJECT
                OVERRIDES
                  normal  := DullTarget;
                  excited := DullTarget
                END;

PROCEDURE <A NAME="DullTarget"><procedure>DullTarget</procedure></A> (&lt;* UNUSED *&gt; class: TargetClass) =
  BEGIN
  END DullTarget;

TYPE Prop = BRANDED REF TargetClass;

PROCEDURE <A NAME="BeTarget"><procedure>BeTarget</procedure></A> (w: VBT.T; class: TargetClass) =
  VAR p := NEW (Prop);
  BEGIN
    p^ := class;
    VBT.PutProp (w, p);
    class.vbt := w
  END BeTarget;

PROCEDURE <A NAME="IsTarget"><procedure>IsTarget</procedure></A> (w: VBT.T): BOOLEAN =
  BEGIN
    RETURN VBT.GetProp(w, TYPECODE(Prop)) # NIL
  END IsTarget;

PROCEDURE <A NAME="GetHighlighter"><procedure>GetHighlighter</procedure></A> (v: T): HighlightVBT.T =
  BEGIN
    RETURN HighlightVBT.Find(v.root)
  END GetHighlighter;

PROCEDURE <A NAME="GetTarget"><procedure>GetTarget</procedure></A> (v: T): Target =
  BEGIN
    RETURN v.target
  END GetTarget;

PROCEDURE <A NAME="Pre"><procedure>Pre</procedure></A> (v: T) =
  BEGIN
    FeedbackVBT.Excited (Filter.Child (v));
    VBT.SetCursor(v, MovingCursor);
    v.root := FindInstalledAncestor(v);
    v.target := NIL;
  END Pre;

PROCEDURE <A NAME="Post"><procedure>Post</procedure></A> (v: T) =
  BEGIN
    FeedbackVBT.Normal(Filter.Child(v));
    Stop(v);
  END Post;

PROCEDURE <A NAME="Cancel"><procedure>Cancel</procedure></A> (v: T) =
  BEGIN
    FeedbackVBT.Normal(Filter.Child(v));
    Stop(v);
  END Cancel;

PROCEDURE <A NAME="Stop"><procedure>Stop</procedure></A> (v: T) =
  BEGIN
    IF v.target # NIL THEN TargetClassOf(v.target).normal() END;
    VBT.SetCursor(v, Cursor.DontCare);
  END Stop;

PROCEDURE <A NAME="During"><procedure>During</procedure></A> (v: T; READONLY cd: VBT.PositionRec) =
  VAR target := InTarget(v.root, cd.cp.pt);
  BEGIN
    IF target = NIL THEN
      IF v.target # NIL THEN TargetClassOf(v.target).normal() END;
      v.target := NIL;
    ELSIF v.target # target THEN
      IF v.target # NIL THEN TargetClassOf(v.target).normal() END;
      IF v.hit(target, cd) THEN
        TargetClassOf(target).source := v;
        v.target := target;
        TargetClassOf(v.target).excited();
      ELSE
        v.target := NIL
      END
    END
  END During;

PROCEDURE <A NAME="InTarget"><procedure>InTarget</procedure></A> (root: VBT.T; READONLY pt: Point.T): VBT.T =
  VAR target, v: VBT.T;
  BEGIN
    target := NIL;
    v := root;
    LOOP
      TYPECASE v OF
      | VBT.Split (split) =&gt; v := Split.Locate(split, pt);
      | VBT.Leaf =&gt; EXIT
      ELSE &lt;* ASSERT FALSE *&gt;
      END;
      IF v = NIL THEN EXIT END;
      IF IsTarget(v) THEN target := v END;
    END;
    RETURN target
  END InTarget;

PROCEDURE <A NAME="FindInstalledAncestor"><procedure>FindInstalledAncestor</procedure></A> (v: VBT.T): VBT.T =
  VAR p: VBT.T; ir: TrestleClass.InstallRef; BEGIN
    p := v;
    WHILE p # NIL DO
      ir := VBT.GetProp(p, TYPECODE(TrestleClass.InstallRef));
      IF ir # NIL AND ir.installCount &gt; 0 THEN RETURN p END;
      p := VBT.Parent(p)
    END;
    RETURN NIL
  END FindInstalledAncestor;

PROCEDURE <A NAME="TargetClassOf"><procedure>TargetClassOf</procedure></A> (w: Target): TargetClass =
  VAR p: Prop := VBT.GetProp (w, TYPECODE (Prop));
  BEGIN
    RETURN p^
  END TargetClassOf;

PROCEDURE <A NAME="GetSource"><procedure>GetSource</procedure></A> (w: Target): T =
  BEGIN
    RETURN TargetClassOf(w).source
  END GetSource;

TYPE
  DefaultTC = TargetClass OBJECT
                hl: HighlightVBT.T;
                op: PaintOp.T;
              OVERRIDES
                normal  := Normal;
                excited := Excited;
              END;

PROCEDURE <A NAME="NewTarget"><procedure>NewTarget</procedure></A> (op := PaintOp.TransparentSwap): TargetClass =
  BEGIN
    RETURN NEW(DefaultTC, op := op)
  END NewTarget;

PROCEDURE <A NAME="Excited"><procedure>Excited</procedure></A> (tc: DefaultTC) =
  BEGIN
    WITH target = tc.vbt, source = tc.source DO
      tc.hl := HighlightVBT.Find(target);
      HighlightVBT.SetTexture(tc.hl, Pixmap.Solid, Point.Origin, tc.op);
      HighlightVBT.SetRect(tc.hl, VBT.Domain(target), LAST(CARDINAL));
    END
  END Excited;

PROCEDURE <A NAME="Normal"><procedure>Normal</procedure></A> (tc: DefaultTC) =
  BEGIN
    HighlightVBT.SetRect(tc.hl, Rect.Empty)
  END Normal;

TYPE
  SwapTC =
    DefaultTC OBJECT OVERRIDES excited := ExcitedSwap; END;

PROCEDURE <A NAME="NewSwapTarget"><procedure>NewSwapTarget</procedure></A> (op := PaintOp.TransparentSwap): TargetClass =
  BEGIN
    RETURN NEW(SwapTC, op := op)
  END NewSwapTarget;

PROCEDURE <A NAME="ExcitedSwap"><procedure>ExcitedSwap</procedure></A> (tc: SwapTC) =
  BEGIN
    WITH target = tc.vbt, source = tc.source, r = VBT.Domain(target) DO
      tc.hl := HighlightVBT.Find(target);
      GridHighlight (tc.hl, tc.op,
        Rect.Middle (r), MAX (Rect.HorSize (r), 17),
        MAX (Rect.VerSize (r), 17))
    END;
  END ExcitedSwap;

TYPE
  InserterTC = DefaultTC OBJECT
               OVERRIDES
                 normal  := NormalInserter;
                 excited := ExcitedInserter
               END;

PROCEDURE <A NAME="NewInserterTarget"><procedure>NewInserterTarget</procedure></A> (op := PaintOp.TransparentSwap): TargetClass =
  BEGIN
    RETURN NEW(InserterTC, op := op)
  END NewInserterTarget;

PROCEDURE <A NAME="NormalInserter"><procedure>NormalInserter</procedure></A> (tc: InserterTC) =
  BEGIN
    WITH target = tc.vbt, source = tc.source DO
      HighlightVBT.SetRect(source.root, Rect.Empty)
    END
  END NormalInserter;

PROCEDURE <A NAME="ExcitedInserter"><procedure>ExcitedInserter</procedure></A> (tc: InserterTC) =
  VAR hsz, vsz: CARDINAL;
  BEGIN
    WITH target = tc.vbt,
         source = tc.source,
         r      = VBT.Domain (target) DO
      CASE HVSplit.AxisOf (VBT.Parent (target)) OF
      | Axis.T.Hor =&gt;
          hsz := MAX (Rect.HorSize (r), 65);
          vsz := Rect.VerSize (r);
      | Axis.T.Ver =&gt;
          hsz := Rect.HorSize (r);
          vsz := MAX (Rect.VerSize (r), 65);
      END;
      GridHighlight (source.root, tc.op, Rect.Middle (r), hsz, vsz)
    END
  END ExcitedInserter;

PROCEDURE <A NAME="GridHighlight"><procedure>GridHighlight</procedure></A> (hl: VBT.T; op: PaintOp.T; p: Point.T; hor, ver: INTEGER) =
  (* highlight a hor by ver rectangle centered at p, but reduce its size so
     that its borders fall on the grid lines. *)

  PROCEDURE F (n: CARDINAL): INTEGER =
    (* greatest integer at most n congruent to 1 MOD 16 *)
    BEGIN
      RETURN ((n - 1) DIV 16) * 16 + 1
    END F;

  VAR r := Center(Rect.FromSize(F(hor), F(ver)), p);
  BEGIN
    HighlightVBT.SetTexture(hl, Grid, Rect.NorthWest(r), op);
    HighlightVBT.SetRect(hl, r, 99999)
  END GridHighlight;

PROCEDURE <A NAME="Center"><procedure>Center</procedure></A> (READONLY r: Rect.T; p: Point.T): Rect.T =
  (* Like Rect.Center, but produces a rectangle with north and west both
     even, so that the grid texture will look black over the Trestle
     background grey. Assumes both r's dimensions are odd. *)
  BEGIN
    IF Word.And(p.h, 1) = 1 THEN DEC(p.h) END;
    IF Word.And(p.v, 1) = 1 THEN DEC(p.v) END;
    WITH
      h = p.h - ((r.west + r.east) DIV 2),
      v = p.v - ((r.north + r.south) DIV 2)
    DO
      RETURN Rect.MoveHV(r, h, v)
    END
  END Center;

VAR
  rsrcMu                 := NEW(MUTEX);
  rsrcInit               := FALSE;
  MovingCursor: Cursor.T;
  Grid: Pixmap.T;

PROCEDURE <A NAME="GetResources"><procedure>GetResources</procedure></A> () =
  BEGIN
    LOCK rsrcMu DO
      IF rsrcInit THEN RETURN END;
      MovingCursor := Cursor.FromName(ARRAY OF TEXT{&quot;XC_fleur&quot;});
      Grid := VBTKitResources.GetPixmap(&quot;Grid&quot;);
      rsrcInit := TRUE;
    END
  END GetResources;

BEGIN
END SourceVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
