<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/SplitterVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/SplitterVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> A <CODE>SplitterVBT.T</CODE> is a parent window that partitions its screen
   into a row or column of children windows, depending on the
   {\em axis} of the split, with adjusting bars between all
   children.  The adjusting bars allow the user to adjust the
   allocation of screen real estate among the splitter's
   children, subject to the size constraints of each child.
<P>
   A <CODE>SplitterVBT</CODE> is subclass of an <CODE>HVSplit</CODE>, but through the
   <CODE>MultiSpit</CODE> interface, only the ``interesting'' children of the
   <CODE>HVSplit</CODE> are exposed.  That is, adjusting bars are never
   exposed to the client: they are inserted automatically when a
   new child is added, and removed as necessary.  To access all
   children, including the adjusting bars, use the <CODE>Split</CODE>
   interface instead.  The <CODE>HVSplit</CODE> routines <CODE>Move</CODE>, <CODE>Adjust</CODE>,
   <CODE>FeasibleRange</CODE>, <CODE>AvailSize</CODE>, and <CODE>AxisOf</CODE> can be used. 

<P><PRE>INTERFACE <interface><A HREF="SplitterVBT.m3">SplitterVBT</A></interface>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>;

TYPE
  &lt;* SUBTYPE T &lt;: MultiSplit.T *&gt;
  <A HREF="SplitterVBT.m3#T">T</A> &lt;: Public;
  Public = HVSplit.T OBJECT
           METHODS
             &lt;* LL &lt;= VBT.mu *&gt;
             init (hv      : Axis.T;
                   size    : REAL      := DefaultSize;
                   op      : PaintOp.T := PaintOp.BgFg;
                   txt     : Pixmap.T  := Pixmap.Gray;
                   saveBits: BOOLEAN   := FALSE;
                   parlim  : INTEGER   := -1            ): T;
           END;
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>SplitterVBT</CODE> with
   no children.  See the <CODE>HVSplit</CODE> interface for an explanation
   of parameters <CODE>saveBits</CODE> and <CODE>parlim</CODE>.  See the <CODE>HVBar</CODE>
   interface for an explanation of the <CODE>size</CODE>, <CODE>op</CODE>, and <CODE>txt</CODE>
   parameters. 

<P><PRE>CONST
  DefaultSize = 2.0;

END SplitterVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
