<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/SplitterVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/SplitterVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="SplitterVBT.i3">SplitterVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/HVBar.i3">HVBar</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="MultiClass.i3">MultiClass</A>, <A HREF="MultiSplit.i3">MultiSplit</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>,
         <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="VBTKitResources.i3">VBTKitResources</A>;

TYPE
  MC = MultiClass.Split BRANDED OBJECT
       OVERRIDES
         insert  := Insert;
         replace := Replace;
       END;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        size: REAL;
        op:   PaintOp.T;
        txt:  Pixmap.T;
      OVERRIDES
        init := Init
      END;

VAR
  barPixmap: Pixmap.T;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v       : T;
                hv      : Axis.T;
                size               := DefaultSize;
                op                 := PaintOp.BgFg;
                txt                := Pixmap.Gray;
                saveBits           := FALSE;
                parlim             := -1            ): T =
  BEGIN
    GetResources();
    EVAL HVSplit.T.init(v, hv, saveBits, parlim, TRUE);
    v.size := size;
    v.op := op;
    v.txt := txt;
    MultiClass.Be(v, NEW(MC));
    RETURN v
  END Init;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (m: MC; pred, ch: VBT.T) =
  &lt;* FATAL MultiSplit.NotAChild *&gt;
  &lt;* FATAL Split.NotAChild *&gt;
  VAR
    neighbor: VBT.T;
    v       : T     := m.vbt;
  BEGIN
    IF pred = NIL THEN
      neighbor := MultiSplit.Succ (v, NIL)
    ELSE
      neighbor := pred
    END;
    IF neighbor = NIL THEN
      (* new child is only child *)
      Split.Insert (v, NIL, ch);
    ELSE
      Split.Insert (v, pred, ch);
      IF pred = NIL THEN
        Split.Insert (v, ch, NewBar (v));
      ELSE
        Split.Insert (v, pred, NewBar (v))
      END
    END
  END Insert;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; ch, new: VBT.T) =
  &lt;* FATAL Split.NotAChild *&gt;
  VAR hvBar: VBT.T;
  BEGIN
    WITH v = NARROW (m.vbt, T) DO
      IF new # NIL THEN         (* a true replace of a child *)
        Split.Replace (v, ch, new);
      ELSE                      (* a deletion *)
        hvBar := Split.Succ (v, ch);
        IF hvBar = NIL THEN hvBar := Split.Pred (v, ch) END;
        Split.Delete (v, ch);
        IF hvBar # NIL THEN Split.Delete (v, hvBar) END;
      END
    END
  END Replace;
</PRE><P>
<P>
PROCEDURE InsertT (m: MCTargets; pred, ch: VBT.T) =
  &lt;* FATAL Split.NotAChild *&gt;
  VAR
    (* tc := SourceVBT.TargetClassOf (ch); 
    <PRE>v    : T := m.vbt;
    hvBar    := NewBar(v);
  BEGIN
    (*
      SourceVBT.BeTarget (hvBar, SourceVBT.NewInserterTarget());
    *)
    Split.Insert(v, pred, hvBar);
    (*
      IF tc = NIL THEN tc := SourceVBT.NewSwapTarget() END;
      SourceVBT.BeTarget(ch, tc);
    *)
    Split.Insert(v, hvBar, ch);
  END InsertT;

PROCEDURE ReplaceT (m: MCTargets; ch, new: VBT.T) =
  &lt;* FATAL Split.NotAChild *&gt;
  VAR
    (* tc := SourceVBT.TargetClassOf (ch); *)
    v: T := m.vbt;
  BEGIN
    IF new # NIL THEN            (* a true replace of a child *)
      (*
      IF tc = NIL THEN tc := SourceVBT.NewSwapTarget() END;
      SourceVBT.BeTarget(new, tc);
      *)
      Split.Replace(v, ch, new);
    ELSE                         (* a deletion *)
      Split.Delete(v, Split.Succ(v, ch));
      Split.Delete(v, ch);
    END
  END ReplaceT;

*)

PROCEDURE <A NAME="NewBar"><procedure>NewBar</procedure></A> (v: T): HVBar.T =
  BEGIN
    RETURN HVBar.New(v.size, v.op, v.txt)
  END NewBar;

VAR
  rsrcMu := NEW (MUTEX);
  rsrcInit := FALSE;

PROCEDURE <A NAME="GetResources"><procedure>GetResources</procedure></A> () =
  BEGIN
    LOCK rsrcMu DO
      IF rsrcInit THEN RETURN END;
      barPixmap := VBTKitResources.GetPixmap (&quot;NWDiagonal&quot;);
      rsrcInit := TRUE;
    END
  END GetResources;

BEGIN
END SplitterVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
