<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/SwitchVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/SwitchVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> A <CODE>SwitchVBT</CODE> is a switch version of Trestle's <CODE>ButtonVBT</CODE>. 

<P><PRE>INTERFACE <interface><A HREF="SwitchVBT.m3">SwitchVBT</A></interface>;

IMPORT <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="MultiClass.i3">MultiClass</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  &lt;* SUBTYPE T &lt;: MultiFilter.T *&gt;
  <A HREF="SwitchVBT.m3#T">T</A> &lt;: Public;
  Public = ButtonVBT.T OBJECT
           METHODS
             &lt;* LL.sup &lt;= VBT.mu *&gt;
             init (f: FeedbackVBT.T): T;
             &lt;* LL.sup = VBT.mu *&gt;
             callback (READONLY cd: VBT.MouseRec);
           END;
</PRE> The call <CODE>v.init(f)</CODE> initializes <CODE>v</CODE> as a <CODE>SwitchVBT</CODE> with child
   <CODE>f</CODE>. The multi-child of <CODE>f</CODE> is marked as <CODE>v</CODE>'s multi-child too.
<P>
   The default <CODE>callback</CODE> method is a no-op. 

<P> The following type is useful for creating switches that have the
   same internal structure as a <CODE>SwitchVBT.T</CODE>; namely, a <CODE>Filter.T</CODE>
   whose child is a <CODE>FeedbackVBT.T</CODE>. 

<P><PRE>TYPE
  <A HREF="SwitchVBT.m3#MC">MC</A> &lt;: MultiClass.Filter;
</PRE> The following procedures are useful for some VBTkit switches
    to use as their default <CODE>ButtonVBT</CODE> methods: 

<P><PRE>PROCEDURE <A HREF="SwitchVBT.m3#Pre">Pre</A> (v: ButtonVBT.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Equivalent to: <CODE>Feedback.Excited (Filter.Child(v))</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SwitchVBT.m3#Post">Post</A> (v: ButtonVBT.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Equivalent to: <CODE>Feedback.Normal (Filter.Child(v))</CODE> </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="SwitchVBT.m3#Cancel">Cancel</A> (v: ButtonVBT.T);
&lt;* LL.sup = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Equivalent to: <CODE>Feedback.Normal (Filter.Child(v))</CODE> </EM></BLOCKQUOTE><PRE>

END SwitchVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
