<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/TrillSwitchVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/TrillSwitchVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="TrillSwitchVBT.i3">TrillSwitchVBT</A></implements></module>;

IMPORT <A HREF="../../vbtkitutils/src/AutoRepeat.i3">AutoRepeat</A>, <A HREF="../../ui/src/split/ButtonVBT.i3">ButtonVBT</A>, <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="MultiClass.i3">MultiClass</A>,
       <A HREF="MultiFilter.i3">MultiFilter</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="SwitchVBT.i3">SwitchVBT</A>, <A HREF="../../ui/src/vbt/Trestle.i3">Trestle</A>, <A HREF="../../ui/src/vbt/TrestleComm.i3">TrestleComm</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        firstDown: VBT.MouseRec;
        repeater : Repeater;
        trsl     : Trestle.T := NIL
      OVERRIDES
        init     := Init;
        callback := Callback;
        pre      := Pre;
        post     := Post;
        cancel   := Cancel;
        mouse    := Mouse;
        reshape  := Reshape;
        rescreen := Rescreen
      END;

TYPE
  MC = SwitchVBT.MC OBJECT END;

TYPE
  Repeater = AutoRepeat.T OBJECT
               v: T
             OVERRIDES
               repeat    := Repeat;
               canRepeat := CanRepeat
             END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; f: FeedbackVBT.T): T =
  BEGIN
    EVAL ButtonVBT.T.init(v, f, Action);
    MultiClass.Be(v, NEW(MC));
    WITH ch = MultiFilter.Child(f) DO
      IF ch # NIL THEN MultiClass.BeChild(v, ch) END;
    END;
    v.repeater := NEW(Repeater, v := v).init();
    RETURN v
  END Init;

PROCEDURE <A NAME="Callback"><procedure>Callback</procedure></A> (&lt;* UNUSED *&gt;          v : T;
                    &lt;* UNUSED *&gt; READONLY cd: VBT.MouseRec) =
  BEGIN
  END Callback;

PROCEDURE <A NAME="Action"><procedure>Action</procedure></A>(
    &lt;* UNUSED *&gt; selfAsButtonVBT: ButtonVBT.T;
    &lt;* UNUSED *&gt; READONLY cd: VBT.MouseRec) =
  BEGIN
  END Action;

PROCEDURE <A NAME="Repeat"><procedure>Repeat</procedure></A> (r: Repeater) =
  BEGIN
    LOCK VBT.mu DO
      WITH v = r.v DO v.firstDown.time := 0; v.callback (v.firstDown) END
    END
  END Repeat;

PROCEDURE <A NAME="Rescreen"><procedure>Rescreen</procedure></A> (v: T; READONLY cd: VBT.RescreenRec) =
  BEGIN
    v.trsl := Trestle.ScreenOf(v, Point.Origin).trsl;
    Public.rescreen(v, cd)
  END Rescreen;

PROCEDURE <A NAME="Reshape"><procedure>Reshape</procedure></A> (v: T; READONLY cd: VBT.ReshapeRec) =
  BEGIN
    IF v.trsl = NIL AND NOT Rect.IsEmpty(cd.new) THEN
      v.trsl := Trestle.ScreenOf(v, Point.Origin).trsl
    END;
    Public.reshape(v, cd)
  END Reshape;

PROCEDURE <A NAME="CanRepeat"><procedure>CanRepeat</procedure></A> (r: Repeater): BOOLEAN =
  &lt;* FATAL TrestleComm.Failure *&gt;
  BEGIN
    LOCK VBT.mu DO
      WITH trsl = r.v.trsl DO
        IF trsl = NIL THEN
          (* somehow uninstalled; stop trilling *)
          RETURN FALSE
        ELSE
         (* an installed vbt; continue trilling as long
           as there are no pending mouse clicks or keystrokes
           on their way to any top-level window installed by
           the trsl in wich v is installed. *)
          RETURN Trestle.AllCeded(trsl)
        END
      END
    END
  END CanRepeat;

PROCEDURE <A NAME="Pre"><procedure>Pre</procedure></A> (v: T) =
  BEGIN
    FeedbackVBT.Excited(Filter.Child(v));
    v.callback(v.firstDown);
    AutoRepeat.Start(v.repeater)
  END Pre;

PROCEDURE <A NAME="Post"><procedure>Post</procedure></A> (v: T) =
  BEGIN
    AutoRepeat.Stop(v.repeater);
    FeedbackVBT.Normal (Filter.Child (v));
  END Post;

PROCEDURE <A NAME="Cancel"><procedure>Cancel</procedure></A> (v: T) =
  BEGIN
    AutoRepeat.Stop(v.repeater);
    FeedbackVBT.Normal(Filter.Child(v));
  END Cancel;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (v: T; READONLY cd: VBT.MouseRec) =
  BEGIN
    IF cd.clickType = VBT.ClickType.FirstDown THEN v.firstDown := cd END;
    ButtonVBT.T.mouse(v, cd)
  END Mouse;

BEGIN
END TrillSwitchVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
