<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/VBTutils.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/VBTutils.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="VBTutils.i3">VBTutils</A></implements></module>;

IMPORT <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../etext/src/KeyTrans.i3">KeyTrans</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

&lt;* FATAL Thread.Alerted, Wr.Failure *&gt;

PROCEDURE <A NAME="WriteCursorPosition"><procedure>WriteCursorPosition</procedure></A> (wr: Wr.T; READONLY cp: VBT.CursorPosition) =
  CONST Not = ARRAY BOOLEAN OF TEXT {&quot;not &quot;, &quot;&quot;};
  BEGIN
    Wr.PutText (
      wr, Fmt.F (&quot;{CursorPos pt=[%s,%s] screen=%s %sgone %soffScreen}&quot;,
                 Fmt.Int (cp.pt.h), Fmt.Int (cp.pt.v), Fmt.Int (cp.screen),
                 Not [cp.gone], Not [cp.offScreen]))
  END WriteCursorPosition;

PROCEDURE <A NAME="WriteKeyRec"><procedure>WriteKeyRec</procedure></A> (wr: Wr.T; READONLY kr: VBT.KeyRec) =
  BEGIN
    Wr.PutText (wr, Fmt.F (&quot;{KeyRec whatChanged=%s (%s) wentDown=%s &quot;,
                           Fmt.Int (kr.whatChanged),
                           Fmt.Char (KeyTrans.Latin1 (kr.whatChanged)),
                           Fmt.Bool (kr.wentDown)));
    WriteModifiers (wr, kr.modifiers);
    Wr.PutChar (wr, ' ');
    WriteTimeStamp (wr, kr.time);
    Wr.PutChar (wr, '}')
  END WriteKeyRec;

PROCEDURE <A NAME="WriteMiscRec"><procedure>WriteMiscRec</procedure></A> (wr: Wr.T; READONLY cd: VBT.MiscRec) =
  BEGIN
    Wr.PutText (wr,
                Fmt.F (&quot;{MiscRec type=%s detail=&lt;%s,%s&gt; selection=%s &quot;,
                       VBT.MiscCodeTypeName (cd.type),
                       Fmt.Int (cd.detail [0]), Fmt.Int (cd.detail [1]),
                       VBT.SelectionName (cd.selection)));
    WriteTimeStamp (wr, cd.time);
    Wr.PutChar (wr, '}')
  END WriteMiscRec;

PROCEDURE <A NAME="WriteModifiers"><procedure>WriteModifiers</procedure></A> (wr: Wr.T; READONLY mods: VBT.Modifiers) =
  CONST
    ModifierNames = ARRAY VBT.Modifier OF
                      TEXT {
                      &quot;Shift&quot;, &quot;Lock&quot;, &quot;Control&quot;, &quot;Option&quot;, &quot;Mod0&quot;, &quot;Mod1&quot;,
                      &quot;Mod2&quot;, &quot;Mod3&quot;, &quot;MouseL&quot;, &quot;MouseM&quot;, &quot;MouseR&quot;,
                      &quot;Mouse0&quot;, &quot;Mouse1&quot;, &quot;Mouse2&quot;, &quot;Mouse3&quot;, &quot;Mouse4&quot;};
  BEGIN
    Wr.PutText (wr, &quot;{Modifiers&quot;);
    FOR i := FIRST (VBT.Modifier) TO LAST (VBT.Modifier) DO
      IF i IN mods THEN
        Wr.PutChar (wr, ' ');
        Wr.PutText (wr, ModifierNames [i])
      END
    END;
    Wr.PutChar (wr, '}')
  END WriteModifiers;

PROCEDURE <A NAME="WriteMouseRec"><procedure>WriteMouseRec</procedure></A> (wr: Wr.T; READONLY cd: VBT.MouseRec) =
  CONST
    ButtonNames = ARRAY VBT.Button OF
                    TEXT {&quot;MouseL&quot;, &quot;MouseM&quot;, &quot;MouseR&quot;, &quot;Mouse0&quot;, &quot;Mouse1&quot;,
                          &quot;Mouse2&quot;, &quot;Mouse3&quot;, &quot;Mouse4&quot;};
    ClickNames = ARRAY VBT.ClickType OF
                   TEXT {&quot;FirstDown&quot;, &quot;OtherDown&quot;, &quot;OtherUp&quot;, &quot;LastUp&quot;};
  BEGIN
    Wr.PutText (
      wr, Fmt.F (&quot;{MouseRec whatChanged=%s clickType=%s clickCount=%s &quot;,
                 ButtonNames [cd.whatChanged], ClickNames [cd.clickType],
                 Fmt.Int (cd.clickCount)));
    WriteCursorPosition (wr, cd.cp);
    Wr.PutChar (wr, ' ');
    WriteTimeStamp (wr, cd.time);
    Wr.PutChar (wr, ' ');
    WriteModifiers (wr, cd.modifiers);
    Wr.PutText (wr, &quot;}&quot;)
  END WriteMouseRec;

PROCEDURE <A NAME="WritePositionRec"><procedure>WritePositionRec</procedure></A> (wr: Wr.T; READONLY pr: VBT.PositionRec) =
  &lt;* FATAL Wr.Failure, Thread.Alerted *&gt;
  BEGIN
    Wr.PutText (wr, &quot;{PositionRec &quot;);
    WriteCursorPosition (wr, pr.cp);
    Wr.PutChar (wr, ' ');
    WriteModifiers (wr, pr.modifiers);
    Wr.PutChar (wr, ' ');
    WriteTimeStamp (wr, pr.time);
    Wr.PutChar (wr, '}')
  END WritePositionRec;

PROCEDURE <A NAME="WriteTimeStamp"><procedure>WriteTimeStamp</procedure></A> (wr: Wr.T; t: VBT.TimeStamp) =
  BEGIN
    Wr.PutText (wr, Fmt.F (&quot;{time %s}&quot;, Fmt.Unsigned (t, 10)))
  END WriteTimeStamp;

BEGIN END VBTutils.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
