<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ViewportVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ViewportVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> A <CODE>ViewportVBT</CODE> is a multi-filter that displays multiple
   views of a child <CODE>VBT</CODE>, with optional horizontal and
   vertical scrollbars.  When the child's preferred size is
   larger than the viewport's {\em interior} (that is, the screen
   of the viewport minus the scrollbars), the child is reformatted
   to its preferred size.  Since only part of the child is
   visible, the user can pan the child using the scrollbars.
   When the child's preferred size is smaller than the viewport's
   screen, the child is reformatted to the size of the viewport
   interior, and the scrollbars are ineffective.
<P>
   Views may be added or deleted under program control or by
   appropriate gestures in the scrollbar: Option Left click adds
   a new view after the view in which the user clicked.  Option
   Right click removes the view (unless, of course, it would
   leave the viewport with zero views!). 

<P><PRE>INTERFACE <interface><A HREF="ViewportVBT.m3">ViewportVBT</A></interface>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

TYPE
  &lt;* SUBTYPE T &lt;: MultiFilter.T *&gt;
  <A HREF="ViewportVBT.m3#T">T</A> &lt;: Public;
  Public = HVSplit.T OBJECT
           METHODS
             &lt;* LL &lt;= VBT.mu *&gt;
             init (ch             : VBT.T;
                   axis           : Axis.T   := Axis.T.Ver;
                   shadow         : Shadow.T := NIL;
                   step           : CARDINAL := 10;
                   adjustableViews: BOOLEAN  := TRUE;
                   scrollStyle := ScrollStyle.AlaViewport;
                   shapeStyle  := ShapeStyle.Unrelated): T;
           END;
</PRE> The call to <CODE>v.init(..)</CODE> initializes <CODE>v</CODE> as a <CODE>ViewportVBT.T</CODE>.  The
   <CODE>axis</CODE> parameter says whether the views are arranged vertically or
   horizontally.  <CODE>step</CODE> is the number of pixels to move while
   auto-scrolling.  <CODE>shadow</CODE> gives the shadow for displaying scrollbars,
   resets and hvbars.  When <CODE>adjustableViews</CODE> is <CODE>TRUE</CODE>, an <CODE>HVBar</CODE>
   will be inserted between views so the user can adjust the screen
   allocated to each view.  <CODE>scrollStyle</CODE> and <CODE>shapeStyle</CODE> are explained
   below.
<P>
   The internal structure of a viewport is a rather complex
   collection of <CODE>JoinedVBT</CODE>s, <CODE>HVSplit</CODE>s, <CODE>ScrollerVBT</CODE>s, and
   others.  It depends on the options with which the viewport
   was created. Be sure to use the <CODE>MultiFilter</CODE> interface to get at the
   child.  

<P><PRE>TYPE
  View = INTEGER;
</PRE> A <CODE>View</CODE> is an internal ID for a view.  The value is valid for
   the life of a view (i.e., until it is removed by a user
   gesture or by a call to <CODE>RemoveView</CODE>).  Thereafter, the ID may
   be reused.  The initial view created by the <CODE>init</CODE> method has
   a value of 0. 

<P> A viewport can be created with a number of different styles of
   scrollbars: 

<P><PRE>TYPE
  ScrollStyle =
    {HorAndVer,
     HorOnly,
     VerOnly,
     NoScroll,
     AlaViewport,
     Auto};
</PRE> \noindent The styles are as follows:
<P>
   \begin{itemize}
<P>
   \item <CODE>HorAndVer</CODE> puts a horizontal and vertical scrollbar
   on every view.  In addition, nestled between the scrollbars
   in the southwest corner, there's a little ``reset'' button
   that moves the northwest corner of the child to the northwest
   corner of the view.
<P>
   \item <CODE>HorOnly</CODE> places a scrollbar at the bottom.
<P>
   \item <CODE>VerOnly</CODE> places a scrollbar at the left side.
<P>
   \item <CODE>NoScroll</CODE> specifies that views will not have scrollbars.
<P>
   \item <CODE>AlaViewport</CODE> specifies that there is a scrollbar in the
   same axis as the viewport.  Thus, <CODE>AlaViewport</CODE> for a vertical
   viewport is equivalent to <CODE>VerOnly</CODE>.
<P>
   \item <CODE>Auto</CODE> specifies that scrollbars appear only when the
   preferred size of the child exceeds the size of the viewport (in
   that dimension).
<P>
   \end{itemize} 

<P>
<P> There are two possible shape-relationships between a viewport
   and its child: 

<P><PRE>TYPE ShapeStyle = {Unrelated, Related};
</PRE> <CODE>Unrelated</CODE> makes the shape of the child equal to its preferred
   shape---completely unrelated to the viewport's current shape.
<P>
   <CODE>Related</CODE> makes the child's shape equal to the viewport's shape in
   the non-axis direction of the viewport.  In the viewport's axis
   direction, the child's preferred shape is used.  For example, the
   width of the child in a <CODE>Vertical</CODE> viewport is the width of the
   viewport. 

<P> \subsubsection{Panning the contents} 

<P>
<P><PRE>PROCEDURE <A HREF="ViewportVBT.m3#ScrollTo">ScrollTo</A> (         v    : T;
                    READONLY r    : Rect.T;
                             view : View     := 0;
                             force: BOOLEAN  := TRUE);
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Scroll the viewport <CODE>v</CODE> so that rectangle <CODE>r</CODE> is visible in
   view <CODE>view</CODE>.  Rectangle <CODE>r</CODE> will be roughly centered within
   <CODE>v</CODE>, but if <CODE>r</CODE> is too big to be seen entirely, its northwest
   corner will be made visible.  If <CODE>force</CODE> is <CODE>FALSE</CODE> and <CODE>r</CODE>
   is already entirely visible, this procedure is a no-op.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ViewportVBT.m3#Normalize">Normalize</A> (v: T; w: VBT.T; view: View := 0);
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> If the domain of <CODE>w</CODE> is non-empty and it's entirely visible,
   do nothing.  Otherwise, do a <CODE>ScrollTo</CODE> to <CODE>w</CODE>'s domain in
   view <CODE>view</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> At first blush, <CODE>Normalize</CODE> seems to be just a call to
<PRE>
      ScrollTo(v, VBT.Domain(w), FALSE)
   </PRE>
However, if <CODE>w</CODE> doesn't
   have a domain, as is the case when <CODE>w</CODE> has been recently
   installed and the <CODE>VBT</CODE> tree has not been redisplayed, a thread
   is forked to wait until it can acquire <CODE>VBT.mu</CODE> (recall that
   <CODE>Normalize</CODE> and <CODE>ScrollTo</CODE> have <CODE>LL = VBT.mu</CODE>).  After the
   lock is acquired, all pending redisplays are satisfied, and
   then <CODE>ScrollTo</CODE> of <CODE>w</CODE>'s domain is invoked.  Since the thread
   executes outside event-time, it explicitly causes all marked
   <CODE>VBT</CODE>s to be redisplayed after it calls <CODE>ScrollTo</CODE>. 

<P> \subsubsection{Multiple views} 

<P><PRE>PROCEDURE <A HREF="ViewportVBT.m3#AddView">AddView</A> (v: T; pred: View := -1; split := TRUE):
  View;
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Add another view after the view <CODE>pred</CODE> (-1 means add as the
   first view) of the child.  If <CODE>split</CODE> is <CODE>TRUE</CODE>, then the new
   view and the view <CODE>pred</CODE> will occupy the area previously
   occupied by the view <CODE>pred</CODE>.  The area of all other views
   will be unchanged.  The value returned is an internal ID for
   the view.  This value may be reused after the view has been
   removed. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ViewportVBT.m3#RemoveView">RemoveView</A> (v: T; view: View);
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Remove the view <CODE>view</CODE> from <CODE>v</CODE>'s child.  The ID for the initial
   view created by the <CODE>init</CODE> method is 0. </EM></BLOCKQUOTE><PRE>

END ViewportVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
