<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ZChassisVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ZChassisVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> A <CODE>ZChassisVBT</CODE> multi-filter provides a {\em chassis} for a
   subwindow. The visual display of the chassis is hard-wired into
   this module; in particular, it won't look like a top-level window
   of most of the common X window managers.  The top of the chassis is
   a banner containing (from left to right) a {\em close button}, {\em
   draggable title}, and a {\em grow button}. (See
   Figure~\ref{fig:zchassis}.)
<P>
   Clicking on the close button unmaps the <CODE>ZChassisVBT</CODE>, thereby
   causing it to disappear.  Dragging the title allows the user to
   reposition the <CODE>ZChassisVBT</CODE> within its parent. Clicking on the
   grow button allows the user to change the size of the
   <CODE>ZChassisVBT</CODE>, subject to its size constraints.  That is, the user
   isn't allowed to make the interior of the chassis smaller or larger
   than its reported bounds along each dimension.  

<P><PRE>INTERFACE <interface><A HREF="ZChassisVBT.m3">ZChassisVBT</A></interface>;

IMPORT <A HREF="Shadow.i3">Shadow</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="ZChildVBT.i3">ZChildVBT</A>, <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>;

TYPE
  &lt;* SUBTYPE T &lt;: MultiFilter.T *&gt;
  <A HREF="ZChassisVBT.m3#T">T</A> &lt;: Public;
  Public =
    ZChildVBT.T OBJECT
    METHODS
      &lt;* LL.sup &lt;= VBT.mu *&gt;
      init (ch      : VBT.T;
            title   : VBT.T;
            shadow  : Shadow.T := NIL;
            closable: BOOLEAN  := TRUE;
            open    : BOOLEAN  := TRUE;
            h, v               := 0.5;
            loc                := ZChildVBT.Location.Center;
            type               := ZChildVBT.CoordType.Scaled;
            shaper: ZSplit.ReshapeControl := NIL):
            T;
      initFromEdges (ch        : VBT.T;
                     title     : VBT.T;
                     w, e, n, s: REAL;
                     shadow    : Shadow.T := NIL;
                     closable  : BOOLEAN  := TRUE;
                     open      : BOOLEAN  := TRUE;
                     type := ZChildVBT.CoordType.Absolute;
                     shaper: ZSplit.ReshapeControl := NIL): T;

      &lt;* LL = VBT.mu *&gt;
      callback (READONLY cd: VBT.MouseRec);
    END;

END ZChassisVBT.
</PRE> The call <CODE>v.init(...)</CODE> initializes <CODE>v</CODE> as a <CODE>ZChassisVBT</CODE>.  It is
   assumed that <CODE>v</CODE> will be a subwindow.  The interior of the chassis,
   <CODE>ch</CODE>, is <CODE>v</CODE>'s child in the multi-child sense.
<P>
   An alternative method, <CODE>v.initFromEdges</CODE>, also initializes <CODE>v</CODE>,
   using different information for specifying the initial location of
   the subwindow.  (See the <CODE>ZChildVBT</CODE> interface on
   page~\pageref{ZChildVBTSection} for details of the <CODE>h</CODE>, <CODE>v</CODE>, <CODE>loc</CODE>,
   and <CODE>type</CODE> parameters to <CODE>init</CODE>, as well as for details of the <CODE>w</CODE>,
   <CODE>e</CODE>, <CODE>n</CODE>, <CODE>s</CODE>, and <CODE>type</CODE> parameters to <CODE>initFromEdges</CODE>.)
<P>
   A close button is displayed iff <CODE>closable</CODE> is set.  The grow button
   is implemented with a <CODE>ZGrowVBT</CODE>.  <CODE>title</CODE> also functions as a drag
   bar.  It is implemented by a <CODE>ZMoveVBT</CODE>.  The looks of these
   buttons is governed by the <CODE>shadow</CODE> parameter.
<P>
   If <CODE>open</CODE> is <CODE>TRUE</CODE>, then <CODE>v</CODE> will be visible when it is inserted
   as a child of its parent <CODE>ZSplit</CODE>.
<P>
   In the current implementation, a chassis has the following general
   structure (using FormsVBT notation):
<P>
<PRE>
       (Stable 
         (Border
           (VBox
             (HBox (CloseButton &quot;C&quot;)
                   (ZMove <KBD>{\it title}</KBD>)
                   (ZGrow &quot;G&quot;))
             (Frame <KBD>{\it ch}</KBD>)))))
</PRE>
   See Figure~\ref{fig:zchassis}.
   <P>
   However, don't try to traverse the VBT tree directly; it is subject
   to change.  To retrieve the contents of a chassis <CODE>v</CODE>, use
   <CODE>MultiFilter.Child(v)</CODE>.
<P>
   <CODE>v.callback(cd)</CODE> is invoked when the close button is activated.
   The default method is a no-op.
<P>
   A <CODE>ZChassisVBT</CODE>'s move, grow, and close buttons are not
   effective unless the <CODE>ZChassis</CODE> is a non-background child of a
   <CODE>ZSplit</CODE>. 

<P>
<P>
<P>
<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
