<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ZChassisVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ZChassisVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ZChassisVBT.i3">ZChassisVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/BorderedVBT.i3">BorderedVBT</A>, <A HREF="../../ui/src/split/Filter.i3">Filter</A>, <A HREF="FlexVBT.i3">FlexVBT</A>, <A HREF="../../ui/src/vbt/Font.i3">Font</A>, <A HREF="../../ui/src/split/HVSplit.i3">HVSplit</A>,
       <A HREF="MultiClass.i3">MultiClass</A>, <A HREF="Shadow.i3">Shadow</A>, <A HREF="ShadowedFeedbackVBT.i3">ShadowedFeedbackVBT</A>, <A HREF="ShadowedVBT.i3">ShadowedVBT</A>,
       <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="../../ui/src/split/StableVBT.i3">StableVBT</A>, <A HREF="SwitchVBT.i3">SwitchVBT</A>, <A HREF="../../ui/src/split/TextVBT.i3">TextVBT</A>, <A HREF="../../ui/src/split/TextureVBT.i3">TextureVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>,
       <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>, <A HREF="ZChildVBT.i3">ZChildVBT</A>, <A HREF="ZGrowVBT.i3">ZGrowVBT</A>, <A HREF="ZMoveVBT.i3">ZMoveVBT</A>, <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>,
       <A HREF="ZSplitUtils.i3">ZSplitUtils</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        holder: Filter.T;
      OVERRIDES
        init          := Init;
        initFromEdges := InitFromEdges;
        callback      := Callback;
      END;

TYPE
  MC = MultiClass.Filter OBJECT
       OVERRIDES
         replace := Replace;
       END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (z       : T;
                ch      : VBT.T;
                title   : VBT.T;
                shadow  : Shadow.T := NIL;
                closable: BOOLEAN  := TRUE;
                open    : BOOLEAN  := TRUE;
                h, v               := 0.5;
                loc                := ZChildVBT.Location.Center;
                type               := ZChildVBT.CoordType.Scaled;
                shaper: ZSplit.ReshapeControl := NIL): T =
  VAR interior := CommonInit (z, ch, title, shadow, closable);
  BEGIN
    EVAL
      ZChildVBT.T.init (z, interior, h, v, loc, type, shaper, open);
    MultiClass.Be (z, NEW (MC));
    MultiClass.BeChild (z, ch);
    RETURN z
  END Init;

PROCEDURE <A NAME="InitFromEdges"><procedure>InitFromEdges</procedure></A> (v         : T;
                         ch        : VBT.T;
                         title     : VBT.T;
                         w, e, n, s: REAL;
                         shadow    : Shadow.T := NIL;
                         closable  : BOOLEAN  := TRUE;
                         open      : BOOLEAN  := TRUE;
                         type := ZChildVBT.CoordType.Absolute;
                         shaper: ZSplit.ReshapeControl := NIL): T =
  VAR interior := CommonInit (v, ch, title, shadow, closable);
  BEGIN
    EVAL ZChildVBT.T.initFromEdges (v, interior,
           w, e, n, s, type, shaper, open);
    MultiClass.Be (v, NEW (MC));
    MultiClass.BeChild (v, ch);
    RETURN v
  END InitFromEdges;

CONST BARWIDTH = 0.3;

PROCEDURE <A NAME="CommonInit"><procedure>CommonInit</procedure></A> (v       : T;
                      ch      : VBT.T;
                      title   : VBT.T;
                      shadow  : Shadow.T := NIL;
                      closable: BOOLEAN  := TRUE ): VBT.T =
  VAR close, drag, stretchyDrag, grow, banner, box: VBT.T;
  BEGIN
    IF shadow = NIL THEN shadow := Shadow.None END;
    drag := NEW (ZMoveVBT.T).init (
              NEW (ShadowedFeedbackVBT.T).init (title, shadow));
    stretchyDrag := NEW (FlexVBT.T).init (drag, FlexVBT.Stretchy);
    grow := NEW (ZGrowVBT.T).init (NewBtn (&quot;G&quot;, shadow));
    banner := HVSplit.New (Axis.T.Hor);
    IF closable THEN
      close :=
        NEW (SwitchVBT.T, callback := Close).init (NewBtn (&quot;C&quot;, shadow));
      Split.AddChild (banner, close, VBar (shadow))
    END;
    Split.AddChild (banner, stretchyDrag, VBar (shadow), grow);
    v.holder := NEW (Filter.T).init (ch);
    box :=
      HVSplit.Cons (
        Axis.T.Ver, banner,
        FlexVBT.FromAxis (
          TextureVBT.New (shadow.fg), Axis.T.Ver, FlexVBT.RigidRange (BARWIDTH)),
        NEW (ShadowedVBT.T).init (v.holder, shadow, Shadow.Style.Raised));
    RETURN StableVBT.New (NEW (BorderedVBT.T).init (box, BARWIDTH, shadow.fg))
  END CommonInit;

PROCEDURE <A NAME="NewBtn"><procedure>NewBtn</procedure></A> (t: TEXT; shadow: Shadow.T): VBT.T =
  BEGIN
    WITH textVBT = TextVBT.New (t) DO
      TextVBT.SetFont (textVBT, Font.BuiltIn, shadow);
      RETURN NEW (ShadowedFeedbackVBT.T).init (textVBT, shadow)
    END
  END NewBtn;

PROCEDURE <A NAME="VBar"><procedure>VBar</procedure></A> (shadow: Shadow.T): VBT.T =
  BEGIN
    IF shadow.size # 0.0 THEN
      RETURN NIL
    ELSE
      RETURN FlexVBT.FromAxis (TextureVBT.New (shadow.bgFg), Axis.T.Hor,
                               FlexVBT.RigidRange (BARWIDTH))
    END
  END VBar;

PROCEDURE <A NAME="Close"><procedure>Close</procedure></A> (v: VBT.T; READONLY cd: VBT.MouseRec) =
  VAR zch: T := ZSplitUtils.FindZChild (v);
  BEGIN
    IF zch # NIL THEN ZSplit.Unmap (zch); zch.callback (cd) END;
  END Close;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; &lt;* UNUSED *&gt; ch: VBT.T; new: VBT.T) =
  VAR v: T := m.vbt;
  BEGIN
    EVAL Filter.Replace (v.holder, new)
  END Replace;

PROCEDURE <A NAME="Callback"><procedure>Callback</procedure></A> (&lt;* UNUSED *&gt;          v : T;
                    &lt;* UNUSED *&gt; READONLY cd: VBT.MouseRec) =
  BEGIN
  END Callback;

BEGIN
END ZChassisVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
