<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ZChildVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ZChildVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
&lt;* PRAGMA SUBTYPE *&gt;
</PRE> An <CODE>ZChildVBT.T</CODE> is a VBT that is typically used as a subwindow.
<P>
   A <CODE>ZChildVBT</CODE> is a subclass of a <CODE>HighlightVBT</CODE> that insulates any
   highlighting done in the <CODE>ZChildVBT</CODE> from highlighting done in
   other subwindows.  Clients should use a <CODE>ZBackgroundVBT</CODE> around the
   background child in order to insulate highlighting in the
   background child from highlighting in the subwindows.
<P>
   There are two alternate ways to initialize a <CODE>ZChildVBT</CODE>. Each
   allows the client to specify whether the subwindow should be
   initially visible (``mapped'') and how the subwindow should
   be reshaped when the parent <CODE>ZSplit</CODE> is reshaped.
<P>
   The method call <CODE>v.init(...)</CODE> allows the client to specify where
   the center or a corner of <CODE>v</CODE> should be placed, relative to the
   parent, either in absolute distance (in millimeters) from the
   parent's northwest corner (<CODE>CoordType.Absolute</CODE>), or as percentages
   of the parent's width and height (<CODE>CoordType.Scaled</CODE>).  The default
   is to align the center of <CODE>v</CODE> with the center of the parent. The size
   of <CODE>v</CODE> is its preferred sizes in both the horizontal and vertical
   dimensions.
<P>
   The method call <CODE>v.initFromEdges(...)</CODE> allows the client to specify
   the edges of <CODE>v</CODE>, either in absolute distance (in millimeters) from
   the parent's northwest corner (this is the only case in which the
   client specifies the absolute size of <CODE>v</CODE>), or as percentages of
   the parent's width and height.
<P>
   The implementation will not pop up a subwindow with its northwest
   corner north or west of the visible portion of the <CODE>ZSplit</CODE> parent;
   it will override the specified position as necessary to bring it
   into view. It is a checked runtime error to specify scaled
   coordinates (percentages) that are outside the range 0.0--1.0.
   If the specified position is overriden, or if the subwindow is 
   not entirely visible when the subwindow is first made visible, 
   the implementation will also override the reshape method so that 
   the subwindow will be repositioned using the information specified
   when it was initialized.
<P>
   Finally, in order for the reformatting to meet specifications
   above, the client must call <CODE>Inserted</CODE> after the subwindow is
   inserted as a child of a <CODE>ZSplit</CODE>; the client must call <CODE>Moved</CODE>
   after the subwindow is repositioned by the user; and the client
   must call <CODE>Grew</CODE> after the size of the subwindow is changed by the
   user. 

<P><PRE>INTERFACE <interface><A HREF="ZChildVBT.m3">ZChildVBT</A></interface>;

IMPORT <A HREF="../../ui/src/split/HighlightVBT.i3">HighlightVBT</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>;

TYPE
  Location = {NW, NE, SW, SE, Center};
  CoordType = {Absolute, Scaled};
  <A HREF="ZChildVBT.m3#T">T</A> &lt;: Public;
  Public = HighlightVBT.T OBJECT
           METHODS
             &lt;* LL &lt;= VBT.mu *&gt;
             init (ch  : VBT.T;
                   h, v          := 0.5;
                   loc           := Location.Center;
                   type          := CoordType.Scaled;
                   shaper: ZSplit.ReshapeControl := NIL;
                   open: BOOLEAN                 := TRUE): T;
             initFromEdges (ch: VBT.T;
                            w, e, n, s: REAL;
                            type := CoordType.Absolute;
                            shaper: ZSplit.ReshapeControl := NIL;
                            open := TRUE): T;
           END;

PROCEDURE <A HREF="ZChildVBT.m3#InitiallyMapped">InitiallyMapped</A> (v: VBT.T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> If <CODE>v</CODE> is a <CODE>ZChild</CODE>, return the value of <CODE>open</CODE> when it was
   initialized.  Otherwise, return <CODE>TRUE</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZChildVBT.m3#Pop">Pop</A> (v: VBT.T; forcePlace := FALSE);
</PRE><BLOCKQUOTE><EM> Map <CODE>v</CODE> and lift it to the top of its parent's children.  If
   <CODE>forcePlace</CODE> is set, position <CODE>v</CODE> at its initial location. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZChildVBT.m3#Inserted">Inserted</A> (v: VBT.T);
</PRE><BLOCKQUOTE><EM> The client must call this procedure after <CODE>v</CODE> has been inserted
   into a <CODE>ZSplit</CODE>.  This procedure sets a <CODE>ReshapeControl</CODE> object on
   <CODE>v</CODE>.  If <CODE>v</CODE> isn't a <CODE>ZChildVBT</CODE>, the <CODE>ReshapeControl</CODE> tries to
   center <CODE>v</CODE>, subject to the contraint that its northwest corner is
   just visible.  If <CODE>v</CODE> is a <CODE>ZChild</CODE>, the <CODE>ReshapeControl</CODE> will
   follow <CODE>vbt</CODE>'s initial position until <CODE>v</CODE> is moved by the user
   (usually because <CODE>Moved</CODE> is called).  At that point, the northwest
   corner of <CODE>v</CODE> will remain at that position relative to its parent,
   until the user moves it again. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZChildVBT.m3#Moved">Moved</A> (v: VBT.T);
</PRE><BLOCKQUOTE><EM> The client must call this procedure after <CODE>v</CODE> has been moved by a
   user.  If <CODE>v</CODE> is a <CODE>ZChildVBT</CODE>, this procedure notes that <CODE>v</CODE> has
   been moved by the user, so that the next time it is reshaped, <CODE>v</CODE>
   will retain its current position relative to its parent.  If <CODE>v</CODE>
   isn't a <CODE>ZChildVBT</CODE>, this procedure is a no-op. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ZChildVBT.m3#Grew">Grew</A> (v: VBT.T; w, h: INTEGER);
</PRE><BLOCKQUOTE><EM> The client must call this procedure after the size of <CODE>v</CODE> has been
   changed to <CODE>w</CODE>-by-<CODE>h</CODE> (in pixels) by a user.  If <CODE>v</CODE> is a
   <CODE>ZChildVBT</CODE>, this procedure notes that <CODE>v</CODE> has a new shape and
   calls <CODE>VBT.NewShape</CODE> to tell the parent <CODE>ZSplit</CODE>.  Subsequently,
   <CODE>v</CODE> will report its shape as <CODE>w</CODE>-by-<CODE>h</CODE>.  If <CODE>v</CODE> is not a
   <CODE>ZChildVBT</CODE>, this procedure is a no-op. </EM></BLOCKQUOTE><PRE>
</PRE> Finally, here are a few <CODE>ZSplit</CODE> reshape controllers
   that are sometimes useful:  

<P><PRE>VAR (*CONST*)
  Scaled: ZSplit.ReshapeControl;
  ScaledHFixed: ZSplit.ReshapeControl;
  ScaledVFixed: ZSplit.ReshapeControl;
  ScaledHVFixed: ZSplit.ReshapeControl;
</PRE> <CODE>Scaled</CODE> reshapes the child by 
   scaling the old child domain to occupy the same relative position
   of the changing parent domain. <CODE>ScaledHFixed</CODE> does the same, and then
   insets the west and east edges so that the child's width is not
   changed. Similarly, <CODE>ScaledVFixed</CODE> scales the child's domain and then
   insets the north and south edges. <CODE>ScaledHVFixed</CODE> insets both the
   north and south edges and the west and east edges so the size of
   the child's domain stays fixed. In other words, <CODE>ScaledHVFixed</CODE> can
   be used to reposition the center point of the child without changing
   its size. 

<P><PRE>END ZChildVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
