<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ZGrowVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ZGrowVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ZGrowVBT.i3">ZGrowVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/BtnVBTClass.i3">BtnVBTClass</A>, <A HREF="../../ui/src/vbt/Cursor.i3">Cursor</A>, <A HREF="FeedbackVBT.i3">FeedbackVBT</A>, <A HREF="../../geometry/src/Point.i3">Point</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>,
       <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../ui/src/vbt/VBTClass.i3">VBTClass</A>, <A HREF="ZMoveVBT.i3">ZMoveVBT</A>, <A HREF="ZSplitUtils.i3">ZSplitUtils</A>;

TYPE
  Sides = RECORD north, west, south, east: BOOLEAN; END;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
        zChild : VBT.T;
        firstDown: Point.T;
        sides: Sides;
        rect   : Rect.T;
        stuck  : BOOLEAN;
        shape  : ARRAY Axis.T OF VBT.SizeRange;
      OVERRIDES
        init   := Init;
        mouse  := Mouse;
        pre    := Pre;
        during := During;
      END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v: T; f: FeedbackVBT.T): T =
  BEGIN
    GetResources();
    EVAL ZMoveVBT.T.init (v, f);
    RETURN v
  END Init;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (v: T; READONLY cd: VBT.MouseRec) =
  BEGIN
    v.firstDown := cd.cp.pt;
    ZMoveVBT.T.mouse(v, cd);
  END Mouse;

PROCEDURE <A NAME="Pre"><procedure>Pre</procedure></A> (v: T) =
  BEGIN
    ZMoveVBT.T.pre(v);
    IF NOT v.ready THEN RETURN END;
    v.zChild := ZSplitUtils.FindZChild(v);
    v.rect := VBT.Domain(v.zChild);
    v.shape := VBTClass.GetShapes(v.zChild, FALSE);
    FindCloseSides(v, v.firstDown, v.sides);
    ChangeSides(v, v.firstDown);
    OrientCursor(v, v.sides);
    ZMoveVBT.MoveAndHighlight(v, v.rect);
  END Pre;

PROCEDURE <A NAME="During"><procedure>During</procedure></A> (v: T; READONLY cd: VBT.PositionRec) =
  VAR pt := cd.cp.pt; sides: Sides;
  BEGIN
    IF Rect.Member(pt, VBT.Domain(VBT.Parent(v.zChild))) THEN
      (* only grow a child inside of ZSplit's domain *)
      IF FindStuckSides(v, pt) THEN
        ChangeSides(v, pt);
        sides := v.sides;
      ELSE
        FindCloseSides(v, pt, sides)
      END;
      OrientCursor(v, sides)
    END;
    ZMoveVBT.MoveAndHighlight(v, v.rect);
  END During;

PROCEDURE <A NAME="FindStuckSides"><procedure>FindStuckSides</procedure></A> (v: T; READONLY pt: Point.T): BOOLEAN =
  BEGIN
    WITH s = v.sides,
         r = v.rect   DO
      (* aliases; v.sides can change! *)
      IF pt.h &lt; r.west THEN
        s.west := TRUE;
        s.east := FALSE;
      ELSIF pt.h &gt; r.east THEN
        s.west := FALSE;
        s.east := TRUE;
      END;
      IF pt.v &lt; r.north THEN
        s.north := TRUE;
        s.south := FALSE;
      ELSIF pt.v &gt; r.south THEN
        s.north := FALSE;
        s.south := TRUE;
      END;
      RETURN s.east OR s.west OR s.north OR s.south
    END
  END FindStuckSides;

PROCEDURE <A NAME="FindCloseSides"><procedure>FindCloseSides</procedure></A> (            v : T;
                          READONLY    pt: Point.T;
                          VAR (*OUT*) s : Sides    ) =
  CONST C = 4;
  VAR
    dW    := pt.h - v.rect.west;
    dE    := v.rect.east - pt.h;
    dN    := pt.v - v.rect.north;
    dS    := v.rect.south - pt.v;
    hFuzz := ROUND(VBT.MMToPixels(v, 1.0, Axis.T.Hor));
    vFuzz := ROUND(VBT.MMToPixels(v, 1.0, Axis.T.Ver));
  BEGIN
    s.west := dW &lt;= hFuzz + MIN(dE, MIN(dN, dS));
    s.east := dE &lt;= hFuzz + MIN(dW, MIN(dN, dS));
    s.north := dN &lt;= vFuzz + MIN(dW, MIN(dE, dS));
    s.south := dS &lt;= vFuzz + MIN(dW, MIN(dE, dN));
    IF s.north THEN
      s.west := (dN &lt; C*vFuzz AND dW &lt; C*hFuzz);
      s.east := (dN &lt; C*vFuzz AND dE &lt; C*hFuzz);
    ELSIF s.south THEN
      s.west := (dS &lt; C*vFuzz AND dW &lt; C*hFuzz);
      s.east := (dS &lt; C*vFuzz AND dE &lt; C*hFuzz);
    END;
    IF s.north AND s.south THEN s.south := FALSE END;
    IF s.west AND s.east THEN s.east := FALSE END;
  END FindCloseSides;

PROCEDURE <A NAME="ChangeSides"><procedure>ChangeSides</procedure></A> (v: T; READONLY pt: Point.T) =
  VAR
    min, max: INTEGER;
    dom               := VBT.Domain(v.zChild);
  BEGIN
    WITH sides = v.sides,
         rect  = v.rect   DO
      (* aliases; both v.sides and v.rect can change! *)
      min := v.shape[Axis.T.Hor].lo;
      max := v.shape[Axis.T.Hor].hi - 1;
      IF sides.west THEN
        rect.east := dom.east;
        rect.west := pt.h;
        IF Rect.HorSize(rect) &gt; max THEN
          rect.west := rect.east - max;
        ELSIF Rect.HorSize(rect) &lt; min THEN
          sides.west := FALSE;
          rect.west := rect.east - min;
        END
      ELSIF sides.east THEN
        rect.west := dom.west;
        rect.east := pt.h;
        IF Rect.HorSize(rect) &gt; max THEN
          rect.east := rect.west + max;
        ELSIF Rect.HorSize(rect) &lt; min THEN
          sides.east := FALSE;
          rect.east := rect.west + min;
        END
      END;
      min := v.shape[Axis.T.Ver].lo;
      max := v.shape[Axis.T.Ver].hi - 1;
      IF sides.north THEN
        rect.south := dom.south;
        rect.north := pt.v;
        IF Rect.VerSize(rect) &gt; max THEN
          rect.north := rect.south - max;
        ELSIF Rect.VerSize(rect) &lt; min THEN
          sides.north := FALSE;
          rect.north := rect.south - min;
        END
      ELSIF sides.south THEN
        rect.north := dom.north;
        rect.south := pt.v;
        IF Rect.VerSize(rect) &gt; max THEN
          rect.south := rect.north + max;
        ELSIF Rect.VerSize(rect) &lt; min THEN
          sides.south := FALSE;
          rect.south := rect.north + min;
        END
      END
    END
  END ChangeSides;

PROCEDURE <A NAME="OrientCursor"><procedure>OrientCursor</procedure></A> (v: T; READONLY s: Sides) =
  VAR cursor: Cursor.T;
  BEGIN
    IF s.north AND s.east THEN
      cursor := MagnetNE
    ELSIF s.north AND s.west THEN
      cursor := MagnetNW
    ELSIF s.south AND s.west THEN
      cursor := MagnetSW
    ELSIF s.south AND s.east THEN
      cursor := MagnetSE
    ELSIF s.north THEN
      cursor := MagnetN
    ELSIF s.west THEN
      cursor := MagnetW
    ELSIF s.south THEN
      cursor := MagnetS
    ELSIF s.east THEN
      cursor := MagnetE
    ELSE
      cursor := MagnetNE;
    END;
    VBT.SetCursor(v, cursor)
  END OrientCursor;

VAR
  rsrcMu                 := NEW(MUTEX);
  rsrcInit               := FALSE;
  MagnetW, MagnetE, MagnetN, MagnetS:     Cursor.T;
  MagnetNW, MagnetNE, MagnetSW, MagnetSE: Cursor.T;

PROCEDURE <A NAME="GetResources"><procedure>GetResources</procedure></A> () =
  BEGIN
    LOCK rsrcMu DO
      IF rsrcInit THEN RETURN END;
      MagnetW := Cursor.FromName(ARRAY OF TEXT{&quot;XC_left_side&quot;});
      MagnetE := Cursor.FromName(ARRAY OF TEXT{&quot;XC_right_side&quot;});
      MagnetN := Cursor.FromName(ARRAY OF TEXT{&quot;XC_top_side&quot;});
      MagnetS :=
        Cursor.FromName(ARRAY OF TEXT{&quot;XC_bottom_side&quot;});
      MagnetNW :=
        Cursor.FromName(ARRAY OF TEXT{&quot;XC_top_left_corner&quot;});
      MagnetNE :=
        Cursor.FromName(ARRAY OF TEXT{&quot;XC_top_right_corner&quot;});
      MagnetSW :=
        Cursor.FromName(ARRAY OF TEXT{&quot;XC_bottom_left_corner&quot;});
      MagnetSE :=
        Cursor.FromName(ARRAY OF TEXT{&quot;XC_bottom_right_corner&quot;});
      rsrcInit := TRUE;
    END
  END GetResources;

BEGIN
END ZGrowVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
