<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ZMoveVBT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ZMoveVBT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
&lt;* PRAGMA LL *&gt;
</PRE> A <CODE>ZMoveVBT</CODE> is a switch that has the side-effect of
   repositioning its nearest ancestor subwindow.
<P>
   If the initial mouse click is unshifted, the subwindow is
   lifted to the top of its sibling; otherwise, the subwindow
   keeps its current top-to-bottom ordering among its siblings.
   As the mouse is moved, the cursor is changed to give
   appropriate feedback, and an outline of the subwindow is moved
   to show where it will be repositioned on an uncancelled
   upclick.  On an uncancelled upclick or chord-cancel, the
   outline is removed. 

<P><PRE>INTERFACE <interface><A HREF="ZMoveVBT.m3">ZMoveVBT</A></interface>;

IMPORT <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="SourceVBT.i3">SourceVBT</A>;

TYPE <A HREF="ZMoveVBT.m3#T">T</A> &lt;: SourceVBT.T;
</PRE> The following procedure is useful for subclasses, such as <CODE>ZGrowVBT</CODE>, 
   to control the shape of the outline of <CODE>v</CODE>'s subwindow as the 
   mouse is being dragged. 

<P><PRE>PROCEDURE <A HREF="ZMoveVBT.m3#MoveAndHighlight">MoveAndHighlight</A> (v: T; READONLY rect: Rect.T);
&lt;* LL = VBT.mu *&gt;
</PRE><BLOCKQUOTE><EM> Show the outline of <CODE>v</CODE> as <CODE>rect</CODE>.  Should only be called by the
   <CODE>during</CODE> method of a subclass. </EM></BLOCKQUOTE><PRE>
</PRE> The default <CODE>during</CODE> method calls <CODE>MoveAndHighlight</CODE> with
   <CODE>rect</CODE> equal to the domain of the subwindow being moved,
   translated by an appropriate amount to reflect the mouse
   movement since the initial mouse click.
<P>
   On an uncancelled upclick, the default <CODE>post</CODE> method moves the
   subwindow to the rectangle last specified to
   <CODE>MoveAndHighlight</CODE> and calls <CODE>ZChildVBT.Moved</CODE> and
   <CODE>ZChildVBT.Grew</CODE>.
<P>
   The highlighter used for displaying an outline of the
   subwindow contain <CODE>v</CODE> is the <CODE>HighlightVBT</CODE> returned by
   <CODE>SourceVBT.GetHighlighter(v)</CODE>.  An appropriate paint op is
   constructed by examing the colors of the background child of
   the subwindow's parent.  Those colors are found using the
   <CODE>VBTColors</CODE> interface; be sure to use that interface to 
   record the background child's primary foreground and background
   colors. 

<P><PRE>END ZMoveVBT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
