<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ZMoveVBT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ZMoveVBT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ZMoveVBT.i3">ZMoveVBT</A></implements></module>;

IMPORT <A HREF="../../geometry/src/Axis.i3">Axis</A>, <A HREF="../../ui/src/split/BtnVBTClass.i3">BtnVBTClass</A>, <A HREF="../../ui/src/split/HighlightVBT.i3">HighlightVBT</A>, <A HREF="../../ui/src/vbt/PaintOp.i3">PaintOp</A>, <A HREF="../../ui/src/vbt/Pixmap.i3">Pixmap</A>, <A HREF="../../geometry/src/Point.i3">Point</A>,
       <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="SourceVBT.i3">SourceVBT</A>, <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="../../vbtkitutils/src/VBTColors.i3">VBTColors</A>, <A HREF="ZChildVBT.i3">ZChildVBT</A>,
       <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>, <A HREF="ZSplitUtils.i3">ZSplitUtils</A>;

REVEAL
  <A NAME="T">T</A> = SourceVBT.T BRANDED OBJECT
        pt     : Point.T;
        op     : PaintOp.T;
        hl     : HighlightVBT.T;
        zChild : VBT.T;
        shifted: BOOLEAN;
        rect   : Rect.T;
      OVERRIDES
        pre    := Pre;
        during := During;
        post   := Post;
        cancel := Cancel;
        mouse  := Mouse;
      END;

PROCEDURE <A NAME="Pre"><procedure>Pre</procedure></A> (v: T) =
  &lt;* FATAL Split.NotAChild *&gt;
  BEGIN
    v.zChild := ZSplitUtils.FindZChild(v);
    IF v.zChild = NIL THEN v.ready := FALSE; RETURN END;
    SourceVBT.T.pre(v);
    v.hl := SourceVBT.GetHighlighter(v);
    v.rect := VBT.Domain(v.zChild);
    WITH bg = Split.Pred(VBT.Parent(v.zChild), NIL) DO
      v.op := VBTColors.Get(bg).transparentSwap
    END;
    IF NOT v.shifted THEN ZSplit.Lift(v.zChild, ZSplit.Altitude.Top) END;
  END Pre;

PROCEDURE <A NAME="Post"><procedure>Post</procedure></A> (v: T) =
  BEGIN
    HighlightVBT.SetRect(v.hl, Rect.Empty);
    ZChildVBT.Grew(
      v.zChild, Rect.HorSize(v.rect), Rect.VerSize(v.rect));
    ZSplit.Move(v.zChild, v.rect);
    ZChildVBT.Moved(v.zChild);
    SourceVBT.T.post(v);
  END Post;

PROCEDURE <A NAME="Cancel"><procedure>Cancel</procedure></A> (v: T) =
  BEGIN
    HighlightVBT.SetRect(v.hl, Rect.Empty);
    SourceVBT.T.cancel(v);
  END Cancel;

PROCEDURE <A NAME="During"><procedure>During</procedure></A> (v: T; READONLY cd: VBT.PositionRec) =
  BEGIN
    IF NOT Rect.Member(
             cd.cp.pt, VBT.Domain(VBT.Parent(v.zChild))) THEN
      RETURN
    END;
    WITH newRect = Rect.Move(v.rect, Point.Sub(cd.cp.pt, v.pt)) DO
      IF IsVisible(v, newRect) THEN
        v.rect := newRect;
        v.pt := cd.cp.pt
      END;
      MoveAndHighlight(v, v.rect)
    END
  END During;

PROCEDURE <A NAME="MoveAndHighlight"><procedure>MoveAndHighlight</procedure></A> (v: T; READONLY rect: Rect.T) =
  BEGIN
    v.rect := rect;
    HighlightVBT.SetTexture(v.hl, Pixmap.Gray, Point.Origin, v.op);
    HighlightVBT.SetRect(v.hl, v.rect, OutlineThickness(v));
  END MoveAndHighlight;

PROCEDURE <A NAME="Mouse"><procedure>Mouse</procedure></A> (v: T; READONLY cd: VBT.MouseRec) =
  BEGIN
    IF cd.clickType = VBT.ClickType.FirstDown THEN
      v.pt := cd.cp.pt;
      v.shifted := VBT.Modifier.Shift IN cd.modifiers
    END;
    SourceVBT.T.mouse(v, cd);
  END Mouse;

PROCEDURE <A NAME="IsVisible"><procedure>IsVisible</procedure></A> (v: T; newFrameDom: Rect.T): BOOLEAN =
  CONST
    MinSize = 4.0;
  VAR
    offset := Point.Sub(Rect.NorthWest(VBT.Domain(v.zChild)),
                        Rect.NorthWest(newFrameDom));
    newDraggerDom := Rect.Sub(VBT.Domain(v), offset);
    draggerShowing := Rect.Meet(
                        newDraggerDom, VBT.Domain(VBT.Parent(v.zChild)));
  BEGIN
    RETURN (FLOAT(Rect.HorSize(draggerShowing))
              &gt;= VBT.MMToPixels(v, MinSize, Axis.T.Hor))
             AND (FLOAT(Rect.VerSize(draggerShowing))
                    &gt;= VBT.MMToPixels(v, MinSize, Axis.T.Ver));
  END IsVisible;

PROCEDURE <A NAME="OutlineThickness"><procedure>OutlineThickness</procedure></A> (v: T): INTEGER =
  CONST Thickness = 0.75;
  BEGIN
    RETURN ROUND(MAX(VBT.MMToPixels(v, Thickness, Axis.T.Hor),
                     VBT.MMToPixels(v, Thickness, Axis.T.Ver)))
  END OutlineThickness;

BEGIN
END ZMoveVBT.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
