<HTML>
<HEAD>
<TITLE>SRC Modula-3: lego/src/ZTilps.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>lego/src/ZTilps.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ZTilps.i3">ZTilps</A></implements></module>;

IMPORT <A HREF="MultiClass.i3">MultiClass</A>, <A HREF="../../geometry/src/Rect.i3">Rect</A>, <A HREF="../../ui/src/split/Split.i3">Split</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>, <A HREF="ZChildVBT.i3">ZChildVBT</A>, <A HREF="../../ui/src/split/ZSplit.i3">ZSplit</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
           OVERRIDES
             init := Init;
           END;

TYPE
  MC = MultiClass.Split BRANDED OBJECT
       OVERRIDES
         insert  := Insert;
         replace := Replace;
         succ    := Succ;
         pred    := Pred;
       END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (v         : T;
                saveBits        := FALSE;
                parlim          := -1): T =
  BEGIN
    EVAL ZSplit.T.init (v, NIL, saveBits, parlim);
    MultiClass.Be (v, NEW(MC));
    RETURN v
  END Init;

PROCEDURE <A NAME="Insert"><procedure>Insert</procedure></A> (m: MC; pred, ch: VBT.T) =
  &lt;* FATAL Split.NotAChild *&gt;
  BEGIN
    IF pred = NIL THEN
      ZSplit.InsertAt (
        m.vbt, ch, Rect.NorthWest (VBT.Domain (m.vbt)),
        ZSplit.Altitude.Bot);
      ZSplit.SetReshapeControl (ch, ZSplit.Background)
    ELSE
      ZSplit.InsertAfter (
        m.vbt, Split.Pred (m.vbt, pred), ch, Rect.Empty,
        ZChildVBT.InitiallyMapped (ch));
      ZChildVBT.Inserted (ch)
    END
  END Insert;

PROCEDURE <A NAME="Replace"><procedure>Replace</procedure></A> (m: MC; ch, new: VBT.T) =
  &lt;* FATAL Split.NotAChild *&gt;
  BEGIN
    Split.Replace (m.vbt, ch, new)
  END Replace;

PROCEDURE <A NAME="Succ"><procedure>Succ</procedure></A> (m: MC; ch: VBT.T): VBT.T =
  &lt;* FATAL Split.NotAChild *&gt;
  BEGIN
    RETURN Split.Pred (m.vbt, ch)
  END Succ;

PROCEDURE <A NAME="Pred"><procedure>Pred</procedure></A> (m: MC; ch: VBT.T): VBT.T =
  &lt;* FATAL Split.NotAChild *&gt;
  BEGIN
    RETURN Split.Succ (m.vbt, ch)
  END Pred;

BEGIN
END ZTilps.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
