<HTML>
<HEAD>
<TITLE>SRC Modula-3: list/src/List.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>list/src/List.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                           </EM></BLOCKQUOTE><PRE>
</PRE> The generic interface <CODE>List</CODE> provides operations on linked lists of
   arbitrary element types. 

<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="List.mg">List</A></genericInterface>(Elem);
</PRE><BLOCKQUOTE><EM> Where <CODE>Elem.T</CODE> is not an open array type and <CODE>Elem</CODE> contains
<P>
<PRE>
      CONST Brand = &lt;text-constant&gt;;
      PROCEDURE Equal(k1, k2: Elem.T): BOOLEAN;
</PRE>
   <CODE>Brand</CODE> must be a text constant. It will be used to construct a brand for
   any generic types instantiated with the <CODE>List</CODE> interface. For a non-generic
   interface, we recommend choosing the name of the interface.
<P>
   <CODE>Equal</CODE> may be declared with a parameter mode of either <CODE>VALUE</CODE> or
   <CODE>READONLY</CODE>, but not <CODE>VAR</CODE>.
<P>
 </EM></BLOCKQUOTE><PRE>

CONST Brand = &quot;(List &quot; &amp; Elem.Brand &amp; &quot;)&quot;;

TYPE T = OBJECT head: Elem.T; tail: T END;
</PRE> A <CODE>List.T</CODE> represents a linked list of items of type <CODE>Elem.T</CODE>. 

<P> None of the operations of this interface modify the <CODE>head</CODE> field of
   an existing list element.  Operations that may modify the <CODE>tail</CODE>
   field of existing list elements are called {\it destructive}.  By
   convention, their names end in <CODE>D</CODE>.
   \index{naming conventions!destructive list operations}


<P><PRE>PROCEDURE <A HREF="List.mg#Cons">Cons</A>(READONLY head: Elem.T; tail: T): T;
</PRE><BLOCKQUOTE><EM> Equivalent to <CODE>NEW(T, head := head, tail := tail)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="List.mg#List1">List1</A>(READONLY e1: Elem.T): T;
</PRE><BLOCKQUOTE><EM> Return a list containing the single element <CODE>e1</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="List.mg#List2">List2</A>(READONLY e1, e2: Elem.T): T;
</PRE><BLOCKQUOTE><EM> Return a list containing the element sequence <CODE>e1</CODE>, <CODE>e2</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="List.mg#List3">List3</A>(READONLY e1, e2, e3: Elem.T): T;
</PRE><BLOCKQUOTE><EM> Return a list containing the element sequence <CODE>e1</CODE>, <CODE>e2</CODE>, <CODE>e3</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="List.mg#FromArray">FromArray</A>(READONLY e: ARRAY OF Elem.T): T;
</PRE><BLOCKQUOTE><EM> Return a list containing the elements of <CODE>e</CODE> in order. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="List.mg#Length">Length</A>(l: T): CARDINAL;
</PRE><BLOCKQUOTE><EM> Return the number of elements of <CODE>l</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="List.mg#Nth">Nth</A>(l: T; n: CARDINAL): Elem.T;
</PRE><BLOCKQUOTE><EM> Return element <CODE>n</CODE> of list <CODE>l</CODE>.  Element 0 is <CODE>l.head</CODE>, element 1 
   is <CODE>l.tail.head</CODE>, etc.  Cause a checked runtime error if 
   <CODE>n &gt;= Length(l)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="List.mg#Member">Member</A>(l: T; READONLY e: Elem.T): BOOLEAN;
</PRE><BLOCKQUOTE><EM> Return <CODE>TRUE</CODE> if some element of <CODE>l</CODE> is equal to <CODE>e</CODE>, else return
   <CODE>FALSE</CODE>.  The comparison is performed by <CODE>Elem.Equal</CODE>.  </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="List.mg#Append">Append</A>(l1: T; l2: T): T;
PROCEDURE <A HREF="List.mg#AppendD">AppendD</A>(l1: T; l2: T): T;
</PRE><BLOCKQUOTE><EM> Append two lists together, returning the new list.  <CODE>Append</CODE>
   does this by making a copy of the cells of <CODE>l1</CODE>; <CODE>AppendD</CODE>
   modifies the <CODE>tail</CODE> field in the last cell of <CODE>l1</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="List.mg#Reverse">Reverse</A>(l: T): T;
PROCEDURE <A HREF="List.mg#ReverseD">ReverseD</A>(l: T): T;
</PRE><BLOCKQUOTE><EM> Return a list containing the elements of <CODE>l</CODE> in reverse order.
   <CODE>Reverse</CODE> copies the cells; <CODE>ReverseD</CODE> modifies the <CODE>tail</CODE> fields
   of the existing cells. </EM></BLOCKQUOTE><PRE>

END List.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
