<HTML>
<HEAD>
<TITLE>SRC Modula-3: list/src/ListSort.ig</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>list/src/ListSort.ig</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> The generic interface <CODE>ListSort</CODE> extends the generic interface
   <CODE>List</CODE> with sorting operations.
   \index{sorting!lists}
 

<P><PRE>GENERIC INTERFACE <genericInterface><A HREF="ListSort.mg">ListSort</A></genericInterface>(Elem, ElemList);
</PRE><BLOCKQUOTE><EM> Where <CODE>Elem.T</CODE> is not an open array type, <CODE>ElemList</CODE> equals <CODE>List(Elem)</CODE>,
   and <CODE>Elem</CODE> contains
<P>
<PRE>
      CONST Brand = &lt;text-constant&gt;;
      PROCEDURE Compare(e1, e2: Elem.T): [-1..1];
</PRE>
   <CODE>Brand</CODE> must be a text constant. It will be used to construct a brand for
   any generic types instantiated with the <CODE>ListSort</CODE> interface. For a
   non-generic interface, we recommend choosing the name of the interface.
<P>
   <CODE>Compare</CODE> must be a total order. It may be declared with any parameter
   mode, but must have no visible side-effects.
</EM></BLOCKQUOTE><PRE>

CONST Brand = &quot;(ListSort &quot; &amp; Elem.Brand &amp; &quot;)&quot;;

TYPE T = ElemList.T;

PROCEDURE <A HREF="ListSort.mg#Sort">Sort</A>(l: T; c := Elem.Compare): T;
PROCEDURE <A HREF="ListSort.mg#SortD">SortD</A>(l: T; c := Elem.Compare): T;
</PRE><BLOCKQUOTE><EM> Sort a list in ascending order using <CODE>c</CODE> to compare pairs of
   elements of <CODE>l</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> The implementation is time- and cons-efficient but not guaranteed
   to be stable.  <CODE>Sort</CODE> copies the cells; <CODE>SortD</CODE> modifies the <CODE>tail</CODE>
   fields of the existing cells.  

<P><PRE>END ListSort.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
