<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3back/src/Codex86.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3back/src/Codex86.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="Codex86.m3">Codex86</A></interface>;

IMPORT <A HREF="../../m3middle/src/M3CG.i3">M3CG</A>, <A HREF="../../m3objfile/src/M3ObjFile.i3">M3ObjFile</A>;

FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT MType, Label, ByteOffset, Alignment;
FROM <A HREF="../../m3middle/src/M3CG_Ops.i3">M3CG_Ops</A> IMPORT ErrorHandler;

IMPORT <A HREF="M3x86Rep.i3">M3x86Rep</A>, <A HREF="Wrx86.i3">Wrx86</A>;

FROM <A HREF="M3x86Rep.i3">M3x86Rep</A> IMPORT Operand, NRegs, MVar, x86Var, x86Proc, Regno;

TYPE <A HREF="Codex86.m3#T">T</A> &lt;: Public;
TYPE Public = OBJECT
        wr            : Wrx86.T := NIL;
        reg           : ARRAY [0 .. NRegs] OF Operand;
        ftop_inmem    := FALSE;
        internalvar   : x86Var;
      METHODS
        wrFlush ();
        set_obj (obj: M3ObjFile.T);
        set_current_proc (p: x86Proc);
        set_textsym(sym: INTEGER);
        intCall (lab: Label);
        relCall (rel: INTEGER);
        absCall (p: x86Proc);
        rmCall (READONLY op: Operand);
        cleanretOp (psize: INTEGER);
        brOp (br: Cond; l: Label);
        setccOp (READONLY op: Operand; cond: Cond);
        noargOp (op: Op);
        noargFOp (op: FOp);
        immFOp (op: FOp; im: FIm);
        binFOp (op: FOp; st: INTEGER);
        memFOp (op: FOp; mvar: MVar);
        assert_fstack (count: INTEGER);
        f_ensureloaded ();
        f_exitproc ();
        f_pushnew ();
        fstack_push (READONLY mvar: MVar; nomem := FALSE);
        fstack_pop (READONLY mvar: MVar);
        fstack_swap ();
        fstack_discard ();
        f_loadlit (READONLY flarr: ARRAY OF INTEGER; type: MType);
        immOp (op: Op; READONLY dest: Operand; imm: INTEGER);
        binOp (op: Op; READONLY dest, src: Operand);
        tableOp (op: Op; READONLY dest, index: Operand; scale: INTEGER;
                 table: MVar);
        swapOp (READONLY dest, src: Operand);
        movOp (READONLY dest, src: Operand);
        movDummyReloc (READONLY dest: Operand; sym: INTEGER);
        movImm (READONLY dest: Operand; imm: INTEGER);
        MOVSWOp ();
        STOSWOp ();
        pushOp (READONLY src: Operand);
        popOp (READONLY dest: Operand);
        decOp (READONLY op: Operand);
        unOp (op: Op; READONLY dest: Operand);
        mulOp (READONLY src: Operand);
        imulOp (READONLY dest, src: Operand);
        imulImm (READONLY dest, src: Operand; imm, imsize: INTEGER);
        divOp (READONLY divisor: Operand);
        idivOp (READONLY divisor: Operand);
        diffdivOp (READONLY divisor: Operand; apos: BOOLEAN);
        diffmodOp (READONLY divisor: Operand; apos: BOOLEAN);
        must_extend (READONLY operand: Operand): BOOLEAN;
        get_addsize (READONLY Op: Operand): INTEGER;
        aligned (READONLY var: MVar; align: Alignment): BOOLEAN;
        allocate_temp (var: x86Var; size, align: INTEGER);
        reserve_labels (n: INTEGER; short := FALSE): Label;
        set_label (l: Label; offset := 0);
        case_jump (index: Operand; READONLY l: ARRAY OF Label);
        load_ind (r: Regno; READONLY ind: Operand; o: ByteOffset;
                  type: MType);
        fast_load_ind (r: Regno; READONLY ind: Operand; o: ByteOffset;
                       size: INTEGER);
        store_ind (READONLY val, ind: Operand; o: ByteOffset; type: MType);
        f_loadind (READONLY ind: Operand; o: ByteOffset; type: MType);
        f_storeind (READONLY ind: Operand; o: ByteOffset; type: MType);
        log_label_init (var: x86Var; o: ByteOffset; lab: Label);
        get_frame (r: Regno; target, current: x86Proc);
        set_error_handler (err: ErrorHandler);
        init ();
        end ();
      END;

TYPE IntnlVar = { Lowset_table, Highset_table };

TYPE Cond = { Z, NZ, E, NE, G, GE, L, LE, A, AE, B, BE, Always };

CONST revcond = ARRAY Cond OF Cond
  { Cond.Z, Cond.NZ, Cond.E, Cond.NE, Cond.L, Cond.LE,
    Cond.G, Cond.GE, Cond.B, Cond.BE, Cond.A, Cond.AE, Cond.Always };

CONST unscond = ARRAY Cond OF Cond
  { Cond.Z, Cond.NZ, Cond.E, Cond.NE, Cond.A, Cond.AE,
    Cond.B, Cond.BE, Cond.A, Cond.AE, Cond.B, Cond.BE, Cond.Always };

TYPE
  BrOpCode = RECORD
    name: TEXT;
    rel8: INTEGER;
  END;

CONST bropcode = ARRAY Cond OF BrOpCode
  { BrOpCode { &quot;JE&quot;,  16_74 },
    BrOpCode { &quot;JNE&quot;, 16_75 },
    BrOpCode { &quot;JE&quot;,  16_74 },
    BrOpCode { &quot;JNE&quot;, 16_75 },
    BrOpCode { &quot;JG&quot;,  16_7F },
    BrOpCode { &quot;JGE&quot;, 16_7D },
    BrOpCode { &quot;JL&quot;,  16_7C },
    BrOpCode { &quot;JLE&quot;, 16_7E },
    BrOpCode { &quot;JA&quot;,  16_77 },
    BrOpCode { &quot;JAE&quot;, 16_73 },
    BrOpCode { &quot;JB&quot;,  16_72 },
    BrOpCode { &quot;JBE&quot;, 16_76 },
    BrOpCode { &quot;JMP&quot;, -1    } };

TYPE
  CondOpCode = RECORD
    name: TEXT;
    opc: INTEGER;
  END;

CONST condopcode = ARRAY Cond OF CondOpCode
  { CondOpCode { &quot;SETE&quot;,  16_94 },
    CondOpCode { &quot;SETNE&quot;, 16_95 },
    CondOpCode { &quot;SETE&quot;,  16_94 },
    CondOpCode { &quot;SETNE&quot;, 16_95 },
    CondOpCode { &quot;SETG&quot;,  16_9F },
    CondOpCode { &quot;SETGE&quot;, 16_9D },
    CondOpCode { &quot;SETL&quot;,  16_9C },
    CondOpCode { &quot;SETLE&quot;, 16_9E },
    CondOpCode { &quot;SETA&quot;,  16_97 },
    CondOpCode { &quot;SETAE&quot;, 16_93 },
    CondOpCode { &quot;SETB&quot;,  16_92 },
    CondOpCode { &quot;SETBE&quot;, 16_96 },
    CondOpCode { &quot;&quot;,      -1    } };

TYPE
  FOpCode = RECORD
    name: TEXT;
    m32, m64, memop, stbase, stmodrm,
    stackdiff, memdiff, stackin, min: INTEGER;
    takesmem: BOOLEAN;
  END;

TYPE FOp = { fCOM, fCOMP, fCOMPP, fDECSTP, fINCSTP, fFREE,
             fNCLEX, fABS,
             fCHS, fNSTSWAX, fILD, fISTP, fLDCW, fSTCW,
             fLD, fSTP, fADDP, fSUBP, fSUBPR, fMUL, fDIV,
             fNOP };

CONST fopcode = ARRAY FOp OF FOpCode
  { FOpCode { &quot;FCOM&quot;,    -1,    -1,    0, 16_D8, 16_D0, 0,  0,  2, 0, FALSE },
    FOpCode { &quot;FCOM&quot;,    16_D8, 16_DC, 3, 16_D8, 16_D8, -2, -1, 2, 1, TRUE  },
    FOpCode { &quot;FCOMP&quot;,   -1,    -1,    0, 16_DE, 16_D8, -2, 0,  2, 0, FALSE },
    FOpCode { &quot;FDECSTP&quot;, -1,    -1,    0, 16_D9, 16_F6, 0,  0,  0, 0, FALSE },
    FOpCode { &quot;FINCSTP&quot;, -1,    -1,    0, 16_D9, 16_F7, 0,  0,  0, 0, FALSE },
    FOpCode { &quot;FFREE&quot;,   -1,    -1,    0, 16_DD, 16_C0, 0,  0,  0, 0, FALSE },
    FOpCode { &quot;FNCLEX&quot;,  -1,    -1,    0, 16_DB, 16_E2, 0,  0,  0, 0, FALSE },
    FOpCode { &quot;FABS&quot;,    -1,    -1,    0, 16_D9, 16_E1, 0,  0,  1, 0, FALSE },
    FOpCode { &quot;FCHS&quot;,    -1,    -1,    0, 16_D9, 16_E0, 0,  0,  1, 0, FALSE },
    FOpCode { &quot;FNSTSWAX&quot;,-1,    -1,    0, 16_DF, 16_E0, 0,  0,  0, 0, FALSE },
    FOpCode { &quot;FILD&quot;,    16_DB, -1,    0, -1,    -1,    1,  1,  0, 0, FALSE },
    FOpCode { &quot;FIST&quot;,    16_DB, -1,    3, -1,    -1,    -1, -1, 1, 1, FALSE },
    FOpCode { &quot;FLDCW&quot;,   16_D9, -1,    5, -1,    -1,    0,  0,  0, 0, FALSE },
    FOpCode { &quot;FSTCW&quot;,   16_D9, -1,    7, -1,    -1,    0,  0,  0, 0, FALSE },
    FOpCode { &quot;FLD&quot;,     16_D9, 16_DD, 0, 16_D9, 16_C0, 1,  1,  0, 0, TRUE  },
    FOpCode { &quot;FST&quot;,     16_D9, 16_DD, 3, 16_DD, 16_D8, -1, -1, 2, 1, TRUE  },
    FOpCode { &quot;FADD&quot;,    16_D8, 16_DC, 0, 16_DE, 16_C0, -1, 0,  2, 1, TRUE  },
    FOpCode { &quot;FSUB&quot;,    16_D8, 16_DC, 4, 16_DE, 16_E8, -1, 0,  2, 1, TRUE  },
    FOpCode { &quot;FSUBR&quot;,   16_D8, 16_DC, 5, 16_DE, 16_E0, -1, 0,  2, 1, TRUE  },
    FOpCode { &quot;FMUL&quot;,    16_D8, 16_DC, 1, 16_DE, 16_C8, -1, 0,  2, 1, TRUE  },
    FOpCode { &quot;FDIV&quot;,    16_D8, 16_DC, 6, 16_DE, 16_F8, -1, 0,  2, 1, TRUE  },
    FOpCode { &quot;FNOP&quot;,    -1,    -1,    0, -1,    -1,    0,  0,  0, 0, FALSE }};

TYPE
  FImOp = RECORD
    name: TEXT;
    opcode: INTEGER;
  END;

TYPE FIm = { ONE, L2T, L2E, PI, LG2, LN2, Z };

CONST imcode = ARRAY FIm OF FImOp
  { FImOp { &quot;FLD1&quot;,   16_D9E8 },
    FImOp { &quot;FLDL2T&quot;, 16_D9E9 },
    FImOp { &quot;FLDL2E&quot;, 16_D9EA },
    FImOp { &quot;FLDPI&quot;,  16_D9EB },
    FImOp { &quot;FLDLG2&quot;, 16_D9EC },
    FImOp { &quot;FLDLN2&quot;, 16_D9ED },
    FImOp { &quot;FLDZ&quot;,   16_D9EE } };

TYPE
  OpCode = RECORD
    name: TEXT;
    Aimm32, imm8, imm32, immop, rmr, rrm: INTEGER;
  END;

TYPE Op = { oAND, oXOR, oOR, oMOV,
            oADD, oSUB, oCMP, oNEG, oNOT, oLEA,
            oSAL, oSAR, oSHR, oROL, oROR, oSAHF, oWAIT, oCLD, oSTD,
            oREP, oMOVSB, oMOVSD, oSTOSB, oSTOSD,
            oCWDE, oCDQ, oLEAVE, oRET, oNOP };

CONST opcode = ARRAY Op OF OpCode
  { OpCode { &quot;AND&quot;,  16_25, 16_83, 16_81, 4, 16_20, 16_22 },
    OpCode { &quot;XOR&quot;,  16_35, 16_83, 16_81, 6, 16_30, 16_32 },
    OpCode { &quot;OR&quot;,   16_0D, 16_83, 16_81, 1, 16_08, 16_0A },
    OpCode { &quot;MOV&quot;,  -1,    -1,    -1,    0, 16_88, 16_8A },
    OpCode { &quot;ADD&quot;,  16_05, 16_83, 16_81, 0, 16_00, 16_02 },
    OpCode { &quot;SUB&quot;,  16_2D, 16_83, 16_81, 5, 16_28, 16_2A },
    OpCode { &quot;CMP&quot;,  16_3D, 16_83, 16_81, 7, 16_38, 16_3A },
    OpCode { &quot;NEG&quot;,  -1,    -1,    16_F6, 3, -1,    -1    },
    OpCode { &quot;NOT&quot;,  -1,    -1,    16_F6, 2, -1,    -1    },
    OpCode { &quot;LEA&quot;,  -1,    -1,    -1,    0, -1,    16_8C },
    OpCode { &quot;SAL&quot;,  -1,    16_C1, 16_D2, 4, -1,    -1    },
    OpCode { &quot;SAR&quot;,  -1,    16_C1, 16_D2, 7, -1,    -1    },
    OpCode { &quot;SHR&quot;,  -1,    16_C1, 16_D2, 5, -1,    -1    },
    OpCode { &quot;ROL&quot;,  -1,    16_C1, 16_D2, 0, -1,    -1    },
    OpCode { &quot;ROR&quot;,  -1,    16_C1, 16_D2, 1, -1,    -1    },
    OpCode { &quot;SAHF&quot;, -1,    -1,    16_9E, 0, -1,    -1    },
    OpCode { &quot;WAIT&quot;, -1,    -1,    16_9B, 0, -1,    -1    },
    OpCode { &quot;CLD&quot;,  -1,    -1,    16_FC, 0, -1,    -1    },
    OpCode { &quot;STD&quot;,  -1,    -1,    16_FD, 0, -1,    -1    },
    OpCode { &quot;REP&quot;,  -1,    -1,    16_F3, 0, -1,    -1    },
    OpCode { &quot;MOVSB&quot;,-1,    -1,    16_A4, 0, -1,    -1    },
    OpCode { &quot;MOVSD&quot;,-1,    -1,    16_A5, 0, -1,    -1    },
    OpCode { &quot;STOSB&quot;,-1,    -1,    16_AA, 0, -1,    -1    },
    OpCode { &quot;STOSD&quot;,-1,    -1,    16_AB, 0, -1,    -1    },
    OpCode { &quot;CWDE&quot;, -1,    -1,    16_98, 0, -1,    -1    },
    OpCode { &quot;CDQ&quot;,  -1,    -1,    16_99, 0, -1,    -1    },
    OpCode { &quot;LEAVE&quot;,-1,    -1,    16_C9, 0, -1,    -1    },
    OpCode { &quot;RET&quot;  ,-1,    -1,    16_C3, 0, -1,    -1    },
    OpCode { &quot;NOP&quot;,  -1,    -1,    -1,    0, -1,    -1    } };

CONST EAX = 0;
      ECX = 1;
      EDX = 2;
      EBX = 3;
      ESP = 4;
      EBP = 5;
      ESI = 6;
      EDI = 7;

PROCEDURE <A HREF="Codex86.m3#New">New</A> (parent: M3x86Rep.U; wr: Wrx86.T): T;

END Codex86.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
