<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3back/src/M3x86.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3back/src/M3x86.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module>M3x86</module> EXPORTS <A HREF="M3x86.i3"><implements>M3x86</A></implements>, <A HREF="M3x86Rep.i3"><implements>M3x86Rep</A></implements>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="../../word/src/Word.i3">Word</A>, <A HREF="../../convert/src/Convert.i3">Convert</A>;
IMPORT <A HREF="../../m3middle/src/M3CG.i3">M3CG</A>, <A HREF="#x1">M3ID</A>, <A HREF="../../m3middle/src/M3CG_Ops.i3">M3CG_Ops</A>, <A HREF="../../m3middle/src/Target.i3">Target</A>, <A HREF="../../m3middle/src/TInt.i3">TInt</A> AS TargetInt, <A HREF="../../m3middle/src/TFloat.i3">TFloat</A> AS TargetFloat;
IMPORT <A HREF="../../m3objfile/src/M3ObjFile.i3">M3ObjFile</A>, <A HREF="../../m3middle/src/TargetMap.i3">TargetMap</A>;

FROM <A HREF="../../m3middle/src/TargetMap.i3">TargetMap</A> IMPORT CG_Bytes;

FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Name, ByteOffset, TypeUID, CallingConvention;
FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT BitSize, ByteSize, Alignment, Frequency;
FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Var, Proc, Label, Sign, BitOffset;
FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Type, ZType, AType, RType, IType, MType;

FROM <A HREF="../../m3middle/src/M3CG_Ops.i3">M3CG_Ops</A> IMPORT ErrorHandler;

FROM <A HREF="../../m3objfile/src/M3ObjFile.i3">M3ObjFile</A> IMPORT Seg;

IMPORT <A HREF="Wrx86.i3">Wrx86</A>, <A HREF="Stackx86.i3">Stackx86</A>, <A HREF="Codex86.i3">Codex86</A>;

FROM <A HREF="Stackx86.i3">Stackx86</A> IMPORT MaxMin;
FROM <A HREF="Codex86.i3">Codex86</A> IMPORT Cond, Op, FOp, FIm, unscond, revcond;

TYPE
  RuntimeHook = REF RECORD  name: Name;  var: Var;  offset: ByteOffset;  END;

REVEAL
  <A NAME="U">U</A> = Public BRANDED &quot;M3x86.U&quot; OBJECT
        rawwr           : Wr.T := NIL;
        wr              : Wrx86.T := NIL;
        cg              : Codex86.T := NIL;
        vstack          : Stackx86.T := NIL;
        obj             : M3ObjFile.T := NIL;
        debug           := FALSE;
        Err             : ErrorHandler := NIL;
        runtime         : IntRefTbl.T := NIL;  (* Name -&gt; RuntimeHook *)
        textsym         : INTEGER;
        init_varstore   : x86Var := NIL;
        init_count      : INTEGER;
        call_param_size := ARRAY [0 .. 1] OF INTEGER { 0, 0 };
        in_proc_call    := 0;
        static_link     := ARRAY [0 .. 1] OF x86Var { NIL, NIL };
        current_proc    : x86Proc := NIL;
        param_proc      : x86Proc := NIL;
        in_proc         : BOOLEAN;
        procframe_ptr   : ByteOffset;
        exit_proclabel  : Label := -1;
        last_exitbranch := -1;
        n_params        : INTEGER;
        next_var        := 1;
        next_proc       := 1;
        next_scope      := 1;
        set_procs       : ARRAY SetProc OF IntProc;
        memmoveproc     : IntProc;
        memcpyproc      : IntProc;
        memsetproc      : IntProc;
        global_var      : x86Var := NIL;
        rfault_name     : Name;
        lineno          : INTEGER;
        source_file     : TEXT := NIL;
        reportlabel     : Label;
        usedfault       := FALSE;
      OVERRIDES
        NewVar := NewVar;
        next_label := next_label;
        set_error_handler := set_error_handler;
        begin_unit := begin_unit;
        end_unit   := end_unit;
        import_unit := import_unit;
        export_unit := export_unit;
        set_source_file := set_source_file;
        set_source_line := set_source_line;
        declare_typename := declare_typename;
        declare_array := declare_array;
        declare_open_array := declare_open_array;
        declare_enum := declare_enum;
        declare_enum_elt := declare_enum_elt;
        declare_packed  := declare_packed;
        declare_record := declare_record;
        declare_field := declare_field;
        declare_set := declare_set;
        declare_subrange := declare_subrange;
        declare_pointer := declare_pointer;
        declare_indirect := declare_indirect;
        declare_proctype := declare_proctype;
        declare_formal := declare_formal;
        declare_raises := declare_raises;
        declare_object := declare_object;
        declare_method := declare_method;
        declare_opaque := declare_opaque;
        reveal_opaque := reveal_opaque;
        set_runtime_hook := set_runtime_hook;
        get_runtime_hook := get_runtime_hook;
        import_global  := import_global;
        declare_segment := declare_segment;
        bind_segment := bind_segment;
        declare_global := declare_global;
        declare_constant := declare_constant;
        declare_local  := declare_local;
        declare_param  := declare_param;
        declare_temp   := declare_temp;
        free_temp := free_temp;
        declare_exception := declare_exception;
        begin_init := begin_init;
        end_init := end_init;
        init_int := init_int;
        init_proc := init_proc;
        init_label := init_label;
        init_var := init_var;
        init_offset := init_offset;
        init_chars := init_chars;
        init_float := init_float;
        import_procedure := import_procedure;
        declare_procedure := declare_procedure;
        begin_procedure := begin_procedure;
        end_procedure := end_procedure;
        begin_block := begin_block;
        end_block := end_block;
        note_procedure_origin := note_procedure_origin;
        set_label := set_label;
        jump := jump;
        if_true  := if_true;
        if_false := if_false;
        if_eq := if_eq;
        if_ne := if_ne;
        if_gt := if_gt;
        if_ge := if_ge;
        if_lt := if_lt;
        if_le := if_le;
        case_jump := case_jump;
        exit_proc := exit_proc;
        load  := load;
        store := store;
        store_ref := store_ref;
        load_address := load_address;
        load_indirect := load_indirect;
        store_indirect := store_indirect;
        store_ref_indirect := store_ref_indirect;
        load_nil      := load_nil;
        load_integer  := load_integer;
        load_float    := load_float;
        eq       := eq;
        ne       := ne;
        gt       := gt;
        ge       := ge;
        lt       := lt;
        le       := le;
        add      := add;
        subtract := subtract;
        multiply := multiply;
        divide   := divide;
        div      := div;
        mod      := mod;
        negate   := negate;
        abs      := abs;
        max      := max;
        min      := min;
        round    := round;
        trunc    := trunc;
        floor    := floor;
        ceiling  := ceiling;
        cvt_float := cvt_float;
        set_union          := set_union;
        set_difference     := set_difference;
        set_intersection   := set_intersection;
        set_sym_difference := set_sym_difference;
        set_member         := set_member;
        set_eq       := set_eq;
        set_ne       := set_ne;
        set_gt       := set_gt;
        set_ge       := set_ge;
        set_lt       := set_lt;
        set_le       := set_le;
        set_range    := set_range;
        set_singleton := set_singleton;
        not := not;
        and := and;
        or  := or;
        xor := xor;
        shift        := shift;
        shift_left   := shift_left;
        shift_right  := shift_right;
        rotate       := rotate;
        rotate_left  := rotate_left;
        rotate_right := rotate_right;
        extract := extract;
        extract_n := extract_n;
        extract_mn := extract_mn;
        insert  := insert;
        insert_n  := insert_n;
        insert_mn  := insert_mn;
        swap := swap;
        pop  := pop;
        copy := copy;
        copy_n := copy_n;
        zero := zero;
        zero_n := zero_n;
        loophole := loophole;
        assert_fault := assert_fault;
        narrow_fault := narrow_fault;
        return_fault := return_fault;
        case_fault := case_fault;
        typecase_fault := typecase_fault;
        check_nil := check_nil;
        check_lo := check_lo;
        check_hi := check_hi;
        check_range := check_range;
        check_index := check_index;
        check_eq := check_eq;
        add_offset := add_offset;
        index_address := index_address;
        start_call_direct := start_call_direct;
        call_direct := call_direct;
        start_call_indirect := start_call_indirect;
        call_indirect := call_indirect;
        pop_param := pop_param;
        pop_struct := pop_struct;
        pop_static_link := pop_static_link;
        load_procedure := load_procedure;
        load_static_link := load_static_link;
        comment := comment;
        END;
</PRE>---------------------------------------------------------------------------

<P><PRE>CONST Alignmask = ARRAY [1 .. 4] OF INTEGER
  { 16_FFFFFFFF, 16_FFFFFFFE, 0, 16_FFFFFFFC };
</PRE>---------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A> (logfile: Wr.T; obj: M3ObjFile.T): M3CG.T =
  VAR u := NEW (U,
                obj := obj,
                runtime := NEW (IntRefTbl.Default).init (20));
  BEGIN
    IF logfile # NIL THEN
      u.debug := TRUE;
      u.wr := Wrx86.New (logfile);
    ELSE
      u.wr := NIL;
    END;

    u.cg := Codex86.New(u, u.wr);
    u.vstack := Stackx86.New(u, u.cg, u.debug);

    u.set_procs := ARRAY SetProc OF IntProc {
      IntProc { FALSE, NIL, &quot;set_union&quot;, 4, Type.Void, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_difference&quot;, 4, Type.Void, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_intersection&quot;, 4, Type.Void, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_sym_difference&quot;, 4, Type.Void, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_range&quot;, 3, Type.Void, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_eq&quot;, 3, Type.Int, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_ne&quot;, 3, Type.Int, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_lt&quot;, 3, Type.Int, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_le&quot;, 3, Type.Int, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_gt&quot;, 3, Type.Int, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_ge&quot;, 3, Type.Int, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_member&quot;, 2, Type.Int, &quot;C&quot; },
      IntProc { FALSE, NIL, &quot;set_singleton&quot;, 2, Type.Void, &quot;C&quot; } };

    u.memmoveproc := IntProc { FALSE, NIL, &quot;memmove&quot;, 3, Type.Addr, &quot;C&quot; };
    u.memcpyproc := IntProc { FALSE, NIL, &quot;memcpy&quot;, 3, Type.Addr, &quot;C&quot; };
    u.memsetproc := IntProc { FALSE, NIL, &quot;memset&quot;, 3, Type.Addr, &quot;C&quot; };

    RETURN u;
  END New;
</PRE>----------------------------------------------------------- ID counters ---

<P><PRE>PROCEDURE <A NAME="next_label"><procedure>next_label</procedure></A> (u: U;  n: INTEGER := 1): Label =
  BEGIN
    RETURN u.cg.reserve_labels(n);
  END next_label;
</PRE>------------------------------------------------ READONLY configuration ---

<P><PRE>PROCEDURE <A NAME="set_error_handler"><procedure>set_error_handler</procedure></A> (u: U; p: ErrorHandler) =
  BEGIN
    u.Err := p;
    u.cg.set_error_handler(p);
    u.vstack.set_error_handler(p);
  END set_error_handler;
</PRE>----------------------------------------------------- compilation units ---

<P><PRE>PROCEDURE <A NAME="begin_unit"><procedure>begin_unit</procedure></A> (u: U;  optimize : INTEGER) =
  (* called before any other method to initialize the compilation unit *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd (&quot;begin_unit&quot;);
      u.wr.Int (optimize);
      u.wr.NL  ();
    END;

    u.cg.set_obj(u.obj);

    u.cg.init();
    u.vstack.init();

    u.next_var := 1;
    u.next_proc := 1;
    u.next_scope := 1;
    u.global_var := NIL;

    u.in_proc_call := 0;

    u.reportlabel := u.cg.reserve_labels(1);
    u.usedfault := FALSE;

    FOR i := FIRST(SetProc) TO LAST(SetProc) DO
      u.set_procs[i].used := FALSE;
    END;

    u.memmoveproc.used := FALSE;
    u.memcpyproc.used := FALSE;
    u.memsetproc.used := FALSE;

    u.rfault_name := 0;

    u.textsym := u.obj.define_symbol(M3ID.Add(&quot;TextSegment&quot;), Seg.Text, 0);
    u.cg.set_textsym(u.textsym);
  END begin_unit;

PROCEDURE <A NAME="end_unit"><procedure>end_unit</procedure></A>   (u: U) =
  (* called after all other methods to finalize the unit and write the
     resulting object *)
  BEGIN
    IF u.usedfault THEN
      makereportproc(u);
    END;

    IF u.debug THEN
      u.wr.Cmd (&quot;end_unit&quot;);
      u.wr.NL  ();
      u.wr.Flush ();
    END;

    u.vstack.end();
    u.cg.end();
  END end_unit;

PROCEDURE <A NAME="import_unit"><procedure>import_unit</procedure></A> (u: U;  n: Name) =
  (* note that the current compilation unit imports the interface 'n' *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;import_unit&quot;);
      u.wr.ZName (n);
      u.wr.NL    ();
    END
  END import_unit;

PROCEDURE <A NAME="export_unit"><procedure>export_unit</procedure></A> (u: U;  n: Name) =
  (* note that the current compilation unit exports the interface 'n' *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;export_unit&quot;);
      u.wr.ZName (n);
      u.wr.NL    ();
    END
  END export_unit;
</PRE>------------------------------------------------ debugging line numbers ---

<P><PRE>PROCEDURE <A NAME="set_source_file"><procedure>set_source_file</procedure></A> (u: U; file: TEXT) =
  (* Sets the current source file name.  Subsequent statements
     and expressions are associated with this source location. *)
  BEGIN
    IF u.debug THEN
      u.wr.OutT (&quot;\t\t\t\t\t-----FILE &quot;);
      u.wr.OutT (file);
      u.wr.OutT (&quot;  -----&quot;);
      u.wr.NL ();
    END;

    u.source_file := file;
    u.obj.set_source_file(file);
  END set_source_file;

PROCEDURE <A NAME="set_source_line"><procedure>set_source_line</procedure></A> (u: U; line: INTEGER) =
  (* Sets the current source line number.  Subsequent statements
   and expressions are associated with this source location. *)
  BEGIN
    IF u.debug THEN
      u.wr.OutT (&quot;\t\t\t\t\t-----LINE&quot;);
      u.wr.Int  (line);
      u.wr.OutT (&quot;  -----&quot;);
      u.wr.NL ();
    END;

    u.lineno := line;

    u.obj.set_source_line(line);
  END set_source_line;
</PRE>------------------------------------------- debugging type declarations ---

<P><PRE>PROCEDURE <A NAME="declare_typename"><procedure>declare_typename</procedure></A> (u: U;  t: TypeUID;  n: Name) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_typename&quot;);
      u.wr.Tipe  (t);
      u.wr.ZName (n);
      u.wr.NL    ();
    END
  END declare_typename;

PROCEDURE <A NAME="declare_array"><procedure>declare_array</procedure></A> (u: U;  t, index, elt: TypeUID;  s: BitSize) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_array&quot;);
      u.wr.Tipe (t);
      u.wr.Tipe (index);
      u.wr.Tipe (elt);
      u.wr.BInt (s);
      u.wr.NL   ();
    END
  END declare_array;

PROCEDURE <A NAME="declare_open_array"><procedure>declare_open_array</procedure></A> (u: U;  t, elt: TypeUID;  s: BitSize) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_open_array&quot;);
      u.wr.Tipe (t);
      u.wr.Tipe (elt);
      u.wr.BInt (s);
      u.wr.NL   ();
    END
  END declare_open_array;

PROCEDURE <A NAME="declare_enum"><procedure>declare_enum</procedure></A> (u: U;  t: TypeUID;  n_elts: INTEGER;  s: BitSize) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_enum&quot;);
      u.wr.Tipe (t);
      u.wr.Int  (n_elts);
      u.wr.BInt (s);
      u.wr.NL   ();
    END
  END declare_enum;

PROCEDURE <A NAME="declare_enum_elt"><procedure>declare_enum_elt</procedure></A> (u: U;  n: Name) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_enum_elt&quot;);
      u.wr.ZName (n);
      u.wr.NL    ();
    END
  END declare_enum_elt;

PROCEDURE <A NAME="declare_packed"><procedure>declare_packed</procedure></A>  (u: U;  t: TypeUID;  s: BitSize;  base: TypeUID) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_packed&quot;);
      u.wr.Tipe (t);
      u.wr.BInt (s);
      u.wr.Tipe (base);
      u.wr.NL   ();
    END
  END declare_packed;

PROCEDURE <A NAME="declare_record"><procedure>declare_record</procedure></A> (u: U; t: TypeUID;  s: BitSize;
                          n_fields: INTEGER)=
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_record&quot;);
      u.wr.Tipe (t);
      u.wr.BInt (s);
      u.wr.Int  (n_fields);
      u.wr.NL   ();
    END
  END declare_record;

PROCEDURE <A NAME="declare_field"><procedure>declare_field</procedure></A> (u: U;  n: Name;  o: BitOffset;  s: BitSize;
                         t: TypeUID)=
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_field&quot;);
      u.wr.ZName (n);
      u.wr.BInt  (o);
      u.wr.BInt  (s);
      u.wr.Tipe  (t);
      u.wr.NL    ();
    END
  END declare_field;

PROCEDURE <A NAME="declare_set"><procedure>declare_set</procedure></A> (u: U;  t, domain: TypeUID;  s: BitSize) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_set&quot;);
      u.wr.Tipe (t);
      u.wr.Tipe (domain);
      u.wr.BInt (s);
      u.wr.NL    ();
    END
  END declare_set;

PROCEDURE <A NAME="declare_subrange"><procedure>declare_subrange</procedure></A> (u: U; t, domain: TypeUID;
                            READONLY min, max: Target.Int;
                            s: BitSize) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_subrange&quot;);
      u.wr.Tipe (t);
      u.wr.Tipe (domain);
      u.wr.TInt (min);
      u.wr.TInt (max);
      u.wr.BInt (s);
      u.wr.NL   ();
    END
  END declare_subrange;

PROCEDURE <A NAME="declare_pointer"><procedure>declare_pointer</procedure></A> (u: U;  t, target: TypeUID;  brand: TEXT;
                           traced: BOOLEAN) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_pointer&quot;);
      u.wr.Tipe (t);
      u.wr.Tipe (target);
      u.wr.Txt  (brand);
      u.wr.Bool (traced);
      u.wr.NL   ();
    END
  END declare_pointer;

PROCEDURE <A NAME="declare_indirect"><procedure>declare_indirect</procedure></A> (u: U;  t, target: TypeUID) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_indirect&quot;);
      u.wr.Tipe (t);
      u.wr.Tipe (target);
      u.wr.NL   ();
    END
  END declare_indirect;

PROCEDURE <A NAME="declare_proctype"><procedure>declare_proctype</procedure></A> (u: U;  t: TypeUID;  n_formals: INTEGER;
                            result: TypeUID;  n_raises: INTEGER;
                            cc: CallingConvention) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_proctype&quot;);
      u.wr.Tipe (t);
      u.wr.Int  (n_formals);
      u.wr.Tipe (result);
      u.wr.Int  (n_raises);
      u.wr.Txt  (cc.name);
      u.wr.NL   ();
    END
  END declare_proctype;

PROCEDURE <A NAME="declare_formal"><procedure>declare_formal</procedure></A> (u: U;  n: Name;  t: TypeUID) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_formal&quot;);
      u.wr.ZName (n);
      u.wr.Tipe  (t);
      u.wr.NL    ();
    END
  END declare_formal;

PROCEDURE <A NAME="declare_raises"><procedure>declare_raises</procedure></A> (u: U;  n: Name) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_raises&quot;);
      u.wr.ZName (n);
      u.wr.NL    ();
    END
  END declare_raises;

PROCEDURE <A NAME="declare_object"><procedure>declare_object</procedure></A> (u: U;  t, super: TypeUID;
                          brand: TEXT;  traced: BOOLEAN;
                          n_fields, n_methods: INTEGER;
                          field_size: BitSize) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd  (&quot;declare_object&quot;);
      u.wr.Tipe (t);
      u.wr.Tipe (super);
      u.wr.Txt  (brand);
      u.wr.Bool (traced);
      u.wr.Int  (n_fields);
      u.wr.Int  (n_methods);
      u.wr.BInt (field_size);
      u.wr.NL   ();
    END
  END declare_object;

PROCEDURE <A NAME="declare_method"><procedure>declare_method</procedure></A> (u: U;  n: Name;  signature: TypeUID) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_method&quot;);
      u.wr.ZName (n);
      u.wr.Tipe  (signature);
      u.wr.NL    ();
    END
  END declare_method;

PROCEDURE <A NAME="declare_opaque"><procedure>declare_opaque</procedure></A> (u: U;  t, super: TypeUID) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_opaque&quot;);
      u.wr.Tipe  (t);
      u.wr.Tipe  (super);
      u.wr.NL    ();
    END
  END declare_opaque;

PROCEDURE <A NAME="reveal_opaque"><procedure>reveal_opaque</procedure></A> (u: U;  lhs, rhs: TypeUID) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;reveal_opaque&quot;);
      u.wr.Tipe  (lhs);
      u.wr.Tipe  (rhs);
      u.wr.NL    ();
    END
  END reveal_opaque;

PROCEDURE <A NAME="declare_exception"><procedure>declare_exception</procedure></A> (u: U;  n: Name;  arg_type: TypeUID;
                           raise_proc: BOOLEAN;  base: Var;  offset: INTEGER) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_exception&quot;);
      u.wr.ZName (n);
      u.wr.Tipe  (arg_type);
      u.wr.Bool  (raise_proc);
      u.wr.VName (base);
      u.wr.Int   (offset);
      u.wr.NL    ();
    END
  END declare_exception;
</PRE>--------------------------------------------------------- runtime hooks ---

<P><PRE>PROCEDURE <A NAME="set_runtime_hook"><procedure>set_runtime_hook</procedure></A> (u: U;  n: Name;  v: Var;  o: ByteOffset) =
  VAR e := NEW (RuntimeHook, name := n, var := v,  offset := o);
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_runtime_hook&quot;);
      u.wr.ZName (n);
      u.wr.VName (v);
      u.wr.Int   (o);
      u.wr.NL    ();
    END;

    EVAL u.runtime.put (n, e);

    IF Text.Equal(M3ID.ToText(n), &quot;ReportFault&quot;) THEN
      u.rfault_name := n;
      IF u.debug THEN
        u.wr.OutT(&quot;Setting report fault&quot;);
        u.wr.NL();
      END
    END
  END set_runtime_hook;

PROCEDURE <A NAME="get_runtime_hook"><procedure>get_runtime_hook</procedure></A> (u: U;  n: Name; VAR v: Var; VAR o: ByteOffset) =
  VAR ref: REFANY;  e: RuntimeHook;
  BEGIN
    (* no ASCII output is generated ... *)
    IF u.runtime.get (n, ref) THEN
      e := ref;
      v := e.var;
      o := e.offset;
    ELSE
      v := NIL;
      o := 0;
    END;
  END get_runtime_hook;
</PRE>------------------------------------------------- variable declarations ---

<P><PRE>PROCEDURE <A NAME="NewVar"><procedure>NewVar</procedure></A> (u: U; t: Type; uid: TypeUID; s: ByteSize; a: Alignment;
                  name: Name := M3ID.NoID): x86Var =
  VAR v := NEW (x86Var, tag := u.next_var, type := t, s := s,
                a := a);
  BEGIN
    IF name = M3ID.NoID THEN
      v.name := M3ID.Add(&quot;T$&quot; &amp; Fmt.Int(v.tag));
    ELSIF uid = -1 THEN
      v.name := M3ID.Add(&quot;_M&quot; &amp; M3ID.ToText(name));
    ELSE
      v.name := M3ID.Add(&quot;_&quot; &amp; M3ID.ToText(name));
    END;

    INC (u.next_var);
    RETURN v;
  END NewVar;

PROCEDURE <A NAME="import_global"><procedure>import_global</procedure></A> (u: U;  n: Name;  s: ByteSize;  a: Alignment;
                         t: Type;  m3t: TypeUID): Var =
  VAR v := NewVar(u, t, m3t, s, a, n);
  BEGIN
    v.symbol := u.obj.import_symbol(v.name);
    v.offset := 0;
    v.loc := VLoc.global;

    IF u.debug THEN
      u.wr.Cmd   (&quot;import_global&quot;);
      u.wr.ZName (n);
      u.wr.Int   (s);
      u.wr.Int   (a);
      u.wr.TName (t);
      u.wr.Tipe  (m3t);
      u.wr.VName (v);
      u.wr.NL    ();
    END;

    RETURN v;
  END import_global;

PROCEDURE <A NAME="declare_segment"><procedure>declare_segment</procedure></A> (u: U;  n: Name;  m3t: TypeUID): Var =
  VAR v := NewVar(u, Type.Void, m3t, 0, 4, n);
  BEGIN
    IF u.global_var = NIL THEN
      u.global_var := v;
      IF u.debug THEN
        u.wr.OutT(&quot;Chosen this declare segment as GLOBALVAR&quot;);
        u.wr.NL();
      END
    END;

    v.symbol := u.obj.define_symbol(v.name, Seg.Data, 0);
    v.offset := 0;
    v.loc := VLoc.global;

    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_segment&quot;);
      u.wr.ZName (n);
      u.wr.Tipe  (m3t);
      u.wr.VName (v);
      u.wr.NL    ();
    END;

    RETURN v;
  END declare_segment;

PROCEDURE <A NAME="bind_segment"><procedure>bind_segment</procedure></A> (u: U;  v: Var;  s: ByteSize;  a: Alignment;
                        t: Type;  exported, inited: BOOLEAN) =
  VAR realvar := NARROW(v, x86Var);
  BEGIN
    &lt;* ASSERT inited *&gt;

    realvar.type := t;
    realvar.s := s;
    realvar.a := a;

    IF exported THEN
      u.obj.export_symbol(realvar.symbol);
    END;

    IF u.debug THEN
      u.wr.Cmd   (&quot;bind_segment&quot;);
      u.wr.VName (v);
      u.wr.Int   (s);
      u.wr.Int   (a);
      u.wr.TName (t);
      u.wr.Bool  (exported);
      u.wr.Bool  (inited);
      u.wr.NL    ();
    END
  END bind_segment;

PROCEDURE <A NAME="declare_global"><procedure>declare_global</procedure></A> (u: U;  n: Name;  s: ByteSize;  a: Alignment;
                     t: Type;  m3t: TypeUID;  exported, inited: BOOLEAN): Var =
  VAR v := NewVar(u, t, m3t, s, a, n);
  BEGIN
    IF inited THEN
      v.symbol := u.obj.define_symbol(v.name, Seg.Data, 0);
    ELSE
      v.symbol := u.obj.define_bss_symbol(v.name, s, a);
    END;

    v.loc := VLoc.global;

    IF exported THEN
      u.obj.export_symbol(v.symbol);
    END;

    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_global&quot;);
      u.wr.ZName (n);
      u.wr.Int   (s);
      u.wr.Int   (a);
      u.wr.TName (t);
      u.wr.Tipe  (m3t);
      u.wr.Bool  (exported);
      u.wr.Bool  (inited);
      u.wr.VName (v);
      u.wr.NL    ();
    END;

    RETURN v;
  END declare_global;

PROCEDURE <A NAME="declare_constant"><procedure>declare_constant</procedure></A> (u: U;  n: Name;  s: ByteSize;  a: Alignment;
                     t: Type;  m3t: TypeUID;  exported, inited: BOOLEAN): Var =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_constant&quot;);
      u.wr.ZName (n);
      u.wr.Int   (s);
      u.wr.Int   (a);
      u.wr.TName (t);
      u.wr.Tipe  (m3t);
      u.wr.Bool  (exported);
      u.wr.Bool  (inited);
      u.wr.NL    ();
    END;

    RETURN declare_global(u, n, s, a, t, m3t, exported, inited);
  END declare_constant;

PROCEDURE <A NAME="declare_local"><procedure>declare_local</procedure></A> (u: U;  n: Name;  s: ByteSize;  a: Alignment;
                         t: Type;  m3t: TypeUID;  in_memory, up_level: BOOLEAN;
                         f: Frequency): Var =
  VAR v: x86Var;
  BEGIN
    IF u.in_proc THEN
      v := get_temp_var (u, t, s, a, n);
    ELSE
      v := create_temp_var (u, t, s, a, n);
    END;

    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_local&quot;);
      u.wr.ZName (n);
      u.wr.Int   (s);
      u.wr.Int   (a);
      u.wr.TName (t);
      u.wr.Tipe  (m3t);
      u.wr.Bool  (in_memory);
      u.wr.Bool  (up_level);
      u.wr.Int   (f);
      u.wr.VName (v);
      u.wr.Int   (v.offset);
      u.wr.NL    ();
    END;

    RETURN v;
  END declare_local;

PROCEDURE <A NAME="mangle_procname"><procedure>mangle_procname</procedure></A> (base: M3ID.T; arg_size: INTEGER;
                           std_call: BOOLEAN): M3ID.T =
  &lt;*FATAL Convert.Failed*&gt;
  VAR buf: ARRAY [0..99] OF CHAR;
      txt: TEXT;
      len: INTEGER;
  BEGIN
    txt := M3ID.ToText(base);
    len := Text.Length(txt);
    IF len &lt; (NUMBER(buf)+10) THEN
      buf [0] := '_';  INC(len);
      Text.SetChars(SUBARRAY(buf, 1, NUMBER(buf)-1), txt);
      IF std_call THEN
        buf [len] := '@'; INC(len);
        INC (len, Convert.FromInt(SUBARRAY(buf, len, NUMBER(buf)-len),
                                   arg_size));
      END;
      RETURN M3ID.FromStr(buf, len);
    ELSE
      IF std_call THEN
        RETURN M3ID.Add(Fmt.F (&quot;_%s@%s&quot;, txt, Fmt.Int (arg_size)));
      ELSE
        RETURN M3ID.Add(Fmt.F (&quot;_%s&quot;, txt));
      END
    END;
  END mangle_procname;

PROCEDURE <A NAME="declare_param"><procedure>declare_param</procedure></A> (u: U;  n: Name;  s: ByteSize;  a: Alignment;
                         t: Type;  m3t: TypeUID;  in_memory, up_level: BOOLEAN;
                         f: Frequency): Var =
  VAR v := NewVar(u, t, m3t, s, 4, n);
  BEGIN
    (* Assume a = 4 and ESP is dword aligned... *)

    s := (s + 3) DIV 4 * 4;

    v.offset := u.param_proc.paramsize;
    v.loc := VLoc.temp;

    v.parent := u.param_proc;

    INC(u.param_proc.paramsize, s);

    &lt;* ASSERT u.n_params &gt; 0 *&gt;
    DEC(u.n_params);

    IF u.n_params = 0 AND u.param_proc.stdcall THEN
      (* callee cleans &amp; mangled name *)
      u.param_proc.name := mangle_procname(u.param_proc.name,
                                           u.param_proc.paramsize - 8,
                                           std_call := TRUE);

      IF u.param_proc.import THEN
        u.param_proc.symbol := u.obj.import_symbol(u.param_proc.name);
      ELSE
        u.param_proc.symbol := u.obj.define_symbol(u.param_proc.name,
                                                   Seg.Text, 0);
      END;

      IF u.param_proc.exported THEN
        u.obj.export_symbol(u.param_proc.symbol);
      END
    END;

    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_param&quot;);
      u.wr.ZName (n);
      u.wr.Int   (s);
      u.wr.Int   (a);
      u.wr.TName (t);
      u.wr.Tipe  (m3t);
      u.wr.Bool  (in_memory);
      u.wr.Bool  (up_level);
      u.wr.Int   (f);
      u.wr.VName (v);
      u.wr.Int   (v.offset);
      u.wr.NL    ();
    END;

    RETURN v;
  END declare_param;

PROCEDURE <A NAME="declare_temp"><procedure>declare_temp</procedure></A>   (u: U;  s: ByteSize;  a: Alignment;  t: Type;
                          in_memory:BOOLEAN): Var =
  VAR v: x86Var;
  BEGIN
    &lt;* ASSERT u.in_proc *&gt;

    v := get_temp_var(u, t, s, a);

    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_temp&quot;);
      u.wr.Int   (s);
      u.wr.Int   (a);
      u.wr.TName (t);
      u.wr.Bool  (in_memory);
      u.wr.VName (v);
      u.wr.Int   (v.offset);
      u.wr.NL    ();
    END;

    RETURN v;
  END declare_temp;

PROCEDURE <A NAME="get_temp_var"><procedure>get_temp_var</procedure></A> (u: U; t: Type; s: ByteSize; a: Alignment;
                        n: Name := M3ID.NoID): x86Var =
  BEGIN
    IF s &lt; 4 THEN
      s := 4;
    END;

    IF a &lt; 4 THEN
      a := 4;
    END;

    FOR i := 0 TO u.current_proc.tempsize - 1 DO
      WITH temp = u.current_proc.temparr[i] DO
        IF temp.free AND temp.var.s = s AND temp.var.a &gt;= a THEN
          temp.free := FALSE;
          temp.var.type := t;
          temp.var.stack_temp := FALSE;
          temp.var.scope := u.next_scope - 1;
          RETURN temp.var;
        END
      END
    END;

    IF u.current_proc.tempsize = u.current_proc.templimit THEN
      expand_temp(u);
    END;

    WITH temp = u.current_proc.temparr[u.current_proc.tempsize] DO
      temp.var := create_temp_var(u, t, s, a, n);
      temp.free := FALSE;
      temp.var.scope := u.next_scope - 1;
    END;

    INC(u.current_proc.tempsize);

    RETURN u.current_proc.temparr[u.current_proc.tempsize - 1].var;
  END get_temp_var;

PROCEDURE <A NAME="expand_temp"><procedure>expand_temp</procedure></A> (u: U) =
  VAR newarr := NEW(REF ARRAY OF Temp, u.current_proc.templimit * 2);
  BEGIN
    FOR i := 0 TO (u.current_proc.templimit - 1) DO
      newarr[i] := u.current_proc.temparr[i];
    END;

    u.current_proc.templimit := u.current_proc.templimit * 2;
    u.current_proc.temparr := newarr;
  END expand_temp;

PROCEDURE <A NAME="create_temp_var"><procedure>create_temp_var</procedure></A> (u: U; t: Type; s: ByteSize; a: Alignment;
                           n: Name): x86Var =
  VAR v := NewVar(u, t, 0, s, a, n);
  BEGIN
    v.loc := VLoc.temp;
    v.parent := u.current_proc;

    u.current_proc.framesize := Word.And(u.current_proc.framesize + a - 1,
                                         Alignmask[a]);

    INC(u.current_proc.framesize, s);

    v.offset := -u.current_proc.framesize;

    RETURN v;
  END create_temp_var;

PROCEDURE <A NAME="free_temp"><procedure>free_temp</procedure></A> (u: U;  v: Var) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;free_temp&quot;);
      u.wr.VName (v);
      u.wr.NL    ();
    END;

    FOR i := 0 TO u.current_proc.tempsize - 1 DO
      IF (NOT u.current_proc.temparr[i].free) AND
         u.current_proc.temparr[i].var = v THEN
        u.current_proc.temparr[i].free := TRUE;
        RETURN;
      END
    END;

    u.Err(&quot;Couldn't find var to free in 'free_temp'&quot;);
  END free_temp;
</PRE>---------------------------------------- static variable initialization ---

<P><PRE>PROCEDURE <A NAME="begin_init"><procedure>begin_init</procedure></A> (u: U;  v: Var) =
  VAR realvar := NARROW(v, x86Var);
      offs, pad: INTEGER;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;begin_init&quot;);
      u.wr.VName (v);
      u.wr.NL    ();
    END;

    &lt;* ASSERT u.init_varstore = NIL *&gt;

    u.init_varstore := v;

    offs := u.obj.cursor(Seg.Data);

    IF Word.And(offs, realvar.a - 1) # 0 THEN
      pad := realvar.a - Word.And(offs, realvar.a - 1);
      INC(offs, pad);
      IF Word.And(pad, 3) # 0 THEN
        u.obj.append(Seg.Data, 0, Word.And(pad, 3));
        pad := Word.And(pad, 16_FFFFFFFC);
      END;

      pad := pad DIV 4;
      FOR i := 1 TO pad DO
        u.obj.append(Seg.Data, 0, 4);
      END
    END;

    u.obj.move_symbol(realvar.symbol, offs);

    u.init_count := 0;
  END begin_init;

PROCEDURE <A NAME="end_init"><procedure>end_init</procedure></A> (u: U;  v: Var) =
  VAR realvar := NARROW(v, x86Var);
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;end_init&quot;);
      u.wr.VName (v);
      u.wr.NL    ();
    END;

    &lt;* ASSERT v = u.init_varstore *&gt;

    pad_init(u, realvar.s);
    u.init_varstore := NIL;
  END end_init;

PROCEDURE <A NAME="init_int"><procedure>init_int</procedure></A> (u: U;  o: ByteOffset;  READONLY value: Target.Int;
                    t: Type) =
  VAR int: INTEGER;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;init_int&quot;);
      u.wr.Int   (o);
      u.wr.TInt  (value);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    pad_init(u, o);

    EVAL TargetInt.ToInt(value, int);
    u.obj.append(Seg.Data, int, CG_Bytes[t]);
    INC(u.init_count, CG_Bytes[t]);
  END init_int;

PROCEDURE <A NAME="init_proc"><procedure>init_proc</procedure></A> (u: U;  o: ByteOffset;  value: Proc) =
  VAR realproc := NARROW(value, x86Proc);
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;init_proc&quot;);
      u.wr.Int   (o);
      u.wr.PName (value);
      u.wr.NL    ();
    END;

    pad_init(u, o);

    u.obj.append(Seg.Data, 0, 4);
    INC(u.init_count, 4);

    u.obj.relocate(u.init_varstore.symbol, o, realproc.symbol);
  END init_proc;

PROCEDURE <A NAME="init_label"><procedure>init_label</procedure></A> (u: U;  o: ByteOffset;  value: Label) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;init_label&quot;);
      u.wr.Int   (o);
      u.wr.Lab   (value);
      u.wr.NL    ();
    END;

    pad_init(u, o);

    u.cg.log_label_init(u.init_varstore, o, value);

    INC(u.init_count, 4);
  END init_label;

PROCEDURE <A NAME="init_var"><procedure>init_var</procedure></A> (u: U;  o: ByteOffset;  value: Var;  bias: ByteOffset) =
  VAR realvar := NARROW(value, x86Var);
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;init_var&quot;);
      u.wr.Int   (o);
      u.wr.VName (value);
      u.wr.Int   (bias);
      u.wr.NL    ();
    END;

    &lt;* ASSERT realvar.loc = VLoc.global *&gt;

    pad_init(u, o);

    u.obj.append(Seg.Data, bias, 4);
    INC(u.init_count, 4);

    u.obj.relocate(u.init_varstore.symbol, o, realvar.symbol);
  END init_var;

PROCEDURE <A NAME="init_offset"><procedure>init_offset</procedure></A> (u: U;  o: ByteOffset;  value: Var) =
  VAR realvar := NARROW(value, x86Var);
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;init_offset&quot;);
      u.wr.Int   (o);
      u.wr.VName (value);
      u.wr.NL    ();
    END;

    &lt;* ASSERT realvar.loc = VLoc.temp *&gt;

    pad_init(u, o);

    u.obj.append(Seg.Data, realvar.offset, 4);
    INC(u.init_count, 4);
  END init_offset;

PROCEDURE <A NAME="init_chars"><procedure>init_chars</procedure></A> (u: U;  o: ByteOffset;  value: TEXT) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;init_chars&quot;);
      u.wr.Int   (o);
      u.wr.Txt   (value);
      u.wr.NL    ();
    END;

    pad_init(u, o);

    WITH len = Text.Length(value) DO
      FOR i := 0 TO len - 1 DO
        u.obj.append(Seg.Data, ORD(Text.GetChar(value, i)), 1);
      END;

      INC(u.init_count, len);
    END
  END init_chars;

PROCEDURE <A NAME="init_float"><procedure>init_float</procedure></A> (u: U;  o: ByteOffset;  READONLY f: Target.Float) =
  VAR flarr: ARRAY [0 .. 1] OF INTEGER;
      size: INTEGER;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;init_float&quot;);
      u.wr.Int   (o);
      u.wr.Flt   (f);
      u.wr.NL    ();
    END;

    size := TargetFloat.ToInts(f, flarr);

    &lt;* ASSERT size = 1 OR size = 2 *&gt;

    pad_init(u, o);

    u.obj.append(Seg.Data, flarr[0], 4);
    INC(u.init_count, 4);
    IF size = 2 THEN
      u.obj.append(Seg.Data, flarr[1], 4);
      INC(u.init_count, 4);
    END
  END init_float;

PROCEDURE <A NAME="pad_init"><procedure>pad_init</procedure></A> (u: U; o: ByteOffset) =
  BEGIN
    &lt;* ASSERT u.init_count &lt;= o *&gt;
    &lt;* ASSERT o &lt;= u.init_varstore.s *&gt;

    FOR i := u.init_count TO o - 1 DO
      u.obj.append(Seg.Data, 0, 1);
    END;

    u.init_count := o;
  END pad_init;
</PRE>------------------------------------------------------------ procedures ---

<P><PRE>PROCEDURE <A NAME="NewProc"><procedure>NewProc</procedure></A> (u: U; n: Name; n_params: INTEGER;
                   ret_type: Type;  cc: CallingConvention): x86Proc =
  VAR p := NEW (x86Proc, tag := u.next_proc, n_params := n_params,
                type := ret_type, stdcall := (cc.m3cg_id = 1));
  BEGIN
    IF n = M3ID.NoID
      THEN p.name := M3ID.Add(&quot;P$&quot; &amp; Fmt.Int(p.tag));
      ELSE p.name := n;
    END;

    p.templimit := 16;
    p.temparr := NEW(REF ARRAY OF Temp, p.templimit);

    INC (u.next_proc);
    RETURN p;
  END NewProc;

PROCEDURE <A NAME="import_procedure"><procedure>import_procedure</procedure></A> (u: U;  n: Name;  n_params: INTEGER;
                            ret_type: Type;  cc: CallingConvention): Proc =
  VAR p := NewProc (u, n, n_params, ret_type, cc);
  BEGIN
    p.import := TRUE;

    u.n_params := n_params;

    IF n_params = 0 OR NOT p.stdcall THEN
      p.name := mangle_procname(p.name, 0, p.stdcall);
      p.symbol := u.obj.import_symbol(p.name);
    END;

    u.param_proc := p;

    IF u.debug THEN
      u.wr.Cmd   (&quot;import_procedure&quot;);
      u.wr.ZName (n);
      u.wr.Int   (n_params);
      u.wr.TName (ret_type);
      u.wr.Txt   (cc.name);
      u.wr.PName (p);
      u.wr.NL    ();
    END;

    RETURN p;
  END import_procedure;

PROCEDURE <A NAME="declare_procedure"><procedure>declare_procedure</procedure></A> (u: U;  n: Name;  n_params: INTEGER;
                             return_type: Type;  lev: INTEGER;
                             cc: CallingConvention;
                             exported: BOOLEAN;  parent: Proc): Proc =
  VAR p := NewProc (u, n, n_params, return_type, cc);
  BEGIN
    p.exported := exported;

    p.lev := lev;
    p.parent := parent;

    IF p.lev # 0 THEN
      INC(p.framesize, 4);
    END;

    u.n_params := n_params;

    IF n_params = 0 OR NOT p.stdcall THEN
      p.name   := mangle_procname(p.name, 0, p.stdcall);
      p.symbol := u.obj.define_symbol(p.name, Seg.Text, 0);
      IF exported THEN u.obj.export_symbol(p.symbol); END
    END;

    u.param_proc := p;

    IF NOT u.in_proc THEN u.current_proc := p; END;

    IF u.debug THEN
      u.wr.Cmd   (&quot;declare_procedure&quot;);
      u.wr.ZName (n);
      u.wr.Int   (n_params);
      u.wr.TName (return_type);
      u.wr.Int   (lev);
      u.wr.Txt   (cc.name);
      u.wr.Bool  (exported);
      u.wr.PName (parent);
      u.wr.PName (p);
      u.wr.NL    ();
    END;

    RETURN p;
  END declare_procedure;

PROCEDURE <A NAME="begin_procedure"><procedure>begin_procedure</procedure></A> (u: U;  p: Proc) =
  VAR realproc := NARROW(p, x86Proc);
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;begin_procedure&quot;);
      u.wr.PName (p);
      u.wr.NL    ();

      u.wr.Flush();
    END;

    u.vstack.clearall ();

    &lt;* ASSERT NOT u.in_proc *&gt;
    u.in_proc := TRUE;

    u.current_proc := p;
    u.cg.set_current_proc(p);
    u.vstack.set_current_proc(p);
    u.last_exitbranch := -1;
    u.exit_proclabel := -1;

    realproc.offset := u.obj.cursor(Seg.Text);
    realproc.bound := TRUE;

    WHILE realproc.usage # NIL DO
      u.obj.patch(Seg.Text, realproc.usage.loc, realproc.offset -
                  (realproc.usage.loc + 4), 4);
      realproc.usage := realproc.usage.link;
    END;

    u.obj.move_symbol(realproc.symbol, realproc.offset);

    u.obj.begin_procedure(realproc.symbol);

    u.cg.pushOp(u.cg.reg[Codex86.EBP]);
    u.cg.movOp(u.cg.reg[Codex86.EBP], u.cg.reg[Codex86.ESP]);

    u.cg.immOp(Op.oSUB, u.cg.reg[Codex86.ESP], 16_FFFF);
    u.procframe_ptr := u.obj.cursor(Seg.Text) - 4;

    u.cg.pushOp(u.cg.reg[Codex86.EBX]);
    u.cg.pushOp(u.cg.reg[Codex86.ESI]);
    u.cg.pushOp(u.cg.reg[Codex86.EDI]);

    IF u.current_proc.lev # 0 THEN
      u.cg.store_ind(u.cg.reg[Codex86.ECX], u.cg.reg[Codex86.EBP],
                     -4, Type.Addr);
    END;

    u.current_proc.tempsize := 0;

    &lt;* ASSERT u.next_scope = 1 *&gt;

    begin_block(u);
  END begin_procedure;

PROCEDURE <A NAME="end_procedure"><procedure>end_procedure</procedure></A> (u: U;  p: Proc) =
  VAR realproc := NARROW(p, x86Proc);
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;end_procedure&quot;);
      u.wr.PName (p);
      u.wr.NL    ();
    END;

    procedure_epilogue(u);

    &lt;* ASSERT u.in_proc *&gt;
    &lt;* ASSERT u.current_proc = p *&gt;

    u.current_proc.framesize := Word.And(u.current_proc.framesize + 3,
                                         16_FFFFFFFC);

    u.obj.patch(Seg.Text, u.procframe_ptr, u.current_proc.framesize, 4);

    u.in_proc := FALSE;

    u.obj.end_procedure(realproc.symbol);

    end_block(u);
  END end_procedure;

PROCEDURE <A NAME="begin_block"><procedure>begin_block</procedure></A> (u: U) =
  (* marks the beginning of a nested anonymous block *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;begin_block&quot;);
      u.wr.NL    ();
    END;

    INC(u.next_scope);
  END begin_block;

PROCEDURE <A NAME="end_block"><procedure>end_block</procedure></A> (u: U) =
  (* marks the ending of a nested anonymous block *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;end_block&quot;);
      u.wr.NL    ();
    END;

    &lt;* ASSERT u.next_scope &gt; 1 *&gt;
    DEC(u.next_scope);

    free_locals(u, u.next_scope);
  END end_block;

PROCEDURE <A NAME="free_locals"><procedure>free_locals</procedure></A> (u: U; scope: INTEGER) =
  BEGIN
    FOR i := 0 TO u.current_proc.tempsize - 1 DO
      IF (NOT u.current_proc.temparr[i].free) AND
         u.current_proc.temparr[i].var.scope = scope THEN
        u.current_proc.temparr[i].free := TRUE;
      END
    END
  END free_locals;

PROCEDURE <A NAME="note_procedure_origin"><procedure>note_procedure_origin</procedure></A> (u: U;  p: Proc) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;note_procedure_origin&quot;);
      u.wr.PName (p);
      u.wr.NL    ();
    END
  END note_procedure_origin;
</PRE>------------------------------------------------------------ statements ---

<P><PRE>PROCEDURE <A NAME="set_label"><procedure>set_label</procedure></A> (u: U;  l: Label;  &lt;*UNUSED*&gt; barrier: BOOLEAN) =
  (* define 'l' to be at the current pc *)
  BEGIN
    IF u.debug THEN
      u.wr.OutT  (&quot;.&quot;);
      u.wr.Lab   (l);
      u.wr.NL    ();
    END;

    u.cg.set_label(l);

    u.vstack.clearall();
  END set_label;

PROCEDURE <A NAME="jump"><procedure>jump</procedure></A> (u: U; l: Label) =
  (* GOTO l *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;jump&quot;);
      u.wr.Lab   (l);
      u.wr.NL    ();
    END;

    u.cg.brOp(Cond.Always, l);
  END jump;

PROCEDURE <A NAME="if_true"><procedure>if_true</procedure></A>  (u: U; l: Label; &lt;*UNUSED*&gt; f: Frequency) =
  (* IF (s0.I # 0) GOTO l ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;if_true&quot;);
      u.wr.Lab   (l);
      u.wr.NL    ();
    END;

    condbranch(u, l, Cond.NZ, Type.Int);
  END if_true;

PROCEDURE <A NAME="if_false"><procedure>if_false</procedure></A> (u: U; l: Label; &lt;*UNUSED*&gt; f: Frequency) =
  (* IF (s0.I = 0) GOTO l ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;if_false&quot;);
      u.wr.Lab   (l);
      u.wr.NL    ();
    END;

    condbranch(u, l, Cond.Z, Type.Int);
  END if_false;

PROCEDURE <A NAME="if_eq"><procedure>if_eq</procedure></A> (u: U;  l: Label;  t: ZType; &lt;*UNUSED*&gt; f: Frequency) =
  (* IF (s1.t = s0.t) GOTO l ; pop(2) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;if_eq&quot;);
      u.wr.Lab   (l);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condbranch(u, l, Cond.E, t);
  END if_eq;

PROCEDURE <A NAME="if_ne"><procedure>if_ne</procedure></A> (u: U;  l: Label;  t: ZType; &lt;*UNUSED*&gt; f: Frequency) =
  (* IF (s1.t # s0.t) GOTO l ; pop(2) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;if_ne&quot;);
      u.wr.Lab   (l);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condbranch(u, l, Cond.NE, t);
  END if_ne;

PROCEDURE <A NAME="if_gt"><procedure>if_gt</procedure></A> (u: U;  l: Label;  t: ZType; &lt;*UNUSED*&gt; f: Frequency) =
  (* IF (s1.t &gt; s0.t) GOTO l ; pop(2) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;if_gt&quot;);
      u.wr.Lab   (l);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condbranch(u, l, Cond.G, t);
  END if_gt;

PROCEDURE <A NAME="if_ge"><procedure>if_ge</procedure></A> (u: U;  l: Label;  t: ZType; &lt;*UNUSED*&gt; f: Frequency) =
  (* IF (s1.t &gt;= s0.t) GOTO l ; pop(2) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;if_ge&quot;);
      u.wr.Lab   (l);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condbranch(u, l, Cond.GE, t);
  END if_ge;

PROCEDURE <A NAME="if_lt"><procedure>if_lt</procedure></A> (u: U;  l: Label;  t: ZType; &lt;*UNUSED*&gt; f: Frequency) =
  (* IF (s1.t &lt; s0.t) GOTO l ; pop(2) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;if_lt&quot;);
      u.wr.Lab   (l);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condbranch(u, l, Cond.L, t);
  END if_lt;

PROCEDURE <A NAME="if_le"><procedure>if_le</procedure></A> (u: U;  l: Label;  t: ZType; &lt;*UNUSED*&gt; f: Frequency) =
  (* IF (s1.t &lt;= s0.t) GOTO l ; pop(2) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;if_le&quot;);
      u.wr.Lab   (l);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condbranch(u, l, Cond.LE, t);
  END if_le;

PROCEDURE <A NAME="case_jump"><procedure>case_jump</procedure></A> (u: U; READONLY labels: ARRAY OF Label) =
  (* &quot;GOTO labels[s0.I] ; pop&quot; with no range checking on s0.I *)
  VAR stack0: INTEGER;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;case_jump&quot;);
      u.wr.Int   (NUMBER(labels));

      FOR i := FIRST (labels) TO LAST (labels) DO  u.wr.Lab (labels [i]);  END;
      u.wr.NL    ();
    END;

    stack0 := u.vstack.pos(0, &quot;case_jump&quot;);
    u.vstack.unlock();
    u.vstack.find(stack0, Force.anyreg);
    u.cg.case_jump(u.vstack.op(stack0), labels);
    u.vstack.discard(1);
  END case_jump;

PROCEDURE <A NAME="exit_proc"><procedure>exit_proc</procedure></A> (u: U; t: Type) =
  (* Returns s0.t if t is not Void, otherwise returns no value. *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;exit_proc&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    IF t # Type.Void THEN
      u.vstack.unlock();

      WITH stack0 = u.vstack.pos(0, &quot;exit_proc&quot;) DO
        IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
          u.cg.f_exitproc();
        ELSE
          u.vstack.find(stack0, Force.regset, RegSet { Codex86.EAX });
        END
      END;

      u.vstack.discard(1);
    END;

    IF u.exit_proclabel = -1 THEN
      u.exit_proclabel := u.cg.reserve_labels(1, FALSE);
    END;

    u.last_exitbranch := u.obj.cursor(Seg.Text);

    u.cg.brOp(Cond.Always, u.exit_proclabel);
  END exit_proc;

PROCEDURE <A NAME="procedure_epilogue"><procedure>procedure_epilogue</procedure></A> (u: U) =
  VAR callee_cleans := u.current_proc.stdcall;
  BEGIN
    IF u.exit_proclabel = -1 THEN
      RETURN;
      (* Strange as it may seem, some procedures have no exit points... *)
    END;

    IF u.last_exitbranch = u.obj.cursor(Seg.Text) - 5 THEN
      (* Don't generate a branch to the epilogue at the last exit
         point of the procedure *)
      u.cg.set_label(u.exit_proclabel, offset := -5);

      u.obj.patch(Seg.Text, u.obj.cursor(Seg.Text) - 5,
                  16_C95B5E5F, 4);
      (* Intel for POP EDI, POP ESI, POP EBX, LEAVE *)

      IF callee_cleans THEN
        u.obj.patch(Seg.Text, u.obj.cursor(Seg.Text) - 1, 16_C2, 1);
        (* Intel for RET imm16 *)
        u.obj.append(Seg.Text, u.current_proc.paramsize - 8, 2);
        (* And the argument *)
      ELSE
        u.obj.patch(Seg.Text, u.obj.cursor(Seg.Text) - 1, 16_C3, 1);
        (* Intel for RET *)
      END
    ELSE
      u.cg.set_label(u.exit_proclabel);

      u.cg.popOp(u.cg.reg[Codex86.EDI]);
      u.cg.popOp(u.cg.reg[Codex86.ESI]);
      u.cg.popOp(u.cg.reg[Codex86.EBX]);

      u.cg.noargOp(Op.oLEAVE);
      IF callee_cleans THEN
        u.cg.cleanretOp(u.current_proc.paramsize - 8);
      ELSE
        u.cg.noargOp(Op.oRET);
      END
    END
  END procedure_epilogue;
</PRE>------------------------------------------------------------ load/store ---

<P><PRE>PROCEDURE <A NAME="load"><procedure>load</procedure></A>  (u: U;  v: Var;  o: ByteOffset;  t: MType) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;load&quot;);
      u.wr.VName (v);
      u.wr.Int   (o);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.push(MVar {var := v, o := o, t := t});
  END load;

PROCEDURE <A NAME="store"><procedure>store</procedure></A> (u: U;  v: Var;  o: ByteOffset;  t: MType) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;store&quot;);
      u.wr.VName (v);
      u.wr.Int   (o);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.pop(MVar {var := v, o := o, t := t});
  END store;

PROCEDURE <A NAME="store_ref"><procedure>store_ref</procedure></A> (u: U;  v: Var;  o: ByteOffset) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;store_ref&quot;);
      u.wr.VName (v);
      u.wr.Int   (o);
      u.wr.NL    ();
    END;

    store(u, v, o, Type.Addr);
  END store_ref;

PROCEDURE <A NAME="load_address"><procedure>load_address</procedure></A> (u: U;  v: Var;  o: ByteOffset) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;load_address&quot;);
      u.wr.VName (v);
      u.wr.Int   (o);
      u.wr.NL    ();
    END;

    u.vstack.doloadaddress(v, o);
  END load_address;

PROCEDURE <A NAME="load_indirect"><procedure>load_indirect</procedure></A> (u: U;  o: ByteOffset;  t: MType) =
  VAR newreg: Regno;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;load_indirect&quot;);
      u.wr.Int   (o);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;load_indirect&quot;) DO
      u.vstack.find(stack0, Force.anyreg, RegSet {}, TRUE);
      IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
        u.cg.f_loadind(u.vstack.op(stack0), o, t);
        u.vstack.dealloc_reg(stack0);
        u.vstack.set_fstack(stack0);
      ELSE
        IF CG_Bytes[t] = 1 THEN
          newreg := u.vstack.freereg(RegSet { Codex86.EAX, Codex86.EBX,
                                              Codex86.ECX, Codex86.EDX } );
        ELSE
          newreg := u.vstack.freereg();
        END;

        u.cg.load_ind(newreg, u.vstack.op(stack0), o, t);
        u.vstack.dealloc_reg(stack0);
        u.vstack.set_reg(stack0, newreg);
      END
    END
  END load_indirect;

PROCEDURE <A NAME="store_indirect"><procedure>store_indirect</procedure></A> (u: U;  o: ByteOffset;  t: MType) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;store_indirect&quot;);
      u.wr.Int   (o);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;store_indirect&quot;),
         stack1 = u.vstack.pos(1, &quot;store_indirect&quot;) DO
      IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
        u.vstack.find(stack1, Force.anyreg, RegSet {}, TRUE);
        u.cg.f_storeind(u.vstack.op(stack1), o, t);
        u.vstack.discard(2);
      ELSE
        u.vstack.dostoreind(o, t);
      END
    END
  END store_indirect;

PROCEDURE <A NAME="store_ref_indirect"><procedure>store_ref_indirect</procedure></A> (u: U;  o: ByteOffset;  var: BOOLEAN) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;store_ref_indirect&quot;);
      u.wr.Int   (o);
      u.wr.Bool  (var);
      u.wr.NL    ();
    END;

    store_indirect(u, o, Type.Addr);
  END store_ref_indirect;
</PRE>-------------------------------------------------------------- literals ---

<P><PRE>PROCEDURE <A NAME="load_nil"><procedure>load_nil</procedure></A> (u: U) =
  (* push ; s0.A := a *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;load_nil&quot;);
      u.wr.NL    ();
    END;

    u.vstack.pushimm(0);
  END load_nil;

PROCEDURE <A NAME="load_integer"><procedure>load_integer</procedure></A>  (u: U;  READONLY i: Target.Int) =
  (* push ; s0.I := i *)
  VAR int: INTEGER;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;load_integer&quot;);
      u.wr.TInt  (i);
      u.wr.NL    ();
    END;

    IF NOT TargetInt.ToInt(i, int) THEN
      u.Err(&quot;Failed to convert target integer in load_integer&quot;);
    END;
    u.vstack.unlock();
    u.vstack.pushimm(int);
  END load_integer;

PROCEDURE <A NAME="load_float"><procedure>load_float</procedure></A>    (u: U;  READONLY f: Target.Float) =
  (* push ; s0.t := f *)
  VAR flarr: ARRAY [0 .. 1] OF INTEGER;
      size: INTEGER;
      type: MType;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;load_float&quot;);
      u.wr.Flt   (f);
      u.wr.NL    ();
    END;

    CASE f.pre OF
      Target.Precision.Short =&gt; type := Type.Reel;
    | Target.Precision.Long =&gt; type := Type.LReel;
    | Target.Precision.Extended =&gt; type := Type.XReel;
    END;
    u.vstack.pushnew(type, Force.any);
    size := TargetFloat.ToInts(f, flarr);
    IF (size * 4) # CG_Bytes[type] THEN
      u.Err(&quot;Floating size mismatch in load_float&quot;);
    END;
    u.cg.f_loadlit(flarr, type);
  END load_float;
</PRE>------------------------------------------------------------ arithmetic ---

<P><PRE>PROCEDURE <A NAME="eq"><procedure>eq</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t = s0.t)  ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;eq&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condset(u, Cond.E, t);
  END eq;

PROCEDURE <A NAME="ne"><procedure>ne</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t # s0.t)  ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;ne&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condset(u, Cond.NE, t);
  END ne;

PROCEDURE <A NAME="gt"><procedure>gt</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t &gt; s0.t)  ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;gt&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condset(u, Cond.G, t);
  END gt;

PROCEDURE <A NAME="ge"><procedure>ge</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t &gt;= s0.t) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;ge&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condset(u, Cond.GE, t);
  END ge;

PROCEDURE <A NAME="lt"><procedure>lt</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t &lt; s0.t)  ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;lt&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condset(u, Cond.L, t);
  END lt;

PROCEDURE <A NAME="le"><procedure>le</procedure></A> (u: U;  t: ZType) =
  (* s1.I := (s1.t &lt;= s0.t) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;le&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    condset(u, Cond.LE, t);
  END le;

PROCEDURE <A NAME="add"><procedure>add</procedure></A> (u: U;  t: AType) =
  (* s1.t := s1.t + s0.t ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;add&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
      u.cg.binFOp(FOp.fADDP, 1);
      u.vstack.discard(1);
    ELSE
      EVAL u.vstack.dobin(Op.oADD, TRUE, TRUE);
    END
  END add;

PROCEDURE <A NAME="subtract"><procedure>subtract</procedure></A> (u: U;  t: AType) =
  (* s1.t := s1.t - s0.t ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;subtract&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
      u.cg.binFOp(FOp.fSUBP, 1);
      u.vstack.discard(1);
    ELSE
      EVAL u.vstack.dobin(Op.oSUB, FALSE, TRUE);
    END
  END subtract;

PROCEDURE <A NAME="multiply"><procedure>multiply</procedure></A> (u: U;  t: AType) =
  (* s1.t := s1.t * s0.t ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;multiply&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
      u.cg.binFOp(FOp.fMUL, 1);
      u.vstack.discard(1);
    ELSE
      IF t = Type.Int THEN
        u.vstack.doimul();
      ELSE
        u.vstack.doumul();
      END
    END;
  END multiply;

PROCEDURE <A NAME="divide"><procedure>divide</procedure></A> (u: U;  t: RType) =
  (* s1.t := s1.t / s0.t ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;divide&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.cg.binFOp(FOp.fDIV, 1);
    u.vstack.discard(1);
  END divide;

CONST SignName = ARRAY Sign OF TEXT { &quot; P&quot;, &quot; N&quot;, &quot; X&quot; };

PROCEDURE <A NAME="div"><procedure>div</procedure></A> (u: U;  t: IType;  a, b: Sign) =
  (* s1.t := s1.t DIV s0.t ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;div&quot;);
      u.wr.TName (t);
      u.wr.OutT  (SignName [a]);
      u.wr.OutT  (SignName [b]);
      u.wr.NL    ();
    END;

    IF t = Type.Word THEN
      a := Sign.Positive;
      b := Sign.Positive;
    END;

    u.vstack.dodiv(a, b);
  END div;

PROCEDURE <A NAME="mod"><procedure>mod</procedure></A> (u: U;  t: IType;  a, b: Sign) =
  (* s1.t := s1.t MOD s0.t ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;mod&quot;);
      u.wr.TName (t);
      u.wr.OutT  (SignName [a]);
      u.wr.OutT  (SignName [b]);
      u.wr.NL    ();
    END;

    IF t = Type.Word THEN
      a := Sign.Positive;
      b := Sign.Positive;
    END;

    u.vstack.domod(a, b);
  END mod;

PROCEDURE <A NAME="negate"><procedure>negate</procedure></A> (u: U;  t: AType) =
  (* s0.t := - s0.t *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;negate&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
      u.cg.noargFOp(FOp.fCHS);
    ELSE
      u.vstack.doneg();
    END
  END negate;

PROCEDURE <A NAME="abs"><procedure>abs</procedure></A>      (u: U;  t: AType) =
  (* s0.t := ABS (s0.t) (noop on Words) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;abs&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    CASE t OF
      Type.Word =&gt;
    | Type.Int =&gt; u.vstack.doabs();
    ELSE
      u.cg.noargFOp(FOp.fABS);
    END
  END abs;

PROCEDURE <A NAME="max"><procedure>max</procedure></A>      (u: U;  t: ZType) =
  (* s1.t := MAX (s1.t, s0.t) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;max&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.domaxmin(t, MaxMin.Max);
  END max;

PROCEDURE <A NAME="min"><procedure>min</procedure></A>      (u: U;  t: ZType) =
  (* s1.t := MIN (s1.t, s0.t) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;min&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.domaxmin(t, MaxMin.Min);
  END min;

PROCEDURE <A NAME="round"><procedure>round</procedure></A>    (u: U;  t: RType) =
  (* s0.I := ROUND (s0.t) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;round&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.fltoint(FlToInt.Round);
  END round;

PROCEDURE <A NAME="trunc"><procedure>trunc</procedure></A>    (u: U;  t: RType) =
  (* s0.I := TRUNC (s0.t) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;trunc&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.fltoint(FlToInt.Truncate);
  END trunc;

PROCEDURE <A NAME="floor"><procedure>floor</procedure></A>    (u: U;  t: RType) =
  (* s0.I := FLOOR (s0.t) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;floor&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.fltoint(FlToInt.Floor);
  END floor;

PROCEDURE <A NAME="ceiling"><procedure>ceiling</procedure></A>  (u: U;  t: RType) =
  (* s0.I := CEILING (s0.t) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;ceiling&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.fltoint(FlToInt.Ceiling);
  END ceiling;

PROCEDURE <A NAME="cvt_float"><procedure>cvt_float</procedure></A> (u: U;  t: AType;  x: RType) =
  (* s0.x := FLOAT (s0.t, x) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;cvt_float&quot;);
      u.wr.TName (t);
      u.wr.TName (x);
      u.wr.NL    ();
    END;

    IF t &gt;= Type.Reel THEN
      RETURN;
    END;

    u.vstack.inttoflt();
  END cvt_float;
</PRE>------------------------------------------------------------------ sets ---

<P><PRE>TYPE SetProc =
  {  union, difference, intersection, sym_difference,
     range,
     eq, ne, lt, le, gt, ge,
     member,
     singleton  };
</PRE> union .. sym_difference -&gt; (n_bits, *c, *b, *a): Void
   range                   -&gt; (b, a, *s): Void
   eq .. ge                -&gt; (n_bits, *b, *a): Int
   member                  -&gt; (elt, *set): Int
   singleton               -&gt; (a, *s): Void 

<P><PRE>PROCEDURE <A NAME="set_proc"><procedure>set_proc</procedure></A> (u: U; s: ByteSize; proc: SetProc) =
  BEGIN
    start_int_proc(u, u.set_procs[proc]);

    CASE proc OF
      SetProc.union .. SetProc.sym_difference =&gt;
        load_stack_param(u, Type.Addr, 2);
        load_stack_param(u, Type.Addr, 1);
        pop_param(u, Type.Addr);
        u.vstack.discard(2);
    | SetProc.range =&gt;
        load_stack_param(u, Type.Addr, 2);
        load_stack_param(u, Type.Int, 1);
        pop_param(u, Type.Int);
        u.vstack.discard(2);
    | SetProc.eq .. SetProc.ge =&gt;
        u.vstack.swap();
        pop_param(u, Type.Addr);
        pop_param(u, Type.Addr);
    | SetProc.member .. SetProc.singleton =&gt;
        u.vstack.swap();
        pop_param(u, Type.Int);
        pop_param(u, Type.Int);
    END;

    IF proc &lt;= SetProc.ge AND proc # SetProc.range THEN
      u.vstack.pushimm(s * 8);
      pop_param(u, Type.Int);
    END;

    call_direct(u, u.set_procs[proc].proc, u.set_procs[proc].ret_type);
  END set_proc;

PROCEDURE <A NAME="set_union"><procedure>set_union</procedure></A> (u: U;  s: ByteSize) =
  (* s1.B := s1.B + s0.B ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_union&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.union);
  END set_union;

PROCEDURE <A NAME="set_difference"><procedure>set_difference</procedure></A> (u: U;  s: ByteSize) =
  (* s1.B := s1.B - s0.B ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_difference&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.difference);
  END set_difference;

PROCEDURE <A NAME="set_intersection"><procedure>set_intersection</procedure></A> (u: U;  s: ByteSize) =
  (* s1.B := s1.B * s0.B ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_intersection&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.intersection);
  END set_intersection;

PROCEDURE <A NAME="set_sym_difference"><procedure>set_sym_difference</procedure></A> (u: U;  s: ByteSize) =
  (* s1.B := s1.B / s0.B ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_sym_difference&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.sym_difference);
  END set_sym_difference;

PROCEDURE <A NAME="set_member"><procedure>set_member</procedure></A>       (u: U;  s: ByteSize) =
  (* s1.I := (s0.I IN s1.B) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_member&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.member);
  END set_member;

PROCEDURE <A NAME="set_eq"><procedure>set_eq</procedure></A>       (u: U;  s: ByteSize) =
  (* s1.I := (s1.B = s0.B)  ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_eq&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.eq);
  END set_eq;

PROCEDURE <A NAME="set_ne"><procedure>set_ne</procedure></A> (u: U;  s: ByteSize) =
  (* s1.I := (s1.B # s0.B)  ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_ne&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.ne);
  END set_ne;

PROCEDURE <A NAME="set_gt"><procedure>set_gt</procedure></A> (u: U;  s: ByteSize) =
  (* s1.I := (s1.B &gt; s0.B)  ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_gt&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.gt);
  END set_gt;

PROCEDURE <A NAME="set_ge"><procedure>set_ge</procedure></A> (u: U;  s: ByteSize) =
  (* s1.I := (s1.B &gt;= s0.B) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_ge&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.ge);
  END set_ge;

PROCEDURE <A NAME="set_lt"><procedure>set_lt</procedure></A> (u: U;  s: ByteSize) =
  (* s1.I := (s1.B &lt; s0.B)  ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_lt&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.lt);
  END set_lt;

PROCEDURE <A NAME="set_le"><procedure>set_le</procedure></A> (u: U;  s: ByteSize) =
  (* s1.I := (s1.B &lt;= s0.B) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_le&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.le);
  END set_le;

PROCEDURE <A NAME="set_range"><procedure>set_range</procedure></A> (u: U;  s: ByteSize) =
  (* s2.A [s1.I .. s0.I] := 1's; pop(3)*)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_range&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.range);
  END set_range;

PROCEDURE <A NAME="set_singleton"><procedure>set_singleton</procedure></A> (u: U;  s: ByteSize) =
  (* s1.A [s0.I] := 1; pop(2) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;set_singleton&quot;);
      u.wr.Int   (s);
      u.wr.NL    ();
    END;

    set_proc(u, s, SetProc.singleton);
  END set_singleton;
</PRE>------------------------------------------------- Word.T bit operations ---

<P><PRE>PROCEDURE <A NAME="not"><procedure>not</procedure></A> (u: U) =
  (* s0.I := Word.Not (s0.I) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;not&quot;);
      u.wr.TName (Type.Int);
      u.wr.NL    ();
    END;

    WITH stack0 = u.vstack.pos(0, &quot;not&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        u.vstack.set_imm(stack0, Word.Not (u.vstack.op(stack0).imm));
      ELSE
        u.vstack.unlock();
        u.vstack.find(stack0, Force.anytemp);
        u.cg.unOp(Op.oNOT, u.vstack.op(stack0));
        u.vstack.newdest(u.vstack.op(stack0));
      END
    END
  END not;

PROCEDURE <A NAME="and"><procedure>and</procedure></A> (u: U) =
  (* s1.I := Word.And (s1.I, s0.I) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;and&quot;);
      u.wr.TName (Type.Int);
      u.wr.NL    ();
    END;

    EVAL u.vstack.dobin(Op.oAND, TRUE, TRUE);
  END and;

PROCEDURE <A NAME="or"><procedure>or</procedure></A>  (u: U) =
  (* s1.I := Word.Or  (s1.I, s0.I) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;or&quot;);
      u.wr.TName (Type.Int);
      u.wr.NL    ();
    END;

    EVAL u.vstack.dobin(Op.oOR, TRUE, TRUE);
  END or;

PROCEDURE <A NAME="xor"><procedure>xor</procedure></A> (u: U) =
  (* s1.I := Word.Xor (s1.I, s0.I) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;xor&quot;);
      u.wr.TName (Type.Int);
      u.wr.NL    ();
    END;

    EVAL u.vstack.dobin(Op.oXOR, TRUE, TRUE);
  END xor;

PROCEDURE <A NAME="shift"><procedure>shift</procedure></A>        (u: U) =
  (* s1.I := Word.Shift  (s1.I, s0.I) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;shift&quot;);
      u.wr.TName (Type.Int);
      u.wr.NL    ();
    END;

    u.vstack.doshift();
  END shift;

PROCEDURE <A NAME="shift_left"><procedure>shift_left</procedure></A>   (u: U) =
  (* s1.I := Word.Shift  (s1.I, s0.I) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;shift_left&quot;);
      u.wr.TName (Type.Int);
      u.wr.NL    ();
    END;

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;shift_left&quot;),
         stack1 = u.vstack.pos(1, &quot;shift_left&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        IF u.vstack.loc(stack1) = OLoc.imm THEN
          u.vstack.set_imm(stack1, Word.Shift(u.vstack.op(stack1).imm,
                                              u.vstack.op(stack0).imm));
        ELSE
          u.vstack.find(stack1, Force.anytemp);
          u.vstack.set_imm(stack0, Word.And(u.vstack.op(stack0).imm, 16_1F));
          u.cg.immOp(Op.oSAL, u.vstack.op(stack1), u.vstack.op(stack0).imm);
          u.vstack.newdest(u.vstack.op(stack1));
        END
      ELSE
        u.vstack.find(stack0, Force.regset, RegSet {Codex86.ECX});
        u.vstack.find(stack1, Force.anytemp);

        IF u.vstack.loc(stack1) = OLoc.imm THEN
          u.vstack.find(stack1, Force.anyreg);
        END;

        u.cg.unOp(Op.oSAL, u.vstack.op(stack1));
        u.vstack.newdest(u.vstack.op(stack1));
      END;

      u.vstack.discard(1);
    END
  END shift_left;

PROCEDURE <A NAME="shift_right"><procedure>shift_right</procedure></A>  (u: U) =
  (* s1.I := Word.Shift  (s1.I, -s0.I) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;shift_right&quot;);
      u.wr.TName (Type.Int);
      u.wr.NL    ();
    END;

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;shift_right&quot;),
         stack1 = u.vstack.pos(1, &quot;shift_right&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        IF u.vstack.loc(stack1) = OLoc.imm THEN
          u.vstack.set_imm(stack1, Word.Shift(u.vstack.op(stack1).imm,
                                              -u.vstack.op(stack0).imm));
        ELSE
          u.vstack.find(stack1, Force.anytemp);
          u.vstack.set_imm(stack0, Word.And(u.vstack.op(stack0).imm, 16_1F));
          u.cg.immOp(Op.oSHR, u.vstack.op(stack1), u.vstack.op(stack0).imm);
          u.vstack.newdest(u.vstack.op(stack1));
        END
      ELSE
        u.vstack.find(stack0, Force.regset, RegSet {Codex86.ECX});
        u.vstack.find(stack1, Force.anytemp);

        IF u.vstack.loc(stack1) = OLoc.imm THEN
          u.vstack.find(stack1, Force.anyreg);
        END;

        u.cg.unOp(Op.oSHR, u.vstack.op(stack1));
        u.vstack.newdest(u.vstack.op(stack1));
      END;

      u.vstack.discard(1);
    END
  END shift_right;

PROCEDURE <A NAME="rotate"><procedure>rotate</procedure></A>       (u: U) =
  (* s1.I := Word.Rotate (s1.I, s0.I) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;rotate&quot;);
      u.wr.TName (Type.Int);
      u.wr.NL    ();
    END;

    u.vstack.dorotate();
  END rotate;

PROCEDURE <A NAME="rotate_left"><procedure>rotate_left</procedure></A>  (u: U) =
  (* s1.I := Word.Rotate (s1.I, s0.I) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;rotate_left&quot;);
      u.wr.TName (Type.Int);
      u.wr.NL    ();
    END;

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;rotate_left&quot;),
         stack1 = u.vstack.pos(1, &quot;rotate_left&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        IF u.vstack.loc(stack1) = OLoc.imm THEN
          u.vstack.set_imm(stack1, Word.Rotate(u.vstack.op(stack1).imm,
                                               u.vstack.op(stack0).imm));
        ELSE
          u.vstack.find(stack1, Force.anytemp);
          u.vstack.set_imm(stack0, Word.And(u.vstack.op(stack0).imm, 16_1F));
          u.cg.immOp(Op.oROL, u.vstack.op(stack1), u.vstack.op(stack0).imm);
          u.vstack.newdest(u.vstack.op(stack1));
        END
      ELSE
        u.vstack.find(stack0, Force.regset, RegSet {Codex86.ECX});
        u.vstack.find(stack1, Force.anytemp);

        IF u.vstack.loc(stack1) = OLoc.imm THEN
          u.vstack.find(stack1, Force.anyreg);
        END;

        u.cg.unOp(Op.oROL, u.vstack.op(stack1));
        u.vstack.newdest(u.vstack.op(stack1));
      END;

      u.vstack.discard(1);
    END
  END rotate_left;

PROCEDURE <A NAME="rotate_right"><procedure>rotate_right</procedure></A> (u: U) =
  (* s1.I := Word.Rotate (s1.I, -s0.I) ; pop *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;rotate_right&quot;);
      u.wr.TName (Type.Int);
      u.wr.NL    ();
    END;

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;rotate_right&quot;),
         stack1 = u.vstack.pos(1, &quot;rotate_right&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        IF u.vstack.loc(stack1) = OLoc.imm THEN
          u.vstack.set_imm(stack1, Word.Rotate(u.vstack.op(stack1).imm,
                                               -u.vstack.op(stack0).imm));
        ELSE
          u.vstack.find(stack1, Force.anytemp);
          u.vstack.set_imm(stack0, Word.And(u.vstack.op(stack0).imm, 16_1F));
          u.cg.immOp(Op.oROR, u.vstack.op(stack1), u.vstack.op(stack0).imm);
          u.vstack.newdest(u.vstack.op(stack1));
        END
      ELSE
        u.vstack.find(stack0, Force.regset, RegSet {Codex86.ECX});
        u.vstack.find(stack1, Force.anytemp);

        IF u.vstack.loc(stack1) = OLoc.imm THEN
          u.vstack.find(stack1, Force.anyreg);
        END;

        u.cg.unOp(Op.oROR, u.vstack.op(stack1));
        u.vstack.newdest(u.vstack.op(stack1));
      END;

      u.vstack.discard(1);
    END
  END rotate_right;

PROCEDURE <A NAME="extract"><procedure>extract</procedure></A> (u: U;  sign: BOOLEAN) =
  (* s2.I := Word.Extract(s2.I, s1.I, s0.I);
     IF sign THEN SignExtend s2 END; pop(2) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;extract&quot;);
      u.wr.Bool  (sign);
      u.wr.NL    ();
    END;

    u.vstack.doextract(sign);
  END extract;

PROCEDURE <A NAME="extract_n"><procedure>extract_n</procedure></A> (u: U;  sign: BOOLEAN;  n: INTEGER) =
  (* s1.I := Word.Extract(s1.I, s0.I, n);
     IF sign THEN SignExtend s1 END; pop(1) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;extract_n&quot;);
      u.wr.Bool  (sign);
      u.wr.Int   (n);
      u.wr.NL    ();
    END;

    u.vstack.doextract_n(sign, n);
  END extract_n;

PROCEDURE <A NAME="extract_mn"><procedure>extract_mn</procedure></A> (u: U;  sign: BOOLEAN;  m, n: INTEGER) =
  (* s0.I := Word.Extract(s0.I, m, n);
     IF sign THEN SignExtend s0 END; *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;extract_mn&quot;);
      u.wr.Bool  (sign);
      u.wr.Int   (m);
      u.wr.Int   (n);
      u.wr.NL    ();
    END;

    u.vstack.doextract_mn(sign, m, n);
  END extract_mn;

PROCEDURE <A NAME="insert"><procedure>insert</procedure></A>  (u: U) =
  (* s3.I := Word.Insert (s3.I, s2.I, s1.I, s0.I) ; pop(3) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;insert&quot;);
      u.wr.NL    ();
    END;

    u.vstack.doinsert();
  END insert;

PROCEDURE <A NAME="insert_n"><procedure>insert_n</procedure></A>  (u: U;  n: INTEGER) =
  (* s2.I := Word.Insert (s2.I, s1.I, s0.I, n) ; pop(2) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;insert_n&quot;);
      u.wr.Int   (n);
      u.wr.NL    ();
    END;

    u.vstack.doinsert_n(n);
  END insert_n;

PROCEDURE <A NAME="insert_mn"><procedure>insert_mn</procedure></A>  (u: U;  m, n: INTEGER) =
  (* s1.I := Word.Insert (s1.I, s0.I, m, n) ; pop(2) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;insert_mn&quot;);
      u.wr.Int   (m);
      u.wr.Int   (n);
      u.wr.NL    ();
    END;

    u.vstack.doinsert_mn(m, n);
  END insert_mn;
</PRE>------------------------------------------------ misc. stack/memory ops ---

<P><PRE>PROCEDURE <A NAME="swap"><procedure>swap</procedure></A> (u: U;  a, b: Type) =
  (* tmp := s1 ; s1 := s0 ; s0 := tmp *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;swap&quot;);
      u.wr.TName (a);
      u.wr.TName (b);
      u.wr.NL    ();
    END;

    u.vstack.swap();
  END swap;

PROCEDURE <A NAME="pop"><procedure>pop</procedure></A> (u: U;  t: Type) =
  (* pop(1) (i.e. discard s0) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;pop&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    u.vstack.unlock();
    IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
      WITH stack0 = u.vstack.pos(0, &quot;pop&quot;) DO
        &lt;* ASSERT u.vstack.loc(stack0) = OLoc.fstack *&gt;
        u.cg.fstack_discard();
      END
    END;

    u.vstack.discard(1);
  END pop;

PROCEDURE <A NAME="copy_n"><procedure>copy_n</procedure></A> (u: U;  t: MType;  overlap: BOOLEAN) =
  (* Mem[s2.A:s0.I] := Mem[s1.A:s0.I]; pop(3)*)
  VAR shift, n: INTEGER;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;copy_n&quot;);
      u.wr.TName (t);
      u.wr.Bool  (overlap);
      u.wr.NL    ();
    END;

    WITH stack0 = u.vstack.pos(0, &quot;copy_n&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        n := u.vstack.op(stack0).imm;
        u.vstack.discard(1);
        copy(u, n, t, overlap);
        RETURN;
      END
    END;

    IF CG_Bytes[t] # 1 THEN
      WITH stack0 = u.vstack.pos(0, &quot;copy_n&quot;) DO
        u.vstack.unlock();

        CASE CG_Bytes[t] OF
          2 =&gt; shift := 1;
        | 4 =&gt; shift := 2;
        | 8 =&gt; shift := 3;
        ELSE
          u.Err(&quot;Unknown MType size in copy_n&quot;);
        END;

        u.vstack.find(stack0, Force.anyreg);

        u.cg.immOp(Op.oSAL, u.vstack.op(stack0), shift);
      END
    END;

    IF overlap THEN
      start_int_proc(u, u.memmoveproc);
    ELSE
      start_int_proc(u, u.memcpyproc);
    END;

    pop_param(u, Type.Int);
    pop_param(u, Type.Addr);
    pop_param(u, Type.Addr);

    IF overlap THEN
      call_direct(u, u.memmoveproc.proc, Type.Addr);
    ELSE
      call_direct(u, u.memcpyproc.proc, Type.Addr);
    END;

    u.vstack.discard(1);
  END copy_n;

CONST MAXINLINECOPY = 8;

CONST faketype = ARRAY [1 .. 4] OF MType
  { Type.Word_A, Type.Word_B, Type.Word, Type.Word };

PROCEDURE <A NAME="inline_copy"><procedure>inline_copy</procedure></A> (u: U; n, size: INTEGER; forward: BOOLEAN) =
  VAR start, end, step: INTEGER;
      movereg: Regno;
  BEGIN
    IF forward THEN
      start := 0; end := n - 1; step := 1;
    ELSE
      start := n - 1; end := 0; step := -1;
    END;

    movereg := u.vstack.freereg();

    WITH stop0 = u.vstack.op(u.vstack.pos(0, &quot;inline_copy&quot;)),
         stop1 = u.vstack.op(u.vstack.pos(1, &quot;inline_copy&quot;)) DO
      FOR i := start TO end BY step DO
        u.cg.fast_load_ind(movereg, stop0, i * size, size);
        u.cg.store_ind(u.cg.reg[movereg], stop1, i * size, faketype[size]);
      END
    END
  END inline_copy;

PROCEDURE <A NAME="string_copy"><procedure>string_copy</procedure></A> (u: U; n, size: INTEGER; forward: BOOLEAN) =
  BEGIN
    u.vstack.corrupt(Codex86.ECX);
    u.cg.movImm(u.cg.reg[Codex86.ECX], n);

    IF forward THEN
      u.cg.noargOp(Op.oCLD);
    ELSE
      u.cg.immOp(Op.oADD, u.cg.reg[Codex86.ESI], (n - 1) * size);
      u.cg.immOp(Op.oADD, u.cg.reg[Codex86.EDI], (n - 1) * size);
      u.cg.noargOp(Op.oSTD);
    END;

    u.cg.noargOp(Op.oREP);
    CASE size OF
      1 =&gt; u.cg.noargOp(Op.oMOVSB);
    | 2 =&gt; u.cg.MOVSWOp();
    | 4 =&gt; u.cg.noargOp(Op.oMOVSD);
    ELSE
      u.Err(&quot;Illegal size in copy&quot;);
    END;

    IF NOT forward THEN
      u.cg.noargOp(Op.oCLD);
    END
  END string_copy;

PROCEDURE <A NAME="copy"><procedure>copy</procedure></A> (u: U;  n: INTEGER;  t: MType;  overlap: BOOLEAN) =
  (* Mem[s1.A:sz] := Mem[s0.A:sz]; pop(2)*)
  VAR size := CG_Bytes[t];
      forward, end: Label;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;copy&quot;);
      u.wr.Int   (n);
      u.wr.TName (t);
      u.wr.Bool  (overlap);
      u.wr.NL    ();
    END;

    IF size = 1 AND Word.And(n, 3) = 0 THEN
      n := Word.Shift(n, -2);
      size := 4;
    END;

    IF size = 2 AND Word.And(n, 1) = 0 THEN
      n := Word.Shift(n, -1);
      size := 4;
    END;

    IF size = 8 THEN
      n := Word.Shift(n, 1);
      size := 4;
    END;

    u.vstack.unlock();

    WITH stack0 = u.vstack.pos(0, &quot;copy&quot;), stack1 = u.vstack.pos(1, &quot;copy&quot;) DO
      IF n &gt; MAXINLINECOPY THEN
        u.vstack.find(stack0, Force.regset, RegSet { Codex86.ESI } );
        u.vstack.find(stack1, Force.regset, RegSet { Codex86.EDI } );
      ELSE
        u.vstack.find(stack0, Force.anyreg, RegSet {}, TRUE);
        u.vstack.find(stack1, Force.anyreg, RegSet {}, TRUE);
      END
    END;

    IF overlap AND n &gt; 1 THEN
      forward := u.cg.reserve_labels(1, TRUE);
      end := u.cg.reserve_labels(1, TRUE);
      u.cg.binOp(Op.oCMP, u.cg.reg[Codex86.ESI], u.cg.reg[Codex86.EDI]);
      u.cg.brOp(Cond.GE, forward);

      IF n &lt;= MAXINLINECOPY THEN
        inline_copy(u, n, size, FALSE);
      ELSE
        string_copy(u, n, size, FALSE);
      END;

      u.cg.brOp(Cond.Always, end);
      u.cg.set_label(forward);
    END;

    IF n &lt;= MAXINLINECOPY THEN
      inline_copy(u, n, size, TRUE);
    ELSE
      string_copy(u, n, size, TRUE);
    END;

    IF overlap AND n &gt; 1 THEN
      u.cg.set_label(end);
    END;

    IF n &gt; MAXINLINECOPY THEN
      u.vstack.newdest(u.cg.reg[Codex86.ESI]);
      u.vstack.newdest(u.cg.reg[Codex86.EDI]);
    END;

    u.vstack.discard(2);
  END copy;

PROCEDURE <A NAME="zero_n"><procedure>zero_n</procedure></A> (u: U;  t: MType) =
  (* Mem[s1.A:s0.I] := 0; pop(2) *)
  VAR shift, n: INTEGER;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;zero_n&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    WITH stack0 = u.vstack.pos(0, &quot;zero_n&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        n := u.vstack.op(stack0).imm;
        u.vstack.discard(1);
        zero(u, n, t);
        RETURN;
      END
    END;

    IF CG_Bytes[t] # 1 THEN
      WITH stack0 = u.vstack.pos(0, &quot;zero_n&quot;) DO
        u.vstack.unlock();
        u.vstack.find(stack0, Force.anyreg);

        CASE CG_Bytes[t] OF
          2 =&gt; shift := 1;
        | 4 =&gt; shift := 2;
        | 8 =&gt; shift := 3;
        ELSE
          u.Err(&quot;Unknown MType size in zero_n&quot;);
        END;

        u.cg.immOp(Op.oSAL, u.vstack.op(stack0), shift);
      END
    END;

    start_int_proc(u, u.memsetproc);

    pop_param(u, Type.Int);

    u.vstack.pushimm(0);
    pop_param(u, Type.Int);

    pop_param(u, Type.Addr);

    call_direct(u, u.memsetproc.proc, Type.Addr);

    u.vstack.discard(1);
  END zero_n;

PROCEDURE <A NAME="zero"><procedure>zero</procedure></A> (u: U;  n: INTEGER;  t: MType) =
  (* Mem[s0.A:sz] := 0; pop(1) *)
  VAR size := CG_Bytes[t];
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;zero&quot;);
      u.wr.Int   (n);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    IF size = 1 AND Word.And(n, 3) = 0 THEN
      n := Word.Shift(n, -2);
      size := 4;
    END;

    IF size = 2 AND Word.And(n, 1) = 0 THEN
      n := Word.Shift(n, -1);
      size := 4;
    END;

    IF size = 8 THEN
      n := Word.Shift(n, 1);
      size := 4;
    END;

    u.vstack.unlock();

    IF n &gt; MAXINLINECOPY THEN
      u.vstack.find(u.vstack.pos(0, &quot;zero&quot;), Force.regset,
                    RegSet { Codex86.EDI } );
      u.vstack.corrupt(Codex86.EAX);
      u.vstack.corrupt(Codex86.ECX);

      u.cg.binOp(Op.oXOR, u.cg.reg[Codex86.EAX], u.cg.reg[Codex86.EAX]);
      u.cg.movImm(u.cg.reg[Codex86.ECX], n);

      u.cg.noargOp(Op.oCLD);
      u.cg.noargOp(Op.oREP);
      CASE size OF
        1 =&gt; u.cg.noargOp(Op.oSTOSB);
      | 2 =&gt; u.cg.STOSWOp();
      | 4 =&gt; u.cg.noargOp(Op.oSTOSD);
      ELSE
             u.Err(&quot;Illegal size in zero&quot;);
      END;
      u.vstack.newdest(u.cg.reg[Codex86.EDI]);

    ELSE
      WITH stack0 = u.vstack.pos(0, &quot;zero&quot;), stop0 = u.vstack.op(stack0) DO
        u.vstack.find(stack0, Force.anyreg, RegSet {}, TRUE);
        FOR i := 0 TO n - 1 DO
          u.cg.store_ind(Operand { loc := OLoc.imm, imm := 0 },
                         stop0, i * size, faketype[size]);
        END
      END
    END;

    u.vstack.discard(1);
  END zero;

PROCEDURE <A NAME="start_int_proc"><procedure>start_int_proc</procedure></A>(u: U; VAR internal: IntProc) =
  BEGIN
    IF NOT internal.used THEN
      internal.proc := import_procedure(u, M3ID.Add(internal.name),
                                        internal.n_params,
                                        internal.ret_type,
                                        Target.FindConvention (internal.lang));
      FOR i := 1 TO internal.n_params DO
        EVAL declare_param(u, M3ID.NoID, 4, 4, Type.Addr, 0, FALSE, FALSE,
                           100);
      END;

      internal.used := TRUE;
    END;

    start_call_direct(u, internal.proc, 0, internal.ret_type);
  END start_int_proc;

TYPE IntProc = RECORD
  used: BOOLEAN;
  proc: x86Proc;
  name: TEXT;
  n_params: INTEGER;
  ret_type: Type;
  lang: TEXT;
END;
</PRE>----------------------------------------------------------- conversions ---

<P><PRE>PROCEDURE <A NAME="loophole"><procedure>loophole</procedure></A> (u: U;  from, two: ZType) =
  (* s0.to := LOOPHOLE(s0.from, to) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;loophole&quot;);
      u.wr.TName (from);
      u.wr.TName (two);
      u.wr.NL    ();
    END;

    u.vstack.doloophole(from, two);

  END loophole;
</PRE>------------------------------------------------ traps &amp; runtime checks ---

<P><PRE>PROCEDURE <A NAME="assert_fault"><procedure>assert_fault</procedure></A> (u: U) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;assert_fault&quot;);
      u.wr.NL    ();
    END;

    reportfault(u, 0);
  END assert_fault;

PROCEDURE <A NAME="narrow_fault"><procedure>narrow_fault</procedure></A> (u: U) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;narrow_fault&quot;);
      u.wr.NL    ();
    END;

    reportfault(u, 5);
  END narrow_fault;

PROCEDURE <A NAME="return_fault"><procedure>return_fault</procedure></A> (u: U) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;return_fault&quot;);
      u.wr.NL    ();
    END;

    reportfault(u, 6);
  END return_fault;

PROCEDURE <A NAME="case_fault"><procedure>case_fault</procedure></A> (u: U) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;case_fault&quot;);
      u.wr.NL    ();
    END;

    reportfault(u, 7);
  END case_fault;

PROCEDURE <A NAME="typecase_fault"><procedure>typecase_fault</procedure></A> (u: U) =
  (* Abort *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;typecase_fault&quot;);
      u.wr.NL    ();
    END;

    reportfault(u, 8);
  END typecase_fault;

PROCEDURE <A NAME="reportfault"><procedure>reportfault</procedure></A> (u: U; info: INTEGER) =
  BEGIN
    info := info + u.lineno * 16;
    u.cg.movImm(u.cg.reg[Codex86.EAX], info);
    u.cg.intCall(u.reportlabel);

    u.usedfault := TRUE;
  END reportfault;

PROCEDURE <A NAME="makereportproc"><procedure>makereportproc</procedure></A> (u: U) =
  VAR
    repfault     : Var;
    repfoff      : ByteOffset;
    labelname    : TEXT;
    reportsymbol : INTEGER;
  BEGIN
    &lt;* ASSERT u.rfault_name # 0 *&gt;

    get_runtime_hook(u, u.rfault_name, repfault, repfoff);

    u.cg.set_label(u.reportlabel);

    labelname := M3ID.ToText (u.global_var.name) &amp; &quot;_CRASH&quot;;

    reportsymbol := u.obj.define_symbol(M3ID.Add(labelname), Seg.Text,
                                        u.obj.cursor(Seg.Text));
    u.obj.begin_procedure(reportsymbol);

    u.cg.pushOp(u.cg.reg[Codex86.EBP]);
    u.cg.movOp(u.cg.reg[Codex86.EBP], u.cg.reg[Codex86.ESP]);

    u.cg.pushOp(u.cg.reg[Codex86.EAX]);

    load_address(u, u.global_var, 0);

    INC(u.in_proc_call);

    pop_param(u, Type.Addr);

    DEC(u.in_proc_call);

    load(u, repfault, repfoff, Type.Addr);

    u.cg.rmCall(u.vstack.op(u.vstack.pos(0, &quot;makereportproc&quot;)));

    u.obj.end_procedure(reportsymbol);
  END makereportproc;

PROCEDURE <A NAME="check_nil"><procedure>check_nil</procedure></A> (u: U) =
  (* IF (s0.A = NIL) THEN Abort *)
  VAR safelab: Label;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;check_nil&quot;);
      u.wr.NL    ();
    END;

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;check_nil&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        IF u.vstack.op(stack0).imm = 0 THEN
          reportfault(u, 4);
        END
      ELSE
        u.vstack.find(stack0, Force.any, RegSet {}, TRUE);

        IF NOT u.vstack.non_nil(u.vstack.reg(stack0)) THEN
          u.cg.immOp(Op.oCMP, u.vstack.op(stack0), 0);

          safelab := u.cg.reserve_labels(1, TRUE);

          u.cg.brOp(Cond.NE, safelab);

          reportfault(u, 4);

          u.cg.set_label(safelab);
        END;

        u.vstack.set_non_nil(u.vstack.reg(stack0));
      END
    END
  END check_nil;

PROCEDURE <A NAME="check_lo"><procedure>check_lo</procedure></A> (u: U;  READONLY i: Target.Int) =
  (* IF (s0.I &lt; i) THEN Abort *)
  VAR int: INTEGER;
      safelab: Label;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;check_lo&quot;);
      u.wr.TInt (i);
      u.wr.NL    ();
    END;

    EVAL TargetInt.ToInt(i, int);

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;check_lo&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        IF u.vstack.op(stack0).imm &lt; int THEN
          reportfault(u, 1);
        END
      ELSE
        u.vstack.find(stack0, Force.anyreg);
        IF u.vstack.upper(u.vstack.reg(stack0)) AND
           u.vstack.upbound(u.vstack.reg(stack0)) &lt;= int THEN
          reportfault(u, 1);
        ELSIF (NOT u.vstack.lower(u.vstack.reg(stack0))) OR
              u.vstack.lowbound(u.vstack.reg(stack0)) &lt;= int THEN

          u.cg.immOp(Op.oCMP, u.vstack.op(stack0), int);

          safelab := u.cg.reserve_labels(1, TRUE);

          u.cg.brOp(Cond.GE, safelab);

          reportfault(u, 1);

          u.cg.set_label(safelab);

          u.vstack.set_lower(u.vstack.reg(stack0), int + 1);
        END
      END
    END
  END check_lo;

PROCEDURE <A NAME="check_hi"><procedure>check_hi</procedure></A> (u: U;  READONLY i: Target.Int) =
  (* IF (i &lt; s0.I) THEN Abort *)
  VAR int: INTEGER;
      safelab: Label;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;check_hi&quot;);
      u.wr.TInt (i);
      u.wr.NL    ();
    END;

    EVAL TargetInt.ToInt(i, int);

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;check_hi&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        IF int &lt; u.vstack.op(stack0).imm THEN
          reportfault(u, 1);
        END
      ELSE
        u.vstack.find(stack0, Force.anyreg);
        IF u.vstack.lower(u.vstack.reg(stack0)) AND
           u.vstack.lowbound(u.vstack.reg(stack0)) &gt;= int THEN
          reportfault(u, 1);
        ELSIF (NOT u.vstack.upper(u.vstack.reg(stack0))) OR
              u.vstack.upbound(u.vstack.reg(stack0)) &gt;= int THEN

          u.cg.immOp(Op.oCMP, u.vstack.op(stack0), int);

          safelab := u.cg.reserve_labels(1, TRUE);

          u.cg.brOp(Cond.LE, safelab);

          reportfault(u, 1);

          u.cg.set_label(safelab);

          u.vstack.set_upper(u.vstack.reg(stack0), int - 1);
        END
      END
    END
  END check_hi;

PROCEDURE <A NAME="check_range"><procedure>check_range</procedure></A> (u: U;  READONLY a, b: Target.Int) =
  (* IF (s0.I &lt; a) OR (b &lt; s0.I) THEN Abort *)
  VAR inta, intb: INTEGER;
      safelab, outrange: Label;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;check_range&quot;);
      u.wr.TInt (a);
      u.wr.TInt (b);
      u.wr.NL    ();
    END;

    safelab := u.cg.reserve_labels(1, TRUE);
    outrange := u.cg.reserve_labels(1, TRUE);

    EVAL TargetInt.ToInt(a, inta);
    EVAL TargetInt.ToInt(b, intb);

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;check_range&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        IF u.vstack.op(stack0).imm &lt; inta OR
           intb &lt; u.vstack.op(stack0).imm THEN
          reportfault(u, 2);
          RETURN
        END
      END;

      u.vstack.find(stack0, Force.anyreg);
      WITH reg = u.vstack.reg(stack0) DO
        IF (u.vstack.upper(reg) AND u.vstack.upbound(reg) &lt;= inta) OR
          (u.vstack.lower(reg) AND u.vstack.lowbound(reg) &gt;= intb) THEN
          reportfault(u, 2);
          RETURN;
        ELSIF u.vstack.upper(reg) AND u.vstack.upbound(reg) &lt; intb THEN
          check_lo(u, a);
          RETURN;
        ELSIF u.vstack.lower(reg) AND u.vstack.lowbound(reg) &gt; inta THEN
          check_hi(u, b);
          RETURN;
        END;

        u.cg.immOp(Op.oCMP, u.vstack.op(stack0), inta);

        u.cg.brOp(Cond.L, outrange);

        u.cg.immOp(Op.oCMP, u.vstack.op(stack0), intb);

        u.cg.brOp(Cond.LE, safelab);

        u.cg.set_label(outrange);

        reportfault(u, 2);

        u.cg.set_label(safelab);

        u.vstack.set_upper(reg, intb - 1);
        u.vstack.set_lower(reg, inta + 1);
      END
    END
  END check_range;

PROCEDURE <A NAME="check_index"><procedure>check_index</procedure></A> (u: U) =
  (* IF (s0.W &lt;= s1.W) THEN Abort *)
  VAR safelab: Label;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;check_index&quot;);
      u.wr.NL    ();
    END;

    safelab := u.cg.reserve_labels(1, TRUE);

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;check_index&quot;),
         stack1 = u.vstack.pos(1, &quot;check_index&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm AND
         u.vstack.loc(stack1) = OLoc.imm THEN
        IF Word.LE(u.vstack.op(stack0).imm, u.vstack.op(stack1).imm) THEN
          reportfault(u, 2);
        END
      ELSE

        u.vstack.find(stack0, Force.any);
        u.vstack.find(stack1, Force.anyregimm);
        IF u.vstack.loc(stack0) = OLoc.mem THEN
          u.vstack.find(stack0, Force.anyregimm);
        END;

        IF NOT ((u.vstack.loc(stack0) = OLoc.imm AND
                 u.vstack.loc(stack1) = OLoc.register AND
                 u.vstack.lower(u.vstack.reg(stack1)) AND
                 u.vstack.lowbound(u.vstack.reg(stack1)) &gt;=
                 u.vstack.op(stack0).imm) OR
                (u.vstack.loc(stack1) = OLoc.imm AND
                 u.vstack.loc(stack0) = OLoc.register AND
                 u.vstack.upper(u.vstack.reg(stack0)) AND
                 u.vstack.upbound(u.vstack.reg(stack0)) &lt;=
                 u.vstack.op(stack1).imm)) THEN

          IF u.vstack.loc(stack0) = OLoc.imm THEN
            u.cg.binOp(Op.oCMP, u.vstack.op(stack1), u.vstack.op(stack0));
            u.cg.brOp(Cond.B, safelab);
          ELSE
            u.cg.binOp(Op.oCMP, u.vstack.op(stack0), u.vstack.op(stack1));
            u.cg.brOp(Cond.A, safelab);
          END;

          reportfault(u, 2);

          u.cg.set_label(safelab);

          IF u.vstack.loc(stack0) = OLoc.imm AND
             u.vstack.loc(stack1) = OLoc.register THEN
            u.vstack.set_lower(u.vstack.reg(stack1), u.vstack.op(stack0).imm);
          ELSIF u.vstack.loc(stack1) = OLoc.imm AND
                u.vstack.loc(stack0) = OLoc.register THEN
            u.vstack.set_upper(u.vstack.reg(stack0), u.vstack.op(stack1).imm);
          END
        END
      END
    END;

    u.vstack.discard(1);
  END check_index;

PROCEDURE <A NAME="check_eq"><procedure>check_eq</procedure></A> (u: U) =
  (* IF (s0.I # s1.I) THEN Abort;  Pop (2) *)
  VAR safelab: Label;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;check_eq&quot;);
      u.wr.NL    ();
    END;

    safelab := u.cg.reserve_labels(1, TRUE);

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;check_index&quot;),
         stack1 = u.vstack.pos(1, &quot;check_index&quot;) DO
      u.vstack.find(stack0, Force.any);
      u.vstack.find(stack1, Force.anyregimm);
      IF u.vstack.loc(stack0) = OLoc.mem THEN
        u.vstack.find(stack0, Force.anyregimm);
      END;

      IF u.vstack.loc(stack0) = OLoc.imm THEN
        u.cg.binOp(Op.oCMP, u.vstack.op(stack1), u.vstack.op(stack0));
      ELSE
        u.cg.binOp(Op.oCMP, u.vstack.op(stack0), u.vstack.op(stack1));
      END;

      u.cg.brOp(Cond.E, safelab);

      reportfault(u, 3);

      u.cg.set_label(safelab);
    END;

    u.vstack.discard(2);
  END check_eq;
</PRE>---------------------------------------------------- address arithmetic ---

<P><PRE>PROCEDURE <A NAME="add_offset"><procedure>add_offset</procedure></A> (u: U; i: INTEGER) =
  (* s0.A := s0.A + i *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;add_offset&quot;);
      u.wr.Int   (i);
      u.wr.NL    ();
    END;

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;add_offset&quot;) DO
      IF u.vstack.loc(stack0) = OLoc.imm THEN
        u.vstack.set_imm(stack0, u.vstack.op(stack0).imm + i);
      ELSE
        u.vstack.find(stack0, Force.anytemp, RegSet {}, TRUE);

        u.cg.immOp(Op.oADD, u.vstack.op(stack0), i);

        u.vstack.newdest(u.vstack.op(stack0));
      END
    END
  END add_offset;

PROCEDURE <A NAME="log2"><procedure>log2</procedure></A> (int: INTEGER): INTEGER =
</PRE><BLOCKQUOTE><EM> Return log2(int) if int is a power of 2, -1 if it is 0, otherwise -2 </EM></BLOCKQUOTE><PRE>
  BEGIN
    IF Word.And(int, int-1) # 0 THEN
      RETURN -2;
    END;

    IF int = 0 THEN
      RETURN -1;
    END;

    FOR i := 0 TO 31 DO
      int := Word.Shift(int, -1);
      IF int = 0 THEN
        RETURN i;
      END;
    END;

    RETURN -1;
  END log2;

PROCEDURE <A NAME="index_address"><procedure>index_address</procedure></A> (u: U;  size: INTEGER) =
  (* s1.A := s1.A + s0.I * size ; pop *)
  VAR shift: INTEGER;
      neg := FALSE;
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;index_address&quot;);
      u.wr.Int   (size);
      u.wr.NL    ();
    END;

    IF size = 0 THEN
      u.Err(&quot;size = 0 in index_address&quot;);
    END;

    IF size &lt; 0 THEN
      size := -size;
      neg := TRUE;
    END;

    shift := log2(size);

    u.vstack.doindex_address(shift, size, neg);
  END index_address;
</PRE>------------------------------------------------------- procedure calls ---

<P><PRE>PROCEDURE <A NAME="start_call_direct"><procedure>start_call_direct</procedure></A> (u: U;  p: Proc;  lev: INTEGER;  t: Type) =
  (* begin a procedure call to a procedure at static level 'lev'. *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;start_call_direct&quot;);
      u.wr.PName (p);
      u.wr.Int   (lev);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    &lt;* ASSERT u.in_proc_call &lt; 2 *&gt;

    u.static_link[u.in_proc_call] := NIL;
    u.call_param_size[u.in_proc_call] := 0;
    INC(u.in_proc_call);
  END start_call_direct;

PROCEDURE <A NAME="start_call_indirect"><procedure>start_call_indirect</procedure></A> (u: U;  t: Type;  cc: CallingConvention) =
  (* begin a procedure call to a procedure at static level 'lev'. *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;start_call_indirect&quot;);
      u.wr.TName (t);
      u.wr.Txt   (cc.name);
      u.wr.NL    ();
    END;

    &lt;* ASSERT u.in_proc_call &lt; 2 *&gt;

    u.static_link[u.in_proc_call] := NIL;
    u.call_param_size[u.in_proc_call] := 0;
    INC(u.in_proc_call);
  END start_call_indirect;

PROCEDURE <A NAME="pop_param"><procedure>pop_param</procedure></A> (u: U;  t: ZType) =
  (* pop s0 and make it the &quot;next&quot; paramter in the current call *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;pop_param&quot;);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    &lt;* ASSERT u.in_proc_call &gt; 0 *&gt;

    u.vstack.unlock();
    WITH stack0 = u.vstack.pos(0, &quot;pop_param&quot;) DO
      IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
        IF t = Type.Reel THEN
          u.cg.immOp(Op.oSUB, u.cg.reg[Codex86.ESP], 4);
        ELSE
          u.cg.immOp(Op.oSUB, u.cg.reg[Codex86.ESP], 8);
        END;

        u.cg.f_storeind(u.cg.reg[Codex86.ESP], 0, t);
      ELSE

        u.vstack.find(stack0, Force.anyregimm);
        u.cg.pushOp(u.vstack.op(stack0));
      END
    END;

    u.vstack.discard(1);

    IF CG_Bytes[t] &lt;= 4 THEN
      INC(u.call_param_size[u.in_proc_call-1], 4);
    ELSE
      &lt;* ASSERT CG_Bytes[t] = 8 *&gt;
      INC(u.call_param_size[u.in_proc_call-1], 8);
    END
  END pop_param;

PROCEDURE <A NAME="load_stack_param"><procedure>load_stack_param</procedure></A> (u: U; t: ZType; depth: INTEGER) =
  BEGIN
    u.vstack.unlock();

    &lt;* ASSERT u.in_proc_call &gt; 0 *&gt;

    WITH stack = u.vstack.pos(depth, &quot;load_stack_param&quot;) DO
      &lt;* ASSERT t &lt; Type.Reel *&gt;

      u.vstack.find(stack, Force.anyregimm);
      u.cg.pushOp(u.vstack.op(stack));
    END;

    INC(u.call_param_size[u.in_proc_call-1], 4);
  END load_stack_param;

PROCEDURE <A NAME="pop_struct"><procedure>pop_struct</procedure></A> (u: U;  s: ByteSize;  a: Alignment) =
  (* pop s0 and make it the &quot;next&quot; parameter in the current call *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;pop_struct&quot;);
      u.wr.Int   (s);
      u.wr.Int   (a);
      u.wr.NL    ();
    END;

    &lt;* ASSERT u.in_proc_call &gt; 0 *&gt;

    &lt;* ASSERT a &lt;= 4 *&gt;

    s := Word.And(s + 3, 16_FFFFFFFC);

    u.vstack.unlock();

    WITH stack0 = u.vstack.pos(0, &quot;pop_struct&quot;) DO

      IF s &gt; 32 THEN
        u.cg.immOp(Op.oSUB, u.cg.reg[Codex86.ESP], s);

        u.vstack.find(stack0, Force.regset, RegSet { Codex86.ESI });
        u.vstack.corrupt(Codex86.EDI);
        u.vstack.corrupt(Codex86.ECX);

        u.cg.movOp(u.cg.reg[Codex86.EDI], u.cg.reg[Codex86.ESP]);
        u.cg.movImm(u.cg.reg[Codex86.ECX], s DIV 4);

        u.cg.noargOp(Op.oCLD);
        u.cg.noargOp(Op.oREP);
        u.cg.noargOp(Op.oMOVSD);

        u.vstack.newdest(u.cg.reg[Codex86.ESI]);
      ELSE
        u.vstack.find(stack0, Force.anyreg, RegSet {}, TRUE);

        WITH temp = u.vstack.freereg() DO
          FOR i := 1 TO (s DIV 4) DO
            u.cg.load_ind(temp, u.vstack.op(stack0), s - (i * 4), Type.Int);
            u.cg.pushOp(u.cg.reg[temp]);
          END
        END
      END
    END;

    u.vstack.discard(1);

    INC(u.call_param_size[u.in_proc_call-1], s);
  END pop_struct;

PROCEDURE <A NAME="pop_static_link"><procedure>pop_static_link</procedure></A> (u: U) =
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;pop_static_link&quot;);
      u.wr.NL    ();
    END;

    &lt;* ASSERT u.in_proc_call &gt; 0 *&gt;

    u.static_link[u.in_proc_call-1] := declare_temp(u, 4, 4, Type.Addr, FALSE);

    u.vstack.pop(MVar {var := u.static_link[u.in_proc_call-1],
                       o := 0, t := Type.Addr} );
  END pop_static_link;

PROCEDURE <A NAME="call_direct"><procedure>call_direct</procedure></A> (u: U; p: Proc;  t: Type) =
  VAR realproc := NARROW(p, x86Proc);
  (* call the procedure identified by block b.  The procedure
     returns a value of type t. *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;call_direct&quot;);
      u.wr.PName (p);
      u.wr.TName (t);
      u.wr.NL    ();
    END;

    &lt;* ASSERT u.in_proc_call &gt; 0 *&gt;

    IF realproc.lev # 0 THEN
      load_static_link_toC(u, p);
    END;

    u.vstack.unlock();

    FOR i := 0 TO NRegs DO  (* 12/27/94  -- WKK -- was NRegs-1   *)
      u.vstack.corrupt(i);
    END;

    IF realproc.import THEN
      u.cg.absCall(p);
    ELSE
      IF realproc.bound THEN
        u.cg.relCall(realproc.offset - (u.obj.cursor(Seg.Text) + 5));
      ELSE
        u.cg.relCall(0);
        realproc.usage := NEW(ProcList, loc := u.obj.cursor(Seg.Text) - 4,
                              link := realproc.usage);
      END
    END;

    IF (NOT realproc.stdcall) (* =&gt; caller cleans *)
       AND u.call_param_size[u.in_proc_call-1] &gt; 0 THEN
        u.cg.immOp(Op.oADD, u.cg.reg[Codex86.ESP],
                   u.call_param_size[u.in_proc_call-1]);
    END;

    IF t = Type.Struct THEN
      t := Type.Addr;
    END;

    IF t # Type.Void THEN
      IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
        u.vstack.pushnew(t, Force.any);
        u.cg.f_pushnew();
      ELSE
        u.vstack.pushnew(t, Force.regset, RegSet { Codex86.EAX });
      END
    END;

    DEC(u.in_proc_call);
  END call_direct;

PROCEDURE <A NAME="call_indirect"><procedure>call_indirect</procedure></A> (u: U; t: Type;  cc: CallingConvention) =
  (* call the procedure whose address is in s0.A and pop s0.  The
     procedure returns a value of type t. *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;call_indirect&quot;);
      u.wr.TName (t);
      u.wr.Txt   (cc.name);
      u.wr.NL    ();
    END;

    &lt;* ASSERT u.in_proc_call &gt; 0 *&gt;

    u.vstack.unlock();

    FOR i := 0 TO NRegs DO  (* 12/27/94  -- WKK -- was NRegs-1   *)
      u.vstack.corrupt(i);
    END;

    IF u.static_link[u.in_proc_call-1] # NIL THEN
      u.cg.movOp(u.cg.reg[Codex86.ECX],
                 Operand { loc := OLoc.mem,
                           mvar :=
                             MVar { var := u.static_link[u.in_proc_call-1],
                                    o := 0,
                                    t := Type.Addr } } );
      free_temp(u, u.static_link[u.in_proc_call-1]);
      u.static_link[u.in_proc_call-1] := NIL;
    END;

    u.cg.rmCall(u.vstack.op(u.vstack.pos(0, &quot;call_indirect&quot;)));
    u.vstack.discard(1);

    IF (cc.m3cg_id = 0)
      AND u.call_param_size[u.in_proc_call-1] &gt; 0 THEN
      (* caller-cleans calling convention *)
      u.cg.immOp(Op.oADD, u.cg.reg[Codex86.ESP],
                 u.call_param_size[u.in_proc_call-1]);
    END;

    IF t = Type.Struct THEN
      t := Type.Addr;
    END;

    IF t # Type.Void THEN
      IF t &gt;= Type.Reel AND t &lt;= Type.XReel THEN
        u.vstack.pushnew(t, Force.any);
        u.cg.f_pushnew();
      ELSE
        u.vstack.pushnew(t, Force.regset, RegSet { Codex86.EAX });
      END
    END;

    DEC(u.in_proc_call);
  END call_indirect;
</PRE>------------------------------------------- procedure and closure types ---

<P><PRE>PROCEDURE <A NAME="load_procedure"><procedure>load_procedure</procedure></A> (u: U;  p: Proc) =
  VAR realproc := NARROW(p, x86Proc);
  (* push; s0.A := ADDR (p's body) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;load_procedure&quot;);
      u.wr.PName (p);
      u.wr.NL    ();
    END;

    u.vstack.unlock();
    u.vstack.pushnew(Type.Addr, Force.anyreg);
    WITH stack0 = u.vstack.pos(0, &quot;load_procedure&quot;) DO
      u.cg.movDummyReloc(u.vstack.op(stack0), realproc.symbol);
    END
  END load_procedure;

PROCEDURE <A NAME="load_static_link"><procedure>load_static_link</procedure></A> (u: U;  p: Proc) =
  VAR realproc := NARROW(p, x86Proc);
  (* push; s0.A := (static link needed to call p, NIL for top-level procs) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;load_static_link&quot;);
      u.wr.PName (p);
      u.wr.NL    ();
    END;

    IF realproc.lev = 0 THEN
      u.vstack.pushimm(0);
    ELSE
      u.vstack.unlock();
      u.vstack.pushnew(Type.Addr, Force.anyreg);
      u.cg.get_frame(u.vstack.op(u.vstack.pos(0, &quot;load_static_link&quot;)).reg,
                     realproc.parent, u.current_proc);
    END
  END load_static_link;

PROCEDURE <A NAME="load_static_link_toC"><procedure>load_static_link_toC</procedure></A> (u: U;  p: Proc) =
  VAR realproc := NARROW(p, x86Proc);
  (* push; s0.A := (static link needed to call p, NIL for top-level procs) *)
  BEGIN
    IF u.debug THEN
      u.wr.Cmd   (&quot;load_static_link_toC&quot;);
      u.wr.PName (p);
      u.wr.NL    ();
    END;

    IF realproc.lev = 0 THEN
      u.cg.movImm(u.cg.reg[Codex86.ECX], 0);
    ELSE
      u.vstack.unlock();
      u.vstack.corrupt(Codex86.ECX);
      u.cg.get_frame(Codex86.ECX, realproc.parent, u.current_proc);
    END
  END load_static_link_toC;
</PRE>---------------------------------------------------------- produce code ---

<P><PRE>PROCEDURE <A NAME="intregcmp"><procedure>intregcmp</procedure></A> (u: U; tozero: BOOLEAN): BOOLEAN =
  BEGIN
    IF tozero THEN
      u.vstack.doimm(Op.oCMP, 0, FALSE);
      RETURN FALSE;
    ELSE
      RETURN u.vstack.dobin(Op.oCMP, TRUE, FALSE);
    END
  END intregcmp;

PROCEDURE <A NAME="fltregcmp"><procedure>fltregcmp</procedure></A> (u: U; tozero: BOOLEAN): BOOLEAN =
  VAR reversed := FALSE;
  BEGIN
    IF tozero THEN
      u.cg.immFOp(FOp.fCOMP, FIm.Z);
      u.vstack.discard(1);
    ELSE
      IF u.cg.ftop_inmem THEN
        u.cg.binFOp(FOp.fCOMP, 1);
      ELSE
        u.cg.binFOp(FOp.fCOMPP, 1);
        reversed := TRUE;
      END;
      u.vstack.discard(2);
    END;

    u.vstack.unlock();
    u.vstack.corrupt(Codex86.EAX);
    u.cg.noargFOp(FOp.fNSTSWAX);
    u.cg.noargOp(Op.oSAHF);

    RETURN reversed;
  END fltregcmp;

PROCEDURE <A NAME="condbranch"><procedure>condbranch</procedure></A> (u: U; l: Label; cond: Cond; t: ZType) =
  VAR reversed := FALSE;
  BEGIN
    IF t &lt; Type.Reel THEN
      reversed := intregcmp(u, cond &lt; Cond.E);
      IF reversed THEN
        cond := revcond[cond];
      END;
      IF t # Type.Int THEN
        cond := unscond[cond];
      END
    ELSE
      reversed := fltregcmp(u, cond &lt; Cond.E);
      IF reversed THEN
        cond := revcond[cond];
      END;
      cond := unscond[cond]; (* FCOM sets the unsigned compare flags *)
    END;
    u.cg.brOp(cond, l);
  END condbranch;

PROCEDURE <A NAME="condset"><procedure>condset</procedure></A> (u: U; cond: Cond; t: ZType) =
  VAR reversed := FALSE;
  BEGIN
    IF t &lt; Type.Reel THEN
      reversed := intregcmp(u, cond &lt; Cond.E);
      IF reversed THEN
        cond := revcond[cond];
      END;
      IF t # Type.Int THEN
        cond := unscond[cond];
      END
    ELSE
      reversed := fltregcmp(u, cond &lt; Cond.E);
      IF reversed THEN
        cond := revcond[cond];
      END;
      cond := unscond[cond]; (* FCOM sets the unsigned compare flags *)
    END;
    u.vstack.unlock();
    u.vstack.pushnew(Type.Word_A, Force.mem);
    WITH stop0 = u.vstack.op(u.vstack.pos(0, &quot;condset&quot;)) DO
      stop0.mvar.var.stack_temp := FALSE;
      u.cg.setccOp(stop0, cond);
    END
  END condset;
</PRE>----------------------------------------------------------------- misc. ---

<P><PRE>PROCEDURE <A NAME="comment"><procedure>comment</procedure></A> (u: U;  a, b, c, d: TEXT := NIL) =
  VAR i: INTEGER := -1;
  BEGIN
    Cmt (u, a, i);
    Cmt (u, b, i);
    Cmt (u, c, i);
    Cmt (u, d, i);
    Cmt (u, &quot;\n&quot;, i);
  END comment;

PROCEDURE <A NAME="Cmt"><procedure>Cmt</procedure></A> (u: U;  t: TEXT;  VAR width: INTEGER) =
  VAR ch: CHAR;
  BEGIN
    IF (NOT u.debug OR t = NIL) THEN RETURN END;
    FOR i := 0 TO Text.Length (t) - 1 DO
      ch := Text.GetChar (t, i);
      IF (width = -1) THEN u.wr.OutT (&quot;\t# &quot;); width := 0; END;
      IF (ch = '\n') THEN
        u.wr.NL ();
        width := -1;
      ELSE
        u.wr.OutC (ch);
      END
    END;
  END Cmt;

BEGIN
END M3x86.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
