<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3back/src/M3x86Rep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3back/src/M3x86Rep.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

INTERFACE <interface><A HREF="M3x86.m3">M3x86Rep</A></interface>;

IMPORT <A HREF="../../m3middle/src/M3CG.i3">M3CG</A>, <A HREF="#x1">M3ID</A>;

FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT ByteOffset, ByteSize, Alignment;
FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Var, Proc, Name;
FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Type, MType, TypeUID;

TYPE <A HREF="M3x86.m3#U">U</A> &lt;: Public;
TYPE Public = M3CG.T OBJECT
      METHODS
        NewVar (t: Type; m3t: TypeUID; s: ByteSize; a: Alignment;
                name: Name := M3ID.NoID): x86Var;
      END;

TYPE VLoc = {global, temp};

TYPE OLoc = {mem, register, fstack, imm};

TYPE
  x86Var = Var OBJECT
    tag: INTEGER;
    type: Type;
    name: Name;
    s: ByteSize;
    a: Alignment;
    exported := FALSE;
    symbol: INTEGER;
    offset: ByteOffset;
    loc: VLoc;
    stack_temp := FALSE;
    scope := 0;
    parent: x86Proc := NIL;
  END;

TYPE ProcList = REF RECORD
  loc: ByteOffset;
  link: ProcList;
END;

TYPE Temp = RECORD
  var: x86Var;
  free: BOOLEAN;
END;

TYPE
  x86Proc = Proc OBJECT
    tag: INTEGER;
    type: Type;
    name: Name;
    lev := 0;
    parent: x86Proc := NIL;
    n_params: INTEGER;
    framesize := 0;
    paramsize := 8;
    tempsize := 0;
    temparr: REF ARRAY OF Temp;
    templimit := 16;
    stdcall: BOOLEAN; (* =&gt; callee cleans *)
    symbol: INTEGER;
    exported := FALSE;
    import := FALSE;
    offset := 0;
    bound := FALSE;
    usage: ProcList := NIL;
  END;

TYPE
  MVar = RECORD
    var: x86Var;
    o: ByteOffset := 0;
    t: MType;
  END;

CONST NoStore = MVar {var := NIL, t := FIRST(MType)};

TYPE
  Operand = RECORD
    loc: OLoc;
    mvar: MVar := NoStore;
    reg: Regno := 0;
    imm: INTEGER := 0;
    stackp: INTEGER := 0;
    opcode := FALSE;
  END;

TYPE FlToInt = { Round, Floor, Ceiling, Truncate };

TYPE Force = {any, mem, anydword, anytemp, anyregimm, anyreg, regset};

CONST NRegs: INTEGER = 7;

TYPE Regno = [-1 .. NRegs];

TYPE RegSet = SET OF Regno;

END M3x86Rep.
</PRE>
</inInterface>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
