<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3back/src/ObjFilex86.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3back/src/ObjFilex86.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="ObjFilex86.i3">ObjFilex86</A></implements></module>;

IMPORT <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../m3middle/src/M3CG.i3">M3CG</A>, <A HREF="#x1">M3ID</A>, <A HREF="M3x86.i3">M3x86</A>, <A HREF="Wrx86.i3">Wrx86</A>;

FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Name, ByteSize, Alignment, Type, TypeUID, ByteOffset;

FROM <A HREF="M3x86.i3">M3x86</A> IMPORT x86Var, x86Proc, VLoc;

REVEAL <A NAME="T">T</A> = Public BRANDED &quot;ObjFilex86&quot; OBJECT
        curs          : ARRAY Segment OF INTEGER;
        in_segment    := M3ID.NoID;
        n_params      := 0;
        param_offset  : ByteOffset;
        symno         := 0;
        symtop        := 0;
        sym           : REF ARRAY OF Symbol;
        init_var      : x86Var := NIL;
        init_size     := 0;
        init_sym      := 0;
        relochead     : ARRAY Segment OF ReLocList;
        reloctail     : ARRAY Segment OF ReLocList;
      OVERRIDES
        put := put;
        ranput := ranput;
        get := get;
        cursor := cursor;
        reloc := reloc;
        import_global := import_global;
        declare_segment := declare_segment;
        bind_segment := bind_segment;
        declare_global := declare_global;
        declare_param := declare_param;
        import_procedure := import_procedure;
        declare_procedure := declare_procedure;
        begin_init := begin_init;
        end_init := end_init;
        init_int := init_int;
        init_relocaddr := init_relocaddr;
        init_chars := init_chars;
      END;

TYPE Symbol = RECORD
  name: Name;
  import: BOOLEAN;
  proc := FALSE;
  offset: ByteOffset;
END;

TYPE ReLocList = REF RECORD
  src, dest: ReLoc;
  forward, backward: ReLocList;
END;

PROCEDURE <A NAME="put"><procedure>put</procedure></A> (t: T; seg: Segment; val, size: INTEGER) =
  BEGIN
    INC(t.curs[seg], size);
    size := val;
  END put;

PROCEDURE <A NAME="ranput"><procedure>ranput</procedure></A> (&lt;*UNUSED*&gt; t: T; &lt;*UNUSED*&gt; seg: Segment;
                  &lt;*UNUSED*&gt; offset, val, size: INTEGER) =
  BEGIN
  END ranput;

PROCEDURE <A NAME="get"><procedure>get</procedure></A> (&lt;*UNUSED*&gt; t: T; &lt;*UNUSED*&gt; seg: Segment;
               &lt;*UNUSED*&gt; offset, size: INTEGER): INTEGER =
  BEGIN
    RETURN 0;
  END get;

PROCEDURE <A NAME="cursor"><procedure>cursor</procedure></A> (t: T; seg: Segment): INTEGER =
  BEGIN
    RETURN t.curs[seg];
  END cursor;

PROCEDURE <A NAME="reloc"><procedure>reloc</procedure></A> (t: T; src, dest: ReLoc) =
  VAR item := t.reloctail[src.seg];
      newitem: ReLocList;
  BEGIN
    WHILE item # NIL AND src.sym &lt;= item.src.sym AND
          (src.sym # item.src.sym OR src.o &lt; item.src.o) DO
      item := item.backward;
    END;

    IF item = NIL THEN
      t.relochead[src.seg] := NEW(ReLocList, src := src, dest := dest,
                                  forward := t.relochead[src.seg],
                                  backward := NIL);
      newitem := t.relochead[src.seg];
    ELSE
      item.forward := NEW(ReLocList, src := src, dest := dest,
                          forward := item.forward,
                          backward := item);
      newitem := item.forward;
    END;

    IF newitem.forward = NIL THEN
      t.reloctail[src.seg] := newitem;
    ELSE
      newitem.forward.backward := newitem;
    END
  END reloc;

PROCEDURE <A NAME="import_global"><procedure>import_global</procedure></A> (t: T; n: Name; &lt;*UNUSED*&gt; s: ByteSize;
                         &lt;*UNUSED*&gt; a: Alignment; &lt;*UNUSED*&gt; type: Type;
                         &lt;*UNUSED*&gt; m3t: TypeUID): ByteOffset =
  BEGIN
    IF t.symno = t.symtop THEN
      expandsym(t);
    END;

    t.sym[t.symno].name := n;
    t.sym[t.symno].import := TRUE;

    INC(t.symno);
    RETURN t.symno - 1;
  END import_global;

PROCEDURE <A NAME="expandsym"><procedure>expandsym</procedure></A> (t: T) =
  VAR newarray := NEW(REF ARRAY OF Symbol, t.symtop * 2);
  BEGIN
    FOR i := 0 TO t.symtop - 1 DO
      newarray[i] := t.sym[i];
    END;

    t.sym := newarray;

    t.symtop := t.symtop * 2;
  END expandsym;

PROCEDURE <A NAME="declare_segment"><procedure>declare_segment</procedure></A> (t: T; n: Name; &lt;*UNUSED*&gt; m3t: TypeUID):
            ByteOffset =
  BEGIN
    &lt;* ASSERT t.in_segment = M3ID.NoID *&gt;
    t.in_segment := n;

    IF t.symno = t.symtop THEN
      expandsym(t);
    END;

    t.sym[t.symno].name := n;
    t.sym[t.symno].import := FALSE;

    INC(t.symno);
    RETURN t.symno - 1;
  END declare_segment;

PROCEDURE <A NAME="bind_segment"><procedure>bind_segment</procedure></A> (t: T; o: ByteOffset; s: ByteSize; a: Alignment;
                        &lt;*UNUSED*&gt; type: Type;
                        &lt;*UNUSED*&gt; exported: BOOLEAN; inited: BOOLEAN) =
  BEGIN
    &lt;* ASSERT o &lt; t.symno AND t.sym[o].name = t.in_segment *&gt;

    t.in_segment := M3ID.NoID;

    IF t.curs[Segment.data] MOD a # 0 THEN
      INC(t.curs[Segment.data], a - (t.curs[Segment.data] MOD a));
    END;

    t.sym[o].offset := t.curs[Segment.data];

    IF inited THEN
      &lt;* ASSERT t.init_var = NIL *&gt;
      t.init_size := s;
      t.init_sym := o;
    ELSE
      INC(t.curs[Segment.data], s);
    END
  END bind_segment;

PROCEDURE <A NAME="declare_global"><procedure>declare_global</procedure></A> (t: T; n: Name; s: ByteSize; a: Alignment;
                          &lt;*UNUSED*&gt; type: Type; &lt;*UNUSED*&gt; m3t: TypeUID;
                          &lt;*UNUSED*&gt; exported: BOOLEAN; inited: BOOLEAN):
            ByteOffset =
  BEGIN
    IF t.symno = t.symtop THEN
      expandsym(t);
    END;

    t.sym[t.symno].name := n;
    t.sym[t.symno].import := FALSE;

    IF t.curs[Segment.data] MOD a # 0 THEN
      INC(t.curs[Segment.data], a - (t.curs[Segment.data] MOD a));
    END;

    t.sym[t.symno].offset := t.curs[Segment.data];

    IF inited THEN
      &lt;* ASSERT t.init_var = NIL *&gt;
      t.init_size := s;
      t.init_sym := t.symno;
    ELSE
      INC(t.curs[Segment.data], s);
    END;

    INC(t.symno);
    RETURN t.symno - 1;
  END declare_global;

PROCEDURE <A NAME="declare_param"><procedure>declare_param</procedure></A> (t: T; v: x86Var; &lt;*UNUSED*&gt; n: Name;
                         s: ByteSize; a: Alignment;
                         &lt;*UNUSED*&gt; type: Type; &lt;*UNUSED*&gt; m3t: TypeUID):
            INTEGER =
  BEGIN
    &lt;* ASSERT t.n_params &gt; 0 *&gt;

    &lt;* ASSERT a &lt;= 4 *&gt;

    IF s MOD 4 # 0 THEN
      INC(s, 4 - (s MOD 4));
    END;

    DEC(t.param_offset, s);

    v.offset := t.param_offset;

    DEC(t.n_params);

    RETURN s;
  END declare_param;

PROCEDURE <A NAME="import_procedure"><procedure>import_procedure</procedure></A> (t: T; n: Name; &lt;*UNUSED*&gt; n_params: INTEGER;
                            &lt;*UNUSED*&gt; type: Type; &lt;*UNUSED*&gt; lang: TEXT):
            ByteOffset =
  BEGIN
    IF t.symno = t.symtop THEN
      expandsym(t);
    END;

    t.sym[t.symno].name := n;
    t.sym[t.symno].import := TRUE;
    t.sym[t.symno].proc := TRUE;

    INC(t.symno);
    RETURN t.symno - 1;
  END import_procedure;

PROCEDURE <A NAME="declare_procedure"><procedure>declare_procedure</procedure></A> (t: T; n: Name; &lt;*UNUSED*&gt; n_params: INTEGER;
                             &lt;*UNUSED*&gt; type: Type;
                             &lt;*UNUSED*&gt; exported: BOOLEAN;
                             &lt;*UNUSED*&gt; lev: INTEGER;
                             &lt;*UNUSED*&gt; proc: x86Proc) =
  BEGIN
    IF t.symno = t.symtop THEN
      expandsym(t);
    END;

    t.sym[t.symno].name := n;
    t.sym[t.symno].import := FALSE;
    t.sym[t.symno].proc := TRUE;

    INC(t.symno);
  END declare_procedure;

PROCEDURE <A NAME="begin_init"><procedure>begin_init</procedure></A> (t: T; v: x86Var) =
  BEGIN
    &lt;* ASSERT t.init_var = NIL *&gt;
    t.init_var := v;
  END begin_init;

PROCEDURE <A NAME="end_init"><procedure>end_init</procedure></A> (t: T; v: x86Var) =
  BEGIN
    &lt;* ASSERT t.init_var = v *&gt;

    pad_init(t, t.init_size);
    t.init_var := NIL;
  END end_init;

PROCEDURE <A NAME="init_int"><procedure>init_int</procedure></A> (t: T; o: ByteOffset; i, size: INTEGER) =
  BEGIN
    pad_init(t, o);

    &lt;* ASSERT o + size &lt;= t.init_size *&gt;
    put(t, Segment.data, i, size);
  END init_int;

PROCEDURE <A NAME="init_relocaddr"><procedure>init_relocaddr</procedure></A> (t: T; o: ByteOffset; loc: VLoc;
                          valoff, bias: ByteOffset) =
  VAR seg := Segment.data;
  BEGIN
    pad_init(t, o);

    &lt;* ASSERT o + 4 &lt;= t.init_size *&gt;
    put(t, Segment.data, bias, 4);

    &lt;* ASSERT loc = VLoc.global OR loc = VLoc.import *&gt;
    IF loc = VLoc.import THEN
      seg := Segment.global;
    END;

    reloc(t, ReLoc {Segment.data, t.init_sym, o},
             ReLoc {seg, valoff, bias} );
  END init_relocaddr;

PROCEDURE <A NAME="init_chars"><procedure>init_chars</procedure></A>(t: T; o: ByteOffset; txt: TEXT) =
  BEGIN
    pad_init(t, o);

    &lt;* ASSERT o + Text.Length(txt) &lt;= t.init_size *&gt;
    FOR i := 0 TO Text.Length(txt) - 1 DO
      put(t, Segment.data, ORD(Text.GetChar(txt, i)), 1);
    END
  END init_chars;

PROCEDURE <A NAME="pad_init"><procedure>pad_init</procedure></A> (t: T; up_to: ByteOffset) =
  VAR length := up_to - t.curs[Segment.data];
  BEGIN
    IF length = 0 THEN
      RETURN;
    END;

    &lt;* ASSERT length &gt; 0 *&gt;

    FOR i := 0 TO length DO
      put(t, Segment.data, 0, 1);
    END
  END pad_init;

PROCEDURE <A NAME="New"><procedure>New</procedure></A> (&lt;*UNUSED*&gt;wr: Wrx86.T): T =
  VAR obj := NEW(T);
  BEGIN
    FOR i := FIRST(Segment) TO LAST(Segment) DO
      obj.curs[i] := 0;
      obj.relochead[i] := NIL;
      obj.reloctail[i] := NIL;
    END;

    obj.symtop := 256;
    obj.sym := NEW(REF ARRAY OF Symbol, obj.symtop);

    RETURN obj;
  END New;
</PRE><P>
<P>
(*---------------------------------------------- future update list stuff ---

<P><PRE>TYPE OffsetList = OBJECT
  val: ByteOffset;
  tag: INTEGER;
  singleton := FALSE;
  ptr: OffsetList;
END;

PROCEDURE in_offset_list (t: T; l : INTEGER; toadd: BOOLEAN): OffsetList =
  VAR ptr := t.offlist_top;
  BEGIN
    WHILE ptr # NIL DO
      IF ptr.tag = l AND NOT (ptr.singleton AND toadd) THEN
        RETURN ptr;
      END;
      ptr := ptr.ptr;
    END;
    RETURN NIL;
  END in_offset_list;

&lt;*UNUSED*&gt; PROCEDURE del_offset_item (t: T; ptr: OffsetList; l: INTEGER) =
  VAR old := ptr;
  BEGIN
    WHILE old # NIL DO
      ptr := old.ptr;
      IF ptr.tag = l THEN
        old.ptr := ptr.ptr;
        RETURN;
      END;
      old := ptr;
    END;
    t.Err(&quot;Tried to delete non-existent offset list item&quot;);
  END del_offset_item;

PROCEDURE add_offset_item (t: T; l: INTEGER; val: ByteOffset;
                           insert: INTEGER) =
  BEGIN
    t.offlist_top := NEW(OffsetList, val := val, tag := l,
                         ptr := t.offlist_top);
    t.obj.put(Segment.text, val, insert, 4);
    IF insert &gt; 16_FFFF THEN
      t.offlist_top.singleton := TRUE;
    END
  END add_offset_item;

PROCEDURE add_offset_to_thread(t: T; oldend, newend: ByteOffset;
                               insert: INTEGER): ByteOffset =
  VAR offset := newend - oldend;
  BEGIN
    &lt;* ASSERT offset &gt; 0 AND offset &lt; 16_10000 AND
              insert &gt; 0 AND insert &lt; 16_10000 *&gt;
    insert := Word.And(insert, Word.Shift(offset, 16));
    t.obj.put(Segment.text, newend, insert, 4);
    RETURN newend;
  END add_offset_to_thread;

PROCEDURE log_global_var (t: T; var: Operand; reltocurs: INTEGER) =
  VAR listptr: OffsetList;
  BEGIN
    IF var.mvar.o &gt; 16_FFFF THEN
      add_offset_item(t, var.mvar.var.tag, place, var.mvar.o);
      RETURN;
    END;
    listptr := in_offset_list(t, var.mvar.var.tag, TRUE);
    IF listptr = NIL OR (place - listptr.val) &gt; 16_FFFF THEN
      add_offset_item(t, var.mvar.var.tag, place, var.mvar.o);
    ELSE
      listptr.val := add_offset_to_thread(t, listptr.val, place, var.mvar.o);
    END
  END log_global_var;

PROCEDURE log_case_jump (t: T; place: ByteOffset; nlabels: CARDINAL) =
  BEGIN
    add_offset_item(t, -1, place, Word.Shift(nlabels, 16));
  END log_case_jump;
*)

BEGIN
END ObjFilex86.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
