<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3back/src/Wrx86.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3back/src/Wrx86.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                             </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="Wrx86.i3">Wrx86</A></implements></module>;

IMPORT <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../../m3middle/src/M3Buf.i3">M3Buf</A>, <A HREF="#x1">M3ID</A>, <A HREF="../../m3middle/src/M3CG.i3">M3CG</A>, <A HREF="../../m3middle/src/Target.i3">Target</A>, <A HREF="../../m3middle/src/TInt.i3">TInt</A> AS TargetInt, <A HREF="../../m3middle/src/TFloat.i3">TFloat</A>;

FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Name, TypeUID;
FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Var, Proc, Label, No_label;
FROM <A HREF="../../m3middle/src/M3CG.i3">M3CG</A> IMPORT Type;

FROM <A HREF="M3x86Rep.i3">M3x86Rep</A> IMPORT x86Var, x86Proc, VLoc;

REVEAL <A NAME="T">T</A> = Public BRANDED &quot;Wrx86.T&quot; OBJECT
        wr            : Wr.T := NIL;
        buf           : M3Buf.T := NIL;
        buf_len       : INTEGER := 0;
      OVERRIDES
        Flush := Flush;
        NL := NL;
        Cmd := Cmd;
        ZName := ZName;
        VName := VName;
        PName := PName;
        TName := TName;
        Flt := Flt;
        Bool := Bool;
        Lab := Lab;
        Tipe := Tipe;
        Int := Int;
        TInt := TInt;
        BInt := BInt;
        Txt := Txt;
        OutC := OutC;
        OutT := OutT;
        OutN := OutN;
        OutS := OutS;
        OutI := OutI;
      END;

PROCEDURE <A NAME="NL"><procedure>NL</procedure></A> (t: T) =
  BEGIN
    OutT (t, Wr.EOL);
  END NL;

PROCEDURE <A NAME="Cmd"><procedure>Cmd</procedure></A> (t: T; cmd: TEXT) =
  VAR len := Text.Length (cmd);
  BEGIN
    OutC (t, '\t');
    OutT (t, cmd);
    FOR i := 0 TO 14-len DO OutC (t, ' ') END;
    OutC (t, ' ');
    OutC (t, ' ');
  END Cmd;

PROCEDURE <A NAME="ZName"><procedure>ZName</procedure></A> (t: T;  n: Name) =
  BEGIN
    OutC (t, ' ');
    IF (n = M3ID.NoID)
      THEN OutC (t, '*');
      ELSE OutN (t, n);
    END;
  END ZName;

PROCEDURE <A NAME="VName"><procedure>VName</procedure></A> (t: T;  v: Var) =
  BEGIN
    TYPECASE v OF
    | NULL     =&gt; OutT (t, &quot; *&quot;);
    | x86Var(x)=&gt; CASE x.loc OF
                    VLoc.global =&gt; OutT (t, &quot; g&quot;);
                  | VLoc.temp =&gt; OutT (t, &quot; t&quot;);
                  END;
                  OutT (t, &quot;v.&quot;);  OutI (t, x.tag);  ZName (t, x.name);
    ELSE          OutT (t, &quot; v.???&quot;);
    END;
  END VName;

PROCEDURE <A NAME="PName"><procedure>PName</procedure></A> (t: T;  p: Proc) =
  BEGIN
    TYPECASE p OF
    | NULL       =&gt; OutT (t, &quot; *&quot;);
    | x86Proc(x) =&gt; OutT (t, &quot;p.&quot;); OutI (t, x.tag);  ZName (t, x.name);
    ELSE            OutT (t, &quot; p.???&quot;);
    END;
  END PName;

PROCEDURE <A NAME="TName"><procedure>TName</procedure></A> (t: T;  type: Type) =
  CONST type_names = ARRAY Type OF TEXT {
                       &quot; Addr&quot;, &quot; Word&quot;, &quot; Int&quot;,
                       &quot; Reel&quot;, &quot; LReel&quot;, &quot; XReel&quot;,
                       &quot; Int.8&quot;, &quot; Int.16&quot;, &quot; Int.32&quot;, &quot; Int.32D&quot;,
                       &quot; Word.8&quot;, &quot; Word.16&quot;, &quot; Word.32&quot;, &quot; Word.32D&quot;,
                       &quot; Struct&quot;, &quot; Void&quot;
                     };
  BEGIN
    OutT (t, type_names[type]);
  END TName;

PROCEDURE <A NAME="Flt"><procedure>Flt</procedure></A> (t: T;  READONLY f: Target.Float) =
  CONST FType = ARRAY Target.Precision OF TEXT { &quot; R &quot;, &quot; L &quot;, &quot; X &quot; };
  VAR
    buf : ARRAY [0..BITSIZE (Target.Extended)] OF CHAR;
    len := TFloat.ToChars (f, buf);
  BEGIN
    OutT (t, FType [TFloat.Prec (f)]);
    OutS (t, SUBARRAY (buf, 0, len));
  END Flt;

PROCEDURE <A NAME="Bool"><procedure>Bool</procedure></A> (t: T;  b: BOOLEAN) =
  CONST Tags = ARRAY BOOLEAN OF CHAR { 'F', 'T' };
  BEGIN
    OutC (t, ' ');
    OutC (t, Tags[b]);
  END Bool;

PROCEDURE <A NAME="Lab"><procedure>Lab</procedure></A> (t: T;  i: Label) =
  BEGIN
    OutC (t, ' ');
    IF (i = No_label)
      THEN OutC (t, '*');
      ELSE OutT (t, &quot;L.&quot;); OutI (t, i);
    END;
  END Lab;

PROCEDURE <A NAME="Tipe"><procedure>Tipe</procedure></A> (t: T;  type: TypeUID) =
  BEGIN
    OutT (t, &quot; &quot;);
    OutI (t, type);
  END Tipe;

PROCEDURE <A NAME="Int"><procedure>Int</procedure></A> (t: T;  i: INTEGER) =
  BEGIN
    OutC (t, ' ');
    OutI (t, i);
  END Int;

PROCEDURE <A NAME="TInt"><procedure>TInt</procedure></A> (t: T;  READONLY i: Target.Int) =
  VAR
    buf : ARRAY [0..BITSIZE (Target.Integer)] OF CHAR;
    len := TargetInt.ToChars (i, buf);
  BEGIN
    OutC (t, ' ');
    OutS (t, SUBARRAY (buf, 0, len));
  END TInt;

PROCEDURE <A NAME="BInt"><procedure>BInt</procedure></A> (t: T;  i: INTEGER) =
  BEGIN
    Int (t, i);
     (* since the reader doesn't know how to read 'bytes+bits' *)
  END BInt;
</PRE>********
PROCEDURE BInt (t: T;  i: INTEGER) =
  VAR x := i MOD Target.Byte;
      y := i DIV Target.Byte;
  BEGIN
    IF (x = 0)
      THEN Int (t, y);
      ELSE Int (t, y);  OutC (t, '+');  OutI (t, x);
    END;
  END BInt;
**************

<P><PRE>CONST
  VanillaChars = SET OF CHAR { ' ', '!', '#' .. '[', ']' .. '~' };
  Digits = ARRAY [0..7] OF CHAR { '0', '1', '2', '3', '4', '5', '6', '7' };

PROCEDURE <A NAME="Txt"><procedure>Txt</procedure></A> (t: T;  txt: TEXT) =
  VAR c: CHAR;
  BEGIN
    OutC (t, ' ');
    IF (txt = NIL) THEN
      OutC (t, '*');
      RETURN;
    END;
    OutC (t, '&quot;');
    FOR i := 0 TO Text.Length (txt)-1 DO
      c := Text.GetChar (txt, i);
      IF (c IN VanillaChars) THEN
        OutC (t, c);
      ELSE
        OutC (t, '\\');
        OutC (t, Digits [ORD(c) DIV 64]);
        OutC (t, Digits [ORD(c) MOD 64 DIV 8]);
        OutC (t, Digits [ORD(c) MOD 8]);
      END;
    END;
    OutC (t, '&quot;');
  END Txt;
</PRE>--------------------------------------------------------- low level I/O ---

<P><PRE>PROCEDURE <A NAME="Flush"><procedure>Flush</procedure></A> (t: T) =
  &lt;*FATAL Wr.Failure, Thread.Alerted*&gt;
  BEGIN
    M3Buf.Flush (t.buf, t.wr);
    t.buf_len := 0;
    Wr.Flush (t.wr);
  END Flush;

PROCEDURE <A NAME="OutC"><procedure>OutC</procedure></A> (t: T;  c: CHAR) =
  BEGIN
    M3Buf.PutChar (t.buf, c);
    INC (t.buf_len);
    IF (t.buf_len &gt;= 1024) THEN Flush (t) END;
  END OutC;

PROCEDURE <A NAME="OutT"><procedure>OutT</procedure></A> (t: T;  txt: TEXT) =
  BEGIN
    M3Buf.PutText (t.buf, txt);
    INC (t.buf_len, Text.Length (txt));
    IF (t.buf_len &gt;= 1024) THEN Flush (t) END;
  END OutT;

PROCEDURE <A NAME="OutN"><procedure>OutN</procedure></A> (t: T;  n: Name) =
  BEGIN
    M3ID.Put (t.buf, n);
    INC (t.buf_len, 10); (* we don't really care if it's accurate *)
    IF (t.buf_len &gt;= 1024) THEN Flush (t) END;
  END OutN;

PROCEDURE <A NAME="OutS"><procedure>OutS</procedure></A> (t: T;  READONLY buf: ARRAY OF CHAR) =
  BEGIN
    M3Buf.PutSub (t.buf, buf);
    INC (t.buf_len, NUMBER (buf));
    IF (t.buf_len &gt;= 1024) THEN Flush (t) END;
  END OutS;

PROCEDURE <A NAME="OutI"><procedure>OutI</procedure></A>  (t: T;  i: INTEGER) =
  BEGIN
    M3Buf.PutInt (t.buf, i);
    INC (t.buf_len, 4); (* we don't really care if it's accurate *)
    IF (t.buf_len &gt;= 1024) THEN Flush (t) END;
  END OutI;
</PRE>---------------------------------------------------------------------------

<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A> (output: Wr.T): T =
  BEGIN
    RETURN NEW (T,
                wr      := output,
                buf     := M3Buf.New (),
                buf_len := 0);
  END New;

BEGIN
END Wrx86.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
