<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Abs.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Abs.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Abs.m3                                                
 Last Modified On Tue May  3 16:28:46 PDT 1994 By kalsow     
      Modified On Sat Dec  8 00:46:53 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="Abs.i3">Abs</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../misc/Error.i3">Error</A>;
IMPORT <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../builtinTypes/Reel.i3">Reel</A>, <A HREF="../builtinTypes/LReel.i3">LReel</A>, <A HREF="../builtinTypes/EReel.i3">EReel</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../exprs/ReelExpr.i3">ReelExpr</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (ce: CallExpr.T): Type.T =
  BEGIN
    RETURN Type.Base (Expr.TypeOf (ce.args[0]));
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  VAR t := TypeOf (ce);
  BEGIN
    ce.type := t;
    IF (t = Int.T) THEN
      INC (cs.int_ops);
    ELSIF (t = Reel.T) OR (t = LReel.T) OR (t = EReel.T) THEN
      INC (cs.fp_ops);
    ELSE
      Error.Msg (&quot;ABS: wrong argument type&quot;);
    END;
  END Check;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  VAR e := ce.args[0];
  BEGIN
    Expr.Compile (e);
    CG.Abs (Type.CGType (Expr.TypeOf (e)));
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e, x: Expr.T;  i, j: Target.Int;
  BEGIN
    e := Expr.ConstValue (ce.args[0]);
    IF (e = NIL) THEN
      RETURN NIL;
    ELSIF IntegerExpr.Split (e, i) THEN
      IF TInt.LT (i, TInt.Zero) THEN
        IF NOT TInt.Subtract (TInt.Zero, i, j) THEN RETURN NIL END;
        e := IntegerExpr.New (j);
      END;
      RETURN e;
    ELSIF ReelExpr.Abs (e, x) THEN
      RETURN x;
    ELSE
      RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, TRUE, NIL,
                                 TypeOf,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;ABS&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Abs.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
