<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Adr.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Adr.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Adr.m3                                                
 Last Modified On Wed Jun 29 16:59:33 PDT 1994 By kalsow     
      Modified On Sat Dec  8 00:54:28 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="Adr.i3">Adr</A></implements></module>;

IMPORT <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../values/Module.i3">Module</A>, <A HREF="../builtinTypes/Addr.i3">Addr</A>, <A HREF="../misc/CG.i3">CG</A>;
IMPORT <A HREF="../types/RefType.i3">RefType</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../misc/Host.i3">Host</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (ce: CallExpr.T): Type.T =
  VAR t := Addr.T;
  BEGIN
    IF Host.new_adr THEN
      t := RefType.New (Expr.TypeOf (ce.args[0]), FALSE, NIL);
    END;
    RETURN t;
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  &lt;*UNUSED*&gt; VAR cs: Expr.CheckState) =
  VAR e := ce.args[0];
  BEGIN
    IF ce.type = NIL THEN ce.type := TypeOf (ce); END;
    ce.type := Type.Check (ce.type);
    IF Module.IsSafe () THEN Error.Msg (&quot;unsafe operation&quot;) END;
    IF Expr.IsDesignator (e)
      THEN Expr.NeedsAddress (e);
      ELSE Error.Msg (&quot;ADR: argument must be a designator&quot;);
    END;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.PrepLValue (ce.args[0]);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.CompileLValue (ce.args[0]);
    CG.Check_byte_aligned ();
  END Compile;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, TRUE, NIL,
                                 TypeOf,
                                 CallExpr.NotAddressable,
                                 Check,
                                 Prep,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 CallExpr.NoValue,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;ADR&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Adr.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
