<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/BitSize.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/BitSize.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: BitSize.m3                                            
 Last Modified On Wed Jun 29 17:00:26 PDT 1994 By kalsow     
      Modified On Sat Dec  8 00:54:27 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="BitSize.i3">BitSize</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>;
IMPORT <A HREF="../exprs/TypeExpr.i3">TypeExpr</A>, <A HREF="../types/OpenArrayType.i3">OpenArrayType</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="#x1">Card</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    DoCheck (&quot;BITSIZE&quot;, ce, cs);
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  BEGIN
    DoPrep (ce.args[0]);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    DoCompile (ce.args[0], 1);
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  BEGIN
    RETURN DoFold (ce.args[0], 1);
  END Fold;

PROCEDURE <A NAME="DoCheck"><procedure>DoCheck</procedure></A> (name: TEXT;  ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  VAR t: Type.T;   e := ce.args[0];  info: Type.Info;
  BEGIN
    IF Expr.IsDesignator (e) THEN
      (* ok *)
      t := Type.CheckInfo (Expr.TypeOf (e), info);
      IF (info.class = Type.Class.OpenArray) THEN  INC (cs.int_ops);  END;
    ELSIF TypeExpr.Split (e, t) THEN
      IF OpenArrayType.Is (t) THEN
        Error.Txt (name, &quot;argument cannot be an open array type&quot;);
      END;
    ELSE
      Error.Txt (name, &quot;argument must be a designator or type&quot;);
    END;
    ce.type := Card.T;
  END DoCheck;

PROCEDURE <A NAME="DoPrep"><procedure>DoPrep</procedure></A> (e: Expr.T) =
  VAR t: Type.T;  info: Type.Info;
  BEGIN
    IF TypeExpr.Split (e, t) THEN RETURN; END;

    t := Type.CheckInfo (Expr.TypeOf (e), info);
    IF (info.class # Type.Class.OpenArray) THEN RETURN; END;

    (* ELSE, open array *)
    Expr.Prep (e);
  END DoPrep;

PROCEDURE <A NAME="DoCompile"><procedure>DoCompile</procedure></A> (e: Expr.T;  unit: INTEGER) =
  VAR t: Type.T;  sz, align: INTEGER;  t_array: CG.Val;  info: Type.Info;
  BEGIN
    IF TypeExpr.Split (e, t) THEN
      Type.Compile (t);
      EVAL Type.CheckInfo (t, info);
      CG.Load_intt ((info.size + unit - 1) DIV unit);
      RETURN;
    END;

    t := Type.CheckInfo (Expr.TypeOf (e), info);
    IF (info.class # Type.Class.OpenArray) THEN
      CG.Load_intt ((info.size + unit - 1) DIV unit);
      RETURN;
    END;

    (* ELSE, open array *)
    align := info.alignment;
    Expr.Compile (e);
    t_array := CG.Pop ();
    FOR i := 0 TO OpenArrayType.OpenDepth (t) - 1 DO
      CG.Push (t_array);
      CG.Open_size (i);
      IF (i # 0) THEN CG.Multiply (CG.Type.Int) END;
    END;
    CG.Free (t_array);

    sz := OpenArrayType.EltPack (t);
    IF (sz MOD unit) = 0 THEN
      CG.Load_intt (sz DIV unit);
      CG.Multiply (CG.Type.Int);
    ELSE (* array elements aren't &quot;unit&quot;-aligned *)
      CG.Load_intt (sz);
      CG.Multiply (CG.Type.Int);
      CG.Load_intt (unit - 1);
      CG.Add (CG.Type.Int);
      CG.Load_intt (unit);
      CG.Div (CG.Type.Int, CG.Sign.Positive, CG.Sign.Positive);
    END;
  END DoCompile;

PROCEDURE <A NAME="DoFold"><procedure>DoFold</procedure></A> (e: Expr.T;  unit: INTEGER): Expr.T =
  VAR t: Type.T;  size, a, b, c, d: Target.Int;  info: Type.Info;
  BEGIN
    IF NOT TypeExpr.Split (e, t) THEN
      t := Type.CheckInfo (Expr.TypeOf (e), info);
      IF (info.class = Type.Class.OpenArray) THEN RETURN NIL END;
    END;
    t := Type.CheckInfo (t, info);
    IF    TInt.FromInt (info.size, size)
      AND TInt.FromInt (unit, a)
      AND TInt.FromInt (unit - 1, b)
      AND TInt.Add (size, b, c)
      AND TInt.Div (c, a, d)
      THEN RETURN IntegerExpr.New (d);
      ELSE RETURN NIL;
    END;
  END DoFold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, FALSE, Card.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 Prep,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;BITSIZE&quot;, Z, TRUE);
  END Initialize;

BEGIN
END BitSize.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Card is in:
</A><UL>
<LI><A HREF="../../../bicycle/src/Card.i3#0TOP0">bicycle/src/Card.i3</A>
<LI><A HREF="../builtinTypes/Card.i3#0TOP0">m3front/src/builtinTypes/Card.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
