<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/ByteSize.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/ByteSize.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: ByteSize.m3                                           
 Last Modified On Tue May  3 16:29:36 PDT 1994 By kalsow     
      Modified On Tue Mar 20 03:05:35 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="ByteSize.i3">ByteSize</A></implements></module>;

IMPORT <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="BitSize.i3">BitSize</A>, <A HREF="#x1">Card</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    BitSize.DoCheck (&quot;BYTESIZE&quot;, ce, cs);
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  BEGIN
    BitSize.DoPrep (ce.args[0]);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    BitSize.DoCompile (ce.args[0], 8);
    (* Note: the language defines &quot;8 bit bytes&quot; otherwise, we'd use
       Target.Byte or Target.Char.size as a byte... *)
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  BEGIN
    RETURN BitSize.DoFold (ce.args[0], 8);
    (* Note: the language defines &quot;8 bit bytes&quot; otherwise, we'd use
       Target.Byte or Target.Char.size as a byte... *)
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, FALSE, Card.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 Prep,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;BYTESIZE&quot;, Z, TRUE);
  END Initialize;

BEGIN
END ByteSize.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface Card is in:
</A><UL>
<LI><A HREF="../../../bicycle/src/Card.i3#0TOP0">bicycle/src/Card.i3</A>
<LI><A HREF="../builtinTypes/Card.i3#0TOP0">m3front/src/builtinTypes/Card.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
