<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Ceiling.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Ceiling.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Ceiling.m3                                            
 Last Modified On Fri Jun 24 09:37:32 PDT 1994 By kalsow     
      Modified On Sat Dec  8 00:54:26 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="Ceiling.i3">Ceiling</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../builtinTypes/Int.i3">Int</A>;
IMPORT <A HREF="../builtinTypes/Reel.i3">Reel</A>, <A HREF="../builtinTypes/LReel.i3">LReel</A>, <A HREF="../builtinTypes/EReel.i3">EReel</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../exprs/ReelExpr.i3">ReelExpr</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    DoCheck (&quot;CEILING&quot;, ce, cs);
  END Check;

PROCEDURE <A NAME="DoCheck"><procedure>DoCheck</procedure></A> (name: TEXT;  ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  VAR t: Type.T;
  BEGIN
    t := Type.Base (Expr.TypeOf (ce.args[0]));
    INC (cs.fp_ops);
    IF (t # Reel.T) AND (t # LReel.T) AND (t # EReel.T) THEN
      Error.Txt (name, &quot;argument not REAL, LONGREAL or EXTENDED&quot;);
    END;
    ce.type := Int.T;
  END DoCheck;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  VAR e := ce.args[0];
  BEGIN
    Expr.Compile (e);
    CG.Ceiling (Type.CGType (Expr.TypeOf (e)));
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e, x: Expr.T;
  BEGIN
    e := Expr.ConstValue (ce.args[0]);
    IF    (e = NIL)                THEN RETURN NIL;
    ELSIF ReelExpr.Ceiling (e, x)  THEN RETURN x;
    ELSE  (* bogus *)                   RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, TRUE, Int.T,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;CEILING&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Ceiling.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
