<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Dec.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Dec.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Dec.m3                                                
 Last Modified On Fri Jul  8 09:15:07 PDT 1994 By kalsow     
      Modified On Tue Apr  2 03:46:13 1991 By muller         

<P><PRE>MODULE <module><implements><A HREF="Dec.i3">Dec</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../values/Module.i3">Module</A>;
IMPORT <A HREF="#x1">M3ID</A>, <A HREF="../builtinTypes/Addr.i3">Addr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../misc/Host.i3">Host</A>, <A HREF="../exprs/NamedExpr.i3">NamedExpr</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  BEGIN
    DoCheck (&quot;DEC&quot;, ce, cs);
  END Check;

PROCEDURE <A NAME="DoCheck"><procedure>DoCheck</procedure></A> (name: TEXT;  ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  VAR t: Type.T; e: Expr.T;  nm: M3ID.T;
  BEGIN
    e := ce.args[0];
    t := Type.Base (Expr.TypeOf (e));
    IF NOT Type.IsOrdinal (t) THEN
      IF Type.IsSubtype (t, Addr.T) THEN
        IF Module.IsSafe () THEN Error.Txt (name, &quot;unsafe operation&quot;) END;
      ELSE
        Error.Txt (name, &quot;first argument must be of an ordinal type&quot;);
      END;
    ELSIF (NOT Expr.IsDesignator (e)) THEN
      Error.Txt (name, &quot;first argument must be a variable&quot;);
    ELSIF (NOT Expr.IsWritable (e)) THEN
      Error.Txt (name, &quot;first argument must be writable&quot;);
    ELSIF NamedExpr.SplitName (e, nm) THEN
      (* simple scalar =&gt; we don't need an explicit address
            -- demanded by Eric Veach 9/17/93 *)
    ELSE
      Expr.NeedsAddress (e);
    END;
    IF (NUMBER (ce.args^) &gt; 1) THEN
      t := Type.Base (Expr.TypeOf (ce.args[1]));
      IF (t # Int.T) THEN
        Error.Txt (name, &quot;second argument must be an integer&quot;);
      END;
    END;
    ce.type := NIL;
    INC (cs.int_ops);
  END DoCheck;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.PrepLValue (ce.args[0]);
    IF (NUMBER (ce.args^) &gt; 1) THEN Expr.Prep (ce.args[1]); END;
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  VAR
    lhs    := ce.args[0];
    tlhs   := Expr.TypeOf (lhs);
    info   : Type.Info;
    dec    : Expr.T;
    check  : [0..3] := 0;
    lvalue : CG.Val;
    bmin, bmax, imin, imax: Target.Int;
  BEGIN
    EVAL Type.CheckInfo (tlhs, info);
    IF (NUMBER (ce.args^) &gt; 1)
      THEN dec := ce.args[1];
      ELSE dec := IntegerExpr.New (TInt.One);  Expr.Prep (dec);
    END;
    Expr.GetBounds (lhs, bmin, bmax);
    Expr.GetBounds (dec, imin, imax);

    IF Host.doRangeChk THEN
      IF NOT TInt.EQ (bmin, Target.Integer.min)
         AND TInt.LT (TInt.Zero, imax) THEN INC (check) END;
      IF NOT TInt.EQ (bmax, Target.Integer.max)
         AND TInt.LT (imin, TInt.Zero) THEN INC (check, 2) END;
    END;

    Expr.CompileLValue (lhs);
    lvalue := CG.Pop ();
    CG.Push (lvalue);

    CG.Push (lvalue);
    CG.Load_indirect (info.cg_type, 0, info.size);
    Expr.Compile (dec);

    IF (info.cg_type = CG.Type.Addr)
      THEN CG.Index_bytes (-Target.Byte);  check := 0;
      ELSE CG.Subtract (CG.Type.Int);
    END;

    CASE check OF
    | 0 =&gt; (* no range checking *)
    | 1 =&gt; CG.Check_lo (bmin);
    | 2 =&gt; CG.Check_hi (bmax);
    | 3 =&gt; CG.Check_range (bmin, bmax);
    END;

    CG.Store_indirect (info.cg_type, 0, info.size);
    CG.Free (lvalue);
    Expr.NoteWrite (lhs);
  END Compile;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 2, FALSE, FALSE, TRUE, NIL,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 Prep,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 CallExpr.NoValue,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;DEC&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Dec.
</PRE>
</inModule>
<HR>
<A NAME="x1">interface M3ID is in:
</A><UL>
<LI><A HREF="../../../m3middle/src/M3ID.i3#0TOP0">m3middle/src/M3ID.i3</A>
<LI><A HREF="../../../m3tools/src/M3ID.i3#0TOP0">m3tools/src/M3ID.i3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
