<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Dispose.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Dispose.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Dispose.m3                                            
 Last Modified On Wed Jun 29 17:01:08 PDT 1994 By kalsow     
      Modified On Tue Feb 12 11:52:16 1991 By muller         

<P><PRE>MODULE <module><implements><A HREF="Dispose.i3">Dispose</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../misc/Runtime.i3">Runtime</A>;
IMPORT <A HREF="../builtinTypes/Addr.i3">Addr</A>, <A HREF="../builtinTypes/Reff.i3">Reff</A>, <A HREF="../values/Module.i3">Module</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../builtinTypes/ObjectRef.i3">ObjectRef</A>, <A HREF="../builtinTypes/ObjectAdr.i3">ObjectAdr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  &lt;*UNUSED*&gt; VAR cs: Expr.CheckState) =
  VAR t: Type.T;  info: Type.Info;
  BEGIN
    t := Expr.TypeOf (ce.args[0]);
    t := Type.CheckInfo (t, info);
    IF Module.IsSafe () THEN Error.Msg (&quot;DISPOSE: unsafe operation&quot;) END;
    IF (NOT Type.IsSubtype (t, Reff.T))
      AND (NOT Type.IsSubtype (t, Addr.T)) THEN
      Error.Msg (&quot;DISPOSE: must be applied to a reference type&quot;);
    ELSIF Type.IsEqual (t, Reff.T, NIL)
       OR Type.IsEqual (t, Addr.T, NIL)
       OR Type.IsEqual (t, ObjectRef.T, NIL)
       OR Type.IsEqual (t, ObjectAdr.T, NIL) THEN
      Error.Msg (&quot;DISPOSE: must be applied to a fixed reference type&quot;);
    ELSIF NOT Expr.IsWritable (ce.args[0]) THEN
      Error.Msg (&quot;DISPOSE: must be applied to a writable designator&quot;);
    ELSIF NOT info.isTraced THEN
      Expr.NeedsAddress (ce.args[0]);
    END;
    ce.type := NIL;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  CONST PHook = ARRAY BOOLEAN OF Runtime.Hook { Runtime.Hook.DisposeRef,
                                                Runtime.Hook.DisposeObj };
  VAR
    e := ce.args[0];
    t := Type.Base (Expr.TypeOf (e));
    proc: Procedure.T;
    info: Type.Info;
  BEGIN
    Expr.PrepLValue (e);
    t := Type.CheckInfo (t, info);
    IF info.isTraced THEN
      Expr.CompileLValue (e);
      CG.Load_nil ();
      CG.Store_indirect (CG.Type.Addr, 0, Target.Address.size);
    ELSE
      proc := Runtime.LookUpProc (PHook [Type.IsSubtype (t, ObjectAdr.T)]);
      Procedure.StartCall (proc);
      Expr.CompileAddress (e);
      CG.Pop_param (CG.Type.Addr);
      EVAL Procedure.EmitCall (proc);
    END;
    Expr.NoteWrite (e);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (&lt;*UNUSED*&gt; ce: CallExpr.T) =
  BEGIN
    (* all the work was done by Prep *)
  END Compile;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, FALSE, FALSE, TRUE, NIL,
                                 NIL,
                                 CallExpr.NotAddressable,
                                 Check,
                                 Prep,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 CallExpr.NoValue,
				 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;DISPOSE&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Dispose.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
