<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/First.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/First.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: First.m3                                              
 Last Modified On Fri Jun 24 12:35:52 PDT 1994 By kalsow     
      Modified On Fri Dec 21 01:35:21 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="First.i3">First</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../types/ArrayType.i3">ArrayType</A>;
IMPORT <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../types/EnumType.i3">EnumType</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../exprs/EnumExpr.i3">EnumExpr</A>, <A HREF="../exprs/TypeExpr.i3">TypeExpr</A>;
IMPORT <A HREF="../builtinTypes/Reel.i3">Reel</A>, <A HREF="../builtinTypes/LReel.i3">LReel</A>, <A HREF="../builtinTypes/EReel.i3">EReel</A>, <A HREF="../exprs/ReelExpr.i3">ReelExpr</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (ce: CallExpr.T): Type.T =
  VAR e: Expr.T;  t, index, element: Type.T;
  BEGIN
    e := ce.args[0];
    t := Expr.TypeOf (e);
    index := NIL;
    IF ArrayType.Split (t, index, element) THEN
      IF (index = NIL) THEN index := Int.T END;
    ELSIF TypeExpr.Split (e, t) THEN
      IF NOT ArrayType.Split (t, index, element) THEN index := t END;
    END;
    IF (index = NIL) THEN index := Int.T; END;
    RETURN Type.Base (index);
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  &lt;*UNUSED*&gt; VAR cs: Expr.CheckState) =
  BEGIN
    DoCheck (&quot;FIRST&quot;, ce);
  END Check;

PROCEDURE <A NAME="DoCheck"><procedure>DoCheck</procedure></A> (name: TEXT;  ce: CallExpr.T) =
  VAR e: Expr.T; t, index, element: Type.T;
  BEGIN
    e := ce.args[0];
    t := Expr.TypeOf (e);
    IF ArrayType.Split (t, index, element) THEN
      IF (index = NIL) THEN index := Int.T END;
    ELSIF TypeExpr.Split (e, t) THEN
      IF ArrayType.Split (t, index, element) THEN
        IF (index = NIL) THEN
          Error.Txt (name, &quot;argument cannot be an open array type&quot;);
          index := Int.T;
        END;
      ELSE
        index := t;
      END;
    ELSE
      Error.Txt (name, &quot;argument must be a type or array&quot;);
      index := Int.T;
    END;
    IF EnumType.Is (index) THEN
      IF TInt.LT (Type.Number (index), TInt.One) THEN
        Error.Txt (name, &quot;empty enumeration type&quot;);
      END;
    ELSIF Type.IsOrdinal (index)             THEN (* ordinal type =&gt; OK*)
    ELSIF Type.IsEqual (index, Reel.T, NIL)  THEN (* OK *)
    ELSIF Type.IsEqual (index, LReel.T, NIL) THEN (* OK *)
    ELSIF Type.IsEqual (index, EReel.T, NIL) THEN (* OK *)
    ELSE
      Error.Txt (name, &quot;argument must be an ordinal type, floating type, array type or array&quot;);
    END;
    ce.type := Type.Base (index);
  END DoCheck;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (&lt;*UNUSED*&gt; ce: CallExpr.T) =
  BEGIN
    (* skip *)
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  VAR
    e := ce.args[0];
    min, max: Target.Int;
    t, index, element: Type.T;
  BEGIN
    IF NOT TypeExpr.Split (e, t) THEN t := Expr.TypeOf (e) END;
    Type.Compile (t);
    IF ArrayType.Split (t, index, element) THEN t := index END;

    IF (t = NIL) THEN (* open array *)
      CG.Load_integer (TInt.Zero);
    ELSIF Type.GetBounds (t, min, max) THEN (* ordinal type *)
      CG.Load_integer (min);
    ELSIF Type.IsEqual (t, Reel.T, NIL) THEN
      CG.Load_float (Target.Real.min);
    ELSIF Type.IsEqual (t, LReel.T, NIL) THEN
      CG.Load_float (Target.Longreal.min);
    ELSIF Type.IsEqual (t, EReel.T, NIL) THEN
      CG.Load_float (Target.Extended.min);
    ELSE
      &lt;* ASSERT FALSE *&gt;
    END;
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR t, index, elem: Type.T;  e: Expr.T;
  BEGIN
    e := ce.args[0];
    IF TypeExpr.Split (e, t) THEN RETURN FirstOfType (t) END;
    t := Expr.TypeOf (e);
    IF NOT ArrayType.Split (t, index, elem) THEN RETURN NIL END;
    RETURN FirstOfType (t);
  END Fold;

PROCEDURE <A NAME="FirstOfType"><procedure>FirstOfType</procedure></A> (t: Type.T): Expr.T =
  VAR min, max: Target.Int;  elem, t_base: Type.T;
  BEGIN
    IF ArrayType.Split (t, t, elem) AND (t = NIL) THEN
      RETURN IntegerExpr.New (TInt.Zero);
    END;
    t_base := Type.Base (t);
    IF Type.GetBounds (t, min, max) THEN
      IF t_base = Int.T
        THEN RETURN IntegerExpr.New (min);
        ELSE RETURN EnumExpr.New (t, min);
      END;
    ELSIF t_base = Reel.T THEN
      RETURN ReelExpr.New (Target.Real.min, ReelExpr.Precision.Short);
    ELSIF t_base = LReel.T THEN
      RETURN ReelExpr.New (Target.Longreal.min, ReelExpr.Precision.Long);
    ELSIF t_base = EReel.T THEN
      RETURN ReelExpr.New (Target.Extended.min, ReelExpr.Precision.Extended);
    ELSE
      RETURN NIL;
    END;
  END FirstOfType;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, FALSE, NIL,
                                 TypeOf,
                                 CallExpr.NotAddressable,
                                 Check,
                                 Prep,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.PrepNoBranch,
                                 CallExpr.NoBranch,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;FIRST&quot;, Z, TRUE);
  END Initialize;

BEGIN
END First.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
