<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Floatt.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Floatt.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Floatt.m3                                             
 Last Modified On Tue May  3 16:30:33 PDT 1994 By kalsow     
      Modified On Sat Dec  8 00:54:23 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="Floatt.i3">Floatt</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../builtinTypes/Reel.i3">Reel</A>, <A HREF="../builtinTypes/LReel.i3">LReel</A>, <A HREF="../builtinTypes/EReel.i3">EReel</A>, <A HREF="../builtinTypes/Int.i3">Int</A>;
IMPORT <A HREF="../misc/Error.i3">Error</A>, <A HREF="../exprs/ReelExpr.i3">ReelExpr</A>, <A HREF="../exprs/TypeExpr.i3">TypeExpr</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (ce: CallExpr.T): Type.T =
  VAR u: Type.T;
  BEGIN
    u := Reel.T;
    IF (NUMBER (ce.args^) &gt; 1) THEN
      EVAL TypeExpr.Split (ce.args[1], u);
    END;
    RETURN Type.Base (u);
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  VAR t, u: Type.T;  e: Expr.T;
  BEGIN
    INC (cs.fp_ops);
    e := ce.args[0];

    u := Reel.T;
    IF (NUMBER (ce.args^) &gt; 1) THEN
      IF NOT TypeExpr.Split (ce.args[1], u) THEN
        Error.Msg (&quot;FLOAT: second argument must be a floating point type&quot;);
      END;
      u := Type.Base (u);
    END;

    t := Type.Base (Expr.TypeOf (ce.args[0]));
    IF (t # Int.T) AND (t # Reel.T) AND (t # LReel.T) AND (t # EReel.T) THEN
      Error.Msg (&quot;FLOAT: wrong first argument type&quot;);
    END;

    IF (u # Reel.T) AND (u # LReel.T) AND (u # EReel.T) THEN
      Error.Msg (&quot;FLOAT: wrong second argument type&quot;);
    END;

    ce.type := u;
  END Check;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.Prep (ce.args[0]);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  VAR
    e := ce.args[0];
    t := Expr.TypeOf (e);
    u := Reel.T;
  BEGIN
    IF (NUMBER (ce.args^) &gt; 1) THEN
      EVAL TypeExpr.Split (ce.args[1], u);
      u := Type.Base (u);
    END;
    Expr.Compile (e);
    CG.Cvt_float (Type.CGType (t), Type.CGType (u));
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e, x: Expr.T;  t: Type.T;
  BEGIN
    e := Expr.ConstValue (ce.args[0]);
    IF (e = NIL) THEN RETURN NIL END;

    t := Reel.T;
    IF (NUMBER (ce.args^) &gt; 1) THEN
      IF NOT TypeExpr.Split (ce.args[1], t) THEN RETURN NIL END;
    END;

    IF ReelExpr.Float (e, t, x)
      THEN  RETURN x;
      ELSE  RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 2, TRUE, FALSE, TRUE, NIL,
                                 TypeOf,
                                 CallExpr.NotAddressable,
                                 Check,
                                 Prep,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.NotBoolean,
                                 CallExpr.NotBoolean,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;FLOAT&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Floatt.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
