<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Loophole.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Loophole.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Loophole.m3                                           
 Last Modified On Tue May  3 16:36:31 PDT 1994 By kalsow     
      Modified On Sat Dec  8 00:57:40 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="Loophole.i3">Loophole</A></implements></module>;

IMPORT <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../exprs/CastExpr.i3">CastExpr</A>;
IMPORT <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../values/Module.i3">Module</A>, <A HREF="../exprs/TypeExpr.i3">TypeExpr</A>, <A HREF="../misc/Error.i3">Error</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (ce: CallExpr.T): Type.T =
  VAR t: Type.T := Int.T;
  BEGIN
    IF TypeExpr.Split (ce.args[1], t) THEN (*ok*) END;
    RETURN t;
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  VAR cs: Expr.CheckState) =
  VAR t: Type.T;
  BEGIN
    IF NOT TypeExpr.Split (ce.args[1], t) THEN
      Error.Msg (&quot;LOOPHOLE: second argument must be a type&quot;);
      t := Int.T;
    END;
    ce.args[0] := CastExpr.New (ce.args[0], t);
    IF Module.IsSafe () THEN Error.Msg (&quot;LOOPHOLE: unsafe operation&quot;) END;
    Expr.TypeCheck (ce.args[0], cs);
    ce.type := t;
  END Check;

PROCEDURE <A NAME="NeedsAddress"><procedure>NeedsAddress</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.NeedsAddress (ce.args[0]);
  END NeedsAddress;

PROCEDURE <A NAME="Prep"><procedure>Prep</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.Prep (ce.args[0]);
  END Prep;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.Compile (ce.args[0]);
  END Compile;

PROCEDURE <A NAME="PrepLV"><procedure>PrepLV</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.PrepLValue (ce.args[0]);
  END PrepLV;

PROCEDURE <A NAME="CompileLV"><procedure>CompileLV</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.CompileLValue (ce.args[0]);
  END CompileLV;

PROCEDURE <A NAME="IsWritable"><procedure>IsWritable</procedure></A> (ce: CallExpr.T): BOOLEAN =
  BEGIN
    RETURN Expr.IsWritable (ce.args[0]);
  END IsWritable;

PROCEDURE <A NAME="IsDesignator"><procedure>IsDesignator</procedure></A> (ce: CallExpr.T): BOOLEAN =
  BEGIN
    RETURN Expr.IsDesignator (ce.args[0]);
  END IsDesignator;

PROCEDURE <A NAME="NoteWrites"><procedure>NoteWrites</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.NoteWrite (ce.args[0]);
  END NoteWrites;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (2, 2, TRUE, FALSE, TRUE, NIL,
                                 TypeOf,
                                 NeedsAddress,
                                 Check,
                                 Prep,
                                 Compile,
                                 PrepLV,
                                 CompileLV,
                                 CallExpr.PrepNoBranch,
                                 CallExpr.NoBranch,
                                 CallExpr.NoValue, (*fold*)
                                 IsWritable,
                                 IsDesignator,
                                 NoteWrites);
    Procedure.Define (&quot;LOOPHOLE&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Loophole.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
