<HTML>
<HEAD>
<TITLE>SRC Modula-3: m3front/src/builtinOps/Max.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>m3front/src/builtinOps/Max.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE> File: Max.m3                                                
 Last Modified On Fri Jun 24 09:38:26 PDT 1994 By kalsow     
      Modified On Fri Dec 21 01:02:24 1990 By muller         

<P><PRE>MODULE <module><implements><A HREF="Max.i3">Max</A></implements></module>;

IMPORT <A HREF="../misc/CG.i3">CG</A>, <A HREF="../exprs/CallExpr.i3">CallExpr</A>, <A HREF="../exprs/Expr.i3">Expr</A>, <A HREF="../exprs/ExprRep.i3">ExprRep</A>, <A HREF="../types/Type.i3">Type</A>, <A HREF="../values/Procedure.i3">Procedure</A>, <A HREF="../misc/Error.i3">Error</A>, <A HREF="../../../m3middle/src/Target.i3">Target</A>, <A HREF="../../../m3middle/src/TInt.i3">TInt</A>;
IMPORT <A HREF="../builtinTypes/Int.i3">Int</A>, <A HREF="../builtinTypes/Reel.i3">Reel</A>, <A HREF="../builtinTypes/LReel.i3">LReel</A>, <A HREF="../builtinTypes/EReel.i3">EReel</A>, <A HREF="../exprs/IntegerExpr.i3">IntegerExpr</A>, <A HREF="../exprs/EnumExpr.i3">EnumExpr</A>, <A HREF="../exprs/ReelExpr.i3">ReelExpr</A>;

VAR Z: CallExpr.MethodList;

PROCEDURE <A NAME="TypeOf"><procedure>TypeOf</procedure></A> (ce: CallExpr.T): Type.T =
  BEGIN
    RETURN Type.Base (Expr.TypeOf (ce.args[0]));
  END TypeOf;

PROCEDURE <A NAME="Check"><procedure>Check</procedure></A> (ce: CallExpr.T;  &lt;*UNUSED*&gt; VAR cs: Expr.CheckState) =
  BEGIN
    DoCheck (&quot;MAX&quot;, ce);
  END Check;

PROCEDURE <A NAME="DoCheck"><procedure>DoCheck</procedure></A> (name: TEXT;  ce: CallExpr.T) =
  VAR ta, tb: Type.T;
  BEGIN
    ta := Type.Base (Expr.TypeOf (ce.args[0]));
    tb := Type.Base (Expr.TypeOf (ce.args[1]));

    IF (NOT Type.IsEqual (ta, tb, NIL)) THEN
      Error.Txt (name, &quot;incompatible argument types&quot;);
    ELSIF (ta = Int.T) OR (Type.IsOrdinal (ta)) THEN
      (* ok *)
    ELSIF (ta = Reel.T) OR (ta = LReel.T) OR (ta = EReel.T) THEN
      (* ok *)
    ELSE
      Error.Txt (name, &quot;wrong argument types&quot;);
      ta := Int.T;
    END;
    ce.type := ta;
  END DoCheck;

PROCEDURE <A NAME="Compile"><procedure>Compile</procedure></A> (ce: CallExpr.T) =
  BEGIN
    Expr.Compile (ce.args[0]);
    Expr.Compile (ce.args[1]);
    CG.Max (Type.CGType (Type.Base (Expr.TypeOf (ce.args[0]))));
  END Compile;

PROCEDURE <A NAME="Fold"><procedure>Fold</procedure></A> (ce: CallExpr.T): Expr.T =
  VAR e1, e2, e3: Expr.T;  i1, i2: Target.Int;  t: Type.T;
  BEGIN
    e1 := Expr.ConstValue (ce.args[0]);
    IF (e1 = NIL) THEN RETURN NIL END;
    e2 := Expr.ConstValue (ce.args[1]);
    IF (e2 = NIL) THEN RETURN NIL END;

    IF IntegerExpr.Split (e1, i1) AND IntegerExpr.Split (e2, i2) THEN
      IF TInt.LT (i1, i2)
        THEN RETURN e2;
        ELSE RETURN e1;
      END;
    ELSIF EnumExpr.Split (e1, i1, t) AND EnumExpr.Split (e2, i2, t) THEN
      IF TInt.LT (i1, i2)
        THEN RETURN e2;
        ELSE RETURN e1;
      END;
    ELSIF ReelExpr.Max (e1, e2, e3) THEN
      RETURN e3;
    ELSE
      RETURN NIL;
    END;
  END Fold;

PROCEDURE <A NAME="Initialize"><procedure>Initialize</procedure></A> () =
  BEGIN
    Z := CallExpr.NewMethodList (2, 2, TRUE, FALSE, TRUE, NIL,
                                 TypeOf,
                                 CallExpr.NotAddressable,
                                 Check,
                                 CallExpr.PrepArgs,
                                 Compile,
                                 CallExpr.NoLValue,
                                 CallExpr.NoLValue,
                                 CallExpr.PrepNoBranch,
                                 CallExpr.NoBranch,
                                 Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define (&quot;MAX&quot;, Z, TRUE);
  END Initialize;

BEGIN
END Max.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
